/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.filter;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webcontainer.filter.extended.IFilterMappingExtended;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.filter.IFilterConfig;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import jakarta.servlet.DispatcherType;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FilterMapping
implements IFilterMappingExtended {
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.filter");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.filter.FilterMapping";
    private String urlPattern;
    private DispatcherType[] dispatchMode = new DispatcherType[]{DispatcherType.REQUEST};
    private IFilterConfig filterConfig;
    private IServletConfig sconfig;
    private int mappingType;
    private String servletName;

    @Override
    public int getMappingType() {
        return this.mappingType;
    }

    public FilterMapping(String urlPattern, IFilterConfig fconfig, IServletConfig sconfig) {
        this.filterConfig = fconfig;
        if (urlPattern != null) {
            this.setUrlPattern(urlPattern);
        }
        this.sconfig = sconfig;
    }

    @Override
    public IFilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    @Override
    public String getUrlPattern() {
        return this.urlPattern;
    }

    @Override
    public void setFilterConfig(IFilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    @Override
    public void setUrlPattern(String filterURI) {
        if (filterURI.equals("/")) {
            this.mappingType = 0;
        } else if (filterURI.startsWith("/") && filterURI.endsWith("/*")) {
            this.mappingType = 1;
            filterURI = filterURI.substring(0, filterURI.length() - 2);
        } else if (filterURI.startsWith("*.")) {
            this.mappingType = 2;
        } else if (WCCustomProperties.MAP_FILTERS_TO_ASTERICK && filterURI.equals("*")) {
            this.mappingType = 1;
            filterURI = "";
        } else {
            this.mappingType = 3;
        }
        this.urlPattern = filterURI;
    }

    @Override
    public IServletConfig getServletConfig() {
        return this.sconfig;
    }

    @Override
    public DispatcherType[] getDispatchMode() {
        return this.dispatchMode;
    }

    @Override
    public void setDispatchMode(DispatcherType[] dispatchMode) {
        this.dispatchMode = dispatchMode;
    }

    @Override
    public String getServletFilterMappingName() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getServletFilterMappingName", "servlet name " + this.servletName + " , filter mapping -> " + this);
        }
        return this.servletName;
    }

    @Override
    public void saveServletFilterMappingName(String sName) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "saveServletFilterMappingName", "servlet name " + sName + " , filter mapping -> " + this);
        }
        this.servletName = sName;
    }

    @Override
    public void setServletConfig(IServletConfig sconfig) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setServletConfig", "set ServletConfig to {" + sconfig + "} , filter mapping -> " + this);
        }
        this.sconfig = sconfig;
    }
}

