/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extension.trace.propagation;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.extension.trace.propagation.B3PropagatorExtractor;
import io.opentelemetry.extension.trace.propagation.B3PropagatorExtractorMultipleHeaders;
import io.opentelemetry.extension.trace.propagation.B3PropagatorExtractorSingleHeader;
import io.opentelemetry.extension.trace.propagation.B3PropagatorInjector;
import io.opentelemetry.extension.trace.propagation.B3PropagatorInjectorMultipleHeaders;
import io.opentelemetry.extension.trace.propagation.B3PropagatorInjectorSingleHeader;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class B3Propagator
implements TextMapPropagator {
    static final String TRACE_ID_HEADER = "X-B3-TraceId";
    static final String SPAN_ID_HEADER = "X-B3-SpanId";
    static final String SAMPLED_HEADER = "X-B3-Sampled";
    static final String DEBUG_HEADER = "X-B3-Flags";
    static final String COMBINED_HEADER = "b3";
    static final String COMBINED_HEADER_DELIMITER = "-";
    static final ContextKey<Boolean> DEBUG_CONTEXT_KEY = ContextKey.named("b3-debug");
    static final String MULTI_HEADER_DEBUG = "1";
    static final String SINGLE_HEADER_DEBUG = "d";
    static final char COMBINED_HEADER_DELIMITER_CHAR = '-';
    static final char IS_SAMPLED = '1';
    static final char NOT_SAMPLED = '0';
    static final char DEBUG_SAMPLED = 'd';
    private static final B3Propagator SINGLE_HEADER_INSTANCE = new B3Propagator(new B3PropagatorInjectorSingleHeader());
    private static final B3Propagator MULTI_HEADERS_INSTANCE = new B3Propagator(new B3PropagatorInjectorMultipleHeaders());
    private final B3PropagatorExtractor singleHeaderExtractor = new B3PropagatorExtractorSingleHeader();
    private final B3PropagatorExtractor multipleHeadersExtractor = new B3PropagatorExtractorMultipleHeaders();
    private final B3PropagatorInjector b3PropagatorInjector;

    private B3Propagator(B3PropagatorInjector b3PropagatorInjector) {
        this.b3PropagatorInjector = b3PropagatorInjector;
    }

    public static B3Propagator injectingMultiHeaders() {
        return MULTI_HEADERS_INSTANCE;
    }

    public static B3Propagator injectingSingleHeader() {
        return SINGLE_HEADER_INSTANCE;
    }

    @Override
    public Collection<String> fields() {
        return this.b3PropagatorInjector.fields();
    }

    @Override
    public <C> void inject(Context context, @Nullable C carrier, TextMapSetter<C> setter) {
        this.b3PropagatorInjector.inject(context, carrier, setter);
    }

    @Override
    public <C> Context extract(Context context, @Nullable C carrier, TextMapGetter<C> getter) {
        return Stream.of(() -> this.singleHeaderExtractor.extract(context, carrier, getter), () -> this.multipleHeadersExtractor.extract(context, carrier, getter), () -> Optional.of(context)).map(Supplier::get).filter(Optional::isPresent).map(Optional::get).findFirst().get();
    }
}

