/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.internal;

import com.ibm.ws.kernel.boot.BootstrapConfig;
import com.ibm.ws.kernel.boot.Debug;
import com.ibm.ws.kernel.boot.LaunchException;
import com.ibm.ws.kernel.boot.ReturnCode;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.boot.internal.BootstrapConstants;
import com.ibm.ws.kernel.boot.internal.FileUtils;
import com.ibm.ws.kernel.boot.internal.ProcessStatus;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;

public class ServerLock {
    private static final boolean EXISTS = true;
    private static final boolean CAN_WRITE = false;
    private final String serverName;
    private final File lockFile;
    private volatile FileLock serverLock = null;
    private volatile FileChannel lockFileChannel = null;

    public static ServerLock createTestLock(BootstrapConfig bootProps) {
        String serverName = bootProps.getProcessName();
        File serverWorkArea = bootProps.getWorkareaFile(null);
        ServerLock serverLock = new ServerLock(serverName, serverWorkArea);
        return serverLock;
    }

    public static ServerLock createServerLock(BootstrapConfig bootProps) {
        String serverName = bootProps.getProcessName();
        File serverDir = bootProps.getConfigFile(null);
        File serverOutputDir = bootProps.getOutputFile(null);
        File serverWorkArea = bootProps.getWorkareaFile(null);
        ServerLock serverLock = new ServerLock(serverName, serverWorkArea);
        Boolean fileExists = null;
        File sDir = serverDir;
        try {
            fileExists = AccessController.doPrivileged(new FileCheckAction(sDir, true));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fileExists != null && !fileExists.booleanValue()) {
            return serverLock;
        }
        boolean writable = true;
        File soDir = serverOutputDir;
        try {
            fileExists = AccessController.doPrivileged(new FileCheckAction(soDir, true));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fileExists != null && !fileExists.booleanValue()) {
            writable = serverWorkArea.mkdirs();
        }
        Boolean canWrite = null;
        try {
            canWrite = AccessController.doPrivileged(new FileCheckAction(soDir, false));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!writable || canWrite != null && !canWrite.booleanValue()) {
            throw new LaunchException("Write permission required for server output directory, check directory permissions", MessageFormat.format(BootstrapConstants.messages.getString("error.serverDirPermission"), serverOutputDir.getAbsolutePath()));
        }
        File swArea = serverWorkArea;
        try {
            fileExists = AccessController.doPrivileged(new FileCheckAction(swArea, true));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fileExists != null && !fileExists.booleanValue()) {
            writable = serverWorkArea.mkdirs();
        }
        try {
            canWrite = AccessController.doPrivileged(new FileCheckAction(swArea, false));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!writable || canWrite != null && !canWrite.booleanValue()) {
            throw new LaunchException("Can not create server workarea, check directory permissions", MessageFormat.format(BootstrapConstants.messages.getString("error.serverDirPermission"), serverWorkArea.getAbsolutePath()));
        }
        writable = true;
        File slf = serverLock.lockFile;
        try {
            fileExists = AccessController.doPrivileged(new FileCheckAction(slf, true));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fileExists != null && !fileExists.booleanValue()) {
            try {
                writable = serverLock.lockFile.createNewFile();
            }
            catch (IOException e) {
                writable = false;
            }
        }
        try {
            canWrite = AccessController.doPrivileged(new FileCheckAction(slf, false));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!writable || !canWrite.booleanValue()) {
            throw new LaunchException("Can not create or write to lock file, check file permissions", MessageFormat.format(BootstrapConstants.messages.getString("error.serverDirPermission"), serverLock.lockFile.getAbsolutePath()));
        }
        return serverLock;
    }

    private ServerLock(String serverName, File serverWorkArea) throws LaunchException {
        this.serverName = serverName;
        this.lockFile = new File(serverWorkArea, ".sLock");
    }

    public synchronized void obtainServerLock() {
        this.getServerLock();
        if (this.serverLock == null || !this.serverLock.isValid()) {
            this.serverLock = null;
            this.lockFileChannel = null;
            String lockFilePath = this.lockFile.getAbsolutePath();
            LaunchException le = new LaunchException("Server(" + this.serverName + ") is already running.  lockFile=" + lockFilePath, MessageFormat.format(BootstrapConstants.messages.getString("error.serverAlreadyRunning"), this.serverName, lockFilePath));
            le.setReturnCode(ReturnCode.REDUNDANT_ACTION_STATUS);
            throw le;
        }
    }

    private synchronized boolean getServerLock() {
        return this.getServerLock(System.currentTimeMillis() + (long)(Integer.valueOf("30") * 1000));
    }

    private synchronized boolean getServerLock(long endTime) {
        block13: {
            Boolean fileExists = Boolean.FALSE;
            File sDir = this.lockFile;
            try {
                fileExists = AccessController.doPrivileged(new FileCheckAction(sDir, true));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!fileExists.booleanValue()) {
                return false;
            }
            FileOutputStream fos = null;
            FileChannel fc = null;
            try {
                fos = new FileOutputStream(this.lockFile);
                fc = fos.getChannel();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                while (true) {
                    this.serverLock = fc.tryLock();
                    if (this.serverLock != null) break;
                    try {
                        long timeNow = System.currentTimeMillis();
                        if (timeNow <= endTime) {
                            Thread.sleep(500L);
                        }
                        break;
                    }
                    catch (InterruptedException timeNow) {}
                }
            }
            catch (OverlappingFileLockException e) {
                if (!Utils.tryToClose(fc)) {
                    Utils.tryToClose(fos);
                }
            }
            catch (IOException e) {
                if (Utils.tryToClose(fc)) break block13;
                Utils.tryToClose(fos);
            }
        }
        return this.serverLock != null && this.serverLock.isValid();
    }

    private synchronized boolean tryServerLock() throws IOException {
        if (!this.lockFile.exists() || this.lockFileChannel == null) {
            return false;
        }
        boolean lockObtained = true;
        try {
            this.serverLock = this.lockFileChannel.tryLock();
            if (this.serverLock == null || !this.serverLock.isValid()) {
                lockObtained = false;
            }
        }
        catch (OverlappingFileLockException e) {
            lockObtained = false;
        }
        catch (IOException e) {
            lockObtained = false;
        }
        finally {
            if (this.serverLock != null) {
                this.serverLock.release();
            }
        }
        return lockObtained;
    }

    public boolean lockFileExists() {
        Boolean fileExists = Boolean.FALSE;
        File sDir = this.lockFile;
        try {
            fileExists = AccessController.doPrivileged(new FileCheckAction(sDir, true));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fileExists != false;
    }

    public synchronized void releaseServerLock() {
        if (this.serverLock != null) {
            try {
                this.serverLock.release();
            }
            catch (IOException iOException) {
            }
            finally {
                Utils.tryToClose(this.lockFileChannel);
            }
            this.serverLock = null;
            this.lockFileChannel = null;
        }
    }

    public synchronized ReturnCode waitForStop() {
        return this.waitForStop(System.currentTimeMillis() + (long)(Integer.valueOf("30") * 1000));
    }

    public synchronized ReturnCode waitForStop(long endTime) {
        if (!this.getServerLock(endTime)) {
            this.serverLock = null;
            this.lockFileChannel = null;
            System.out.println(MessageFormat.format(BootstrapConstants.messages.getString("error.stopServerError"), this.serverName, this.lockFile.getAbsolutePath()));
            return ReturnCode.ERROR_SERVER_STOP;
        }
        this.releaseServerLock();
        return ReturnCode.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReturnCode waitForStart(ProcessStatus ps) {
        FileOutputStream fos = null;
        FileChannel fc = null;
        try {
            int attempts = 0;
            boolean fileObtained = true;
            int waitCycles = this.calculateWaitCyclesFromWaitTime();
            while (fileObtained && attempts++ < waitCycles) {
                block14: {
                    try {
                        Thread.sleep(500L);
                        if (!this.lockFile.exists()) break block14;
                        try {
                            if (this.lockFileChannel == null) {
                                fos = new FileOutputStream(this.lockFile);
                                this.lockFileChannel = fc = fos.getChannel();
                            }
                            fileObtained = this.tryServerLock();
                        }
                        catch (IOException e) {
                            Debug.printStackTrace(e);
                            ReturnCode returnCode = ReturnCode.ERROR_SERVER_START;
                            this.releaseServerLock();
                            return returnCode;
                        }
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                ProcessStatus.State possiblyRunning = ps.isPossiblyRunning();
                if (fileObtained && possiblyRunning == ProcessStatus.State.NO) {
                    Debug.println("Server start error: file lock obtained, and server process is not running.");
                    ReturnCode returnCode = ReturnCode.ERROR_SERVER_START;
                    return returnCode;
                }
                if (!fileObtained || possiblyRunning != ProcessStatus.State.YES || attempts <= 2 || !FileUtils.isWSL()) continue;
                ReturnCode returnCode = ReturnCode.OK;
                return returnCode;
            }
            if (fileObtained) {
                Debug.println("Server start error: file lock obtained, and server process is running.");
                ReturnCode returnCode = ReturnCode.ERROR_SERVER_START;
                return returnCode;
            }
        }
        finally {
            this.releaseServerLock();
        }
        return ReturnCode.OK;
    }

    private int calculateWaitCyclesFromWaitTime() {
        String serverWaitTime = System.getProperty("server.start.wait.time");
        if (serverWaitTime == null || serverWaitTime.trim().equals("")) {
            return 60;
        }
        int waitTime = 0;
        try {
            waitTime = Integer.parseInt(System.getProperty("server.start.wait.time"));
            if (waitTime < 1) {
                return 1;
            }
        }
        catch (Throwable t) {
            return 60;
        }
        int waitCycles = (int)(TimeUnit.MILLISECONDS.convert(waitTime, TimeUnit.SECONDS) / 500L);
        return waitCycles;
    }

    public boolean testServerRunning() {
        if (!this.lockFile.exists()) {
            return false;
        }
        try {
            FileOutputStream fos = new FileOutputStream(this.lockFile);
            this.lockFileChannel = fos.getChannel();
            if (this.tryServerLock()) {
                return false;
            }
        }
        catch (IOException e) {
            Debug.printStackTrace(e);
        }
        return true;
    }

    public static void createServerRunningMarkerFile(BootstrapConfig bootConfig) {
        File serverWorkArea = bootConfig.getWorkareaFile(null);
        File serverRunningMarkerFile = null;
        try {
            serverRunningMarkerFile = new File(serverWorkArea, ".sRunning");
            serverRunningMarkerFile.deleteOnExit();
            boolean newFile = serverRunningMarkerFile.createNewFile();
            if (!newFile) {
                bootConfig.forceCleanStart();
            }
        }
        catch (IOException e) {
            throw new LaunchException("Can not create or write to server running marker file, check file permissions", MessageFormat.format(BootstrapConstants.messages.getString("error.serverDirPermission"), serverRunningMarkerFile.getAbsolutePath()), e);
        }
    }

    private static class FileCheckAction
    implements PrivilegedExceptionAction<Boolean> {
        private final File file;
        private final boolean existsOrCanWrite;

        FileCheckAction(File file, boolean existsOrCanWrite) {
            this.file = file;
            this.existsOrCanWrite = existsOrCanWrite;
        }

        @Override
        public Boolean run() throws Exception {
            return this.existsOrCanWrite ? this.file.exists() : this.file.canWrite();
        }
    }
}

