/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.zipkin;

import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.internal.ExporterMetrics;
import io.opentelemetry.exporter.zipkin.OtelToZipkinSpanTransformer;
import io.opentelemetry.exporter.zipkin.ZipkinSpanExporterBuilder;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import zipkin2.Span;
import zipkin2.reporter.BytesEncoder;
import zipkin2.reporter.BytesMessageSender;
import zipkin2.reporter.Encoding;

public final class ZipkinSpanExporter
implements SpanExporter {
    public static final Logger baseLogger = Logger.getLogger(ZipkinSpanExporter.class.getName());
    public static final String DEFAULT_ENDPOINT = "http://localhost:9411/api/v2/spans";
    private final ThrottlingLogger logger = new ThrottlingLogger(baseLogger);
    private final AtomicBoolean isShutdown = new AtomicBoolean();
    private final ZipkinSpanExporterBuilder builder;
    private final BytesEncoder<Span> encoder;
    private final BytesMessageSender sender;
    private final ExporterMetrics exporterMetrics;
    private final OtelToZipkinSpanTransformer transformer;

    ZipkinSpanExporter(ZipkinSpanExporterBuilder builder, BytesEncoder<Span> encoder, BytesMessageSender sender, Supplier<MeterProvider> meterProviderSupplier, OtelToZipkinSpanTransformer transformer) {
        this.builder = builder;
        this.encoder = encoder;
        this.sender = sender;
        this.exporterMetrics = sender.encoding() == Encoding.JSON ? ExporterMetrics.createHttpJson("zipkin", "span", meterProviderSupplier) : ExporterMetrics.createHttpProtobuf("zipkin", "span", meterProviderSupplier);
        this.transformer = transformer;
    }

    @Override
    public CompletableResultCode export(Collection<SpanData> spanDataList) {
        if (this.isShutdown.get()) {
            return CompletableResultCode.ofFailure();
        }
        int numItems = spanDataList.size();
        this.exporterMetrics.addSeen(numItems);
        ArrayList<byte[]> encodedSpans = new ArrayList<byte[]>(numItems);
        for (SpanData spanData : spanDataList) {
            Span zipkinSpan = this.transformer.generateSpan(spanData);
            encodedSpans.add(this.encoder.encode((Object)zipkinSpan));
        }
        try {
            this.sender.send(encodedSpans);
            this.exporterMetrics.addSuccess(numItems);
            return CompletableResultCode.ofSuccess();
        }
        catch (IOException | RuntimeException t) {
            this.exporterMetrics.addFailed(numItems);
            this.logger.log(Level.WARNING, "Failed to export spans", t);
            return CompletableResultCode.ofFailure();
        }
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            this.logger.log(Level.INFO, "Calling shutdown() multiple times.");
            return CompletableResultCode.ofSuccess();
        }
        try {
            this.sender.close();
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Exception while closing the Zipkin Sender instance", e);
        }
        return CompletableResultCode.ofSuccess();
    }

    public String toString() {
        return "ZipkinSpanExporter{" + this.builder.toString(false) + "}";
    }

    public static ZipkinSpanExporterBuilder builder() {
        return new ZipkinSpanExporterBuilder();
    }
}

