/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.beanvalidation.v20.cdi.internal;

import com.ibm.ejs.util.dopriv.SetContextClassLoaderPrivileged;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.beanvalidation.AbstractBeanValidation;
import com.ibm.ws.beanvalidation.service.Validation20ClassLoader;
import com.ibm.ws.beanvalidation.v20.cdi.internal.LibertyValidatorBean;
import com.ibm.ws.beanvalidation.v20.cdi.internal.LibertyValidatorFactoryBean;
import com.ibm.ws.cdi.CDIService;
import com.ibm.ws.cdi.extension.WebSphereCDIExtension;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.util.ThreadContextAccessor;
import com.ibm.wsspi.classloading.ClassLoadingService;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessBean;
import jakarta.enterprise.inject.spi.WithAnnotations;
import jakarta.validation.Constraint;
import jakarta.validation.Valid;
import jakarta.validation.executable.ValidateOnExecution;
import java.security.AccessController;
import java.security.ProtectionDomain;
import org.hibernate.validator.cdi.ValidationExtension;
import org.hibernate.validator.cdi.internal.ValidatorBean;
import org.hibernate.validator.cdi.internal.ValidatorFactoryBean;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"api.classes=jakarta.validation.Validator;jakarta.validation.ValidatorFactory;org.hibernate.validator.HibernateValidatorFactory;org.hibernate.validator.cdi.internal.ValidatorFactoryBean;org.hibernate.validator.cdi.HibernateValidator;org.hibernate.validator.cdi.ValidationExtension;org.hibernate.validator.cdi.internal.interceptor.ValidationInterceptor;org.hibernate.validator.internal.engine.ValidatorImpl;org.hibernate.validator.internal.engine.ValidatorFactoryImpl;org.hibernate.validator.cdi.internal.InjectingConstraintValidatorFactory;com.ibm.ws.beanvalidation.v20.cdi.internal.LibertyValidatorBean;com.ibm.ws.beanvalidation.v20.cdi.internal.LibertyValidatorFactoryBean", "service.vendor=IBM"})
public class LibertyHibernateValidatorExtension
implements Extension,
WebSphereCDIExtension {
    private static final TraceComponent tc = Tr.register(LibertyHibernateValidatorExtension.class, (String)"BeanValidation", (String)"com.ibm.ws.beanvalidation.v20.cdi.internal.BVNLSMessages");
    @Reference
    protected ClassLoadingService classLoadingService;
    private ValidatorFactoryBean vfBean;
    private ValidatorBean vBean;
    private ValidationExtension extDelegate;
    private String currentClassloaderHint = "";
    private boolean delegateFailed;
    static final long serialVersionUID = -2449486117829373130L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidationExtension delegate(String newClassloaderHint) {
        if (this.extDelegate == null || newClassloaderHint != null && !newClassloaderHint.equals(this.currentClassloaderHint)) {
            AbstractBeanValidation.ClassLoaderTuple tuple;
            block9: {
                SetContextClassLoaderPrivileged setClassLoader = null;
                ClassLoader oldClassLoader = null;
                tuple = null;
                try {
                    tuple = this.configureBvalClassloader(null);
                    ClassLoader tcclClassLoaderTmp = tuple.classLoader;
                    ClassLoader bvalClassLoader = newClassloaderHint != null ? AccessController.doPrivileged(() -> new Validation20ClassLoader(tcclClassLoaderTmp, newClassloaderHint)) : tcclClassLoaderTmp;
                    ThreadContextAccessor tca = AccessController.doPrivileged(() -> ThreadContextAccessor.getThreadContextAccessor());
                    setClassLoader = new SetContextClassLoaderPrivileged(tca);
                    oldClassLoader = setClassLoader.execute(bvalClassLoader);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Called setClassLoader with oldClassLoader of " + oldClassLoader + " and newClassLoader of " + bvalClassLoader), (Object[])new Object[0]);
                    }
                    this.extDelegate = new ValidationExtension();
                    this.currentClassloaderHint = newClassloaderHint;
                    if (setClassLoader == null) break block9;
                }
                catch (Throwable throwable) {
                    if (setClassLoader != null) {
                        setClassLoader.execute(oldClassLoader);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Set Class loader back to " + oldClassLoader), (Object[])new Object[0]);
                        }
                    }
                    if (tuple != null && tuple.wasCreatedViaClassLoadingService) {
                        this.releaseLoader(tuple.classLoader);
                    }
                    throw throwable;
                }
                setClassLoader.execute(oldClassLoader);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Set Class loader back to " + oldClassLoader), (Object[])new Object[0]);
                }
            }
            if (tuple != null && tuple.wasCreatedViaClassLoadingService) {
                this.releaseLoader(tuple.classLoader);
            }
        }
        return this.extDelegate;
    }

    /*
     * WARNING - void declaration
     */
    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscoveryEvent, BeanManager beanManager) {
        block3: {
            if (!this.delegateFailed) {
                try {
                    this.delegate(null).beforeBeanDiscovery(beforeBeanDiscoveryEvent, beanManager);
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.beanvalidation.v20.cdi.internal.LibertyHibernateValidatorExtension", (String)"128", (Object)this, (Object[])new Object[]{beforeBeanDiscoveryEvent, beanManager});
                    this.delegateFailed = true;
                    String appName = this.getAppName();
                    if (!tc.isWarningEnabled()) break block3;
                    Tr.warning((TraceComponent)tc, (String)"UNABLE_TO_REGISTER_WITH_CDI", (Object[])new Object[]{appName == null ? beanManager.toString() : appName, e});
                }
            }
        }
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscoveryEvent, BeanManager beanManager) {
        if (this.delegateFailed) {
            return;
        }
        if (this.vfBean == null) {
            this.vfBean = new LibertyValidatorFactoryBean();
            afterBeanDiscoveryEvent.addBean((Bean)this.vfBean);
        }
        if (this.vBean == null) {
            this.vBean = new LibertyValidatorBean();
            afterBeanDiscoveryEvent.addBean((Bean)this.vBean);
        }
    }

    public void processBean(@Observes ProcessBean<?> processBeanEvent) {
        if (this.delegateFailed) {
            return;
        }
        this.delegate(null).processBean(processBeanEvent);
    }

    public <T> void processAnnotatedType(@Observes @WithAnnotations(value={Constraint.class, Valid.class, ValidateOnExecution.class}) ProcessAnnotatedType<T> processAnnotatedTypeEvent) {
        if (this.delegateFailed) {
            return;
        }
        Class javaClass = processAnnotatedTypeEvent.getAnnotatedType().getJavaClass();
        String moduleName = this.getModuleName(javaClass);
        this.delegate(moduleName).processAnnotatedType(processAnnotatedTypeEvent);
    }

    private String getModuleName(Class<?> javaClass) {
        int index;
        ProtectionDomain protectionDomain = AccessController.doPrivileged(() -> javaClass.getProtectionDomain());
        String moduleName = protectionDomain.getCodeSource().getLocation().getPath();
        if (moduleName.endsWith("/WEB-INF/classes/")) {
            moduleName = moduleName.substring(0, moduleName.length() - 17);
        }
        if ((index = moduleName.lastIndexOf(47)) > -1) {
            moduleName = moduleName.substring(index);
        }
        return moduleName;
    }

    private ClassLoadingService getClassLoadingService() {
        Bundle bundle = FrameworkUtil.getBundle(ClassLoadingService.class);
        ClassLoadingService classLoadingService = AccessController.doPrivileged(() -> {
            BundleContext bCtx = bundle.getBundleContext();
            ServiceReference svcRef = bCtx.getServiceReference(ClassLoadingService.class);
            return svcRef == null ? null : (ClassLoadingService)bCtx.getService(svcRef);
        });
        if (classLoadingService == null) {
            throw new IllegalStateException("Failed to get the ClassLoadingService.");
        }
        return classLoadingService;
    }

    private String getAppName() {
        Bundle bundle = FrameworkUtil.getBundle(CDIService.class);
        CDIService cdiService = AccessController.doPrivileged(() -> {
            BundleContext bCtx = bundle.getBundleContext();
            ServiceReference svcRef = bCtx.getServiceReference(CDIService.class);
            return svcRef == null ? null : (CDIService)bCtx.getService(svcRef);
        });
        if (cdiService == null) {
            return null;
        }
        return cdiService.getCurrentApplicationContextID();
    }

    private void releaseLoader(ClassLoader tccl) {
        AccessController.doPrivileged(() -> {
            this.getClassLoadingService().destroyThreadContextClassLoader(tccl);
            return null;
        });
    }

    private AbstractBeanValidation.ClassLoaderTuple configureBvalClassloader(ClassLoader cl) {
        if (cl == null) {
            cl = AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
        }
        if (cl != null) {
            if (this.getClassLoadingService().isThreadContextClassLoader(cl)) {
                return AbstractBeanValidation.ClassLoaderTuple.of((ClassLoader)cl, (boolean)false);
            }
            if (this.getClassLoadingService().isAppClassLoader(cl)) {
                return AbstractBeanValidation.ClassLoaderTuple.of((ClassLoader)this.createTCCL(cl), (boolean)true);
            }
        }
        return AbstractBeanValidation.ClassLoaderTuple.of((ClassLoader)this.createTCCL(LibertyHibernateValidatorExtension.class.getClassLoader()), (boolean)true);
    }

    private ClassLoader createTCCL(ClassLoader parentCL) {
        return AccessController.doPrivileged(() -> this.getClassLoadingService().createThreadContextClassLoader(parentCL));
    }
}

