/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.internal;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.EJSWrapper;
import com.ibm.ejs.container.EJSWrapperBase;
import com.ibm.ejs.container.EJSWrapperCommon;
import com.ibm.ejs.container.util.ByteArray;
import com.ibm.ejs.util.Util;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.EJBReference;
import jakarta.ejb.EJBException;
import jakarta.ejb.EJBObject;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import javax.rmi.PortableRemoteObject;

public class EJBReferenceImpl
implements EJBReference {
    private static final TraceComponent tc = Tr.register(EJBReferenceImpl.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final long serialVersionUID = 0L;
    private transient EJSWrapperCommon wc;
    private transient BeanId beanId;
    private byte[] beanIdBytes;

    EJBReferenceImpl(EJSWrapperCommon wc) {
        this.wc = wc;
        this.beanId = wc.getBeanId();
    }

    private EJSWrapperCommon getEJSWrapperCommon() {
        if (this.wc == null) {
            EJSContainer container2 = EJSContainer.getDefaultContainer();
            try {
                this.beanId = BeanId.getBeanId(new ByteArray(this.beanIdBytes), container2);
                this.wc = container2.getWrapperManager().getWrapper(this.beanId);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return this.wc;
    }

    @Override
    public <T extends EJBObject> T getEJBObject(Class<T> klass) {
        Object wrapperRef;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getEJBObject : " + this + " : " + klass), (Object[])new Object[0]);
        }
        EJSWrapper wrapper = this.getEJSWrapperCommon().getRemoteWrapper();
        try {
            wrapperRef = wrapper.container.getEJBRuntime().getRemoteReference(wrapper);
        }
        catch (NoSuchObjectException e) {
            throw new IllegalStateException(e);
        }
        EJBObject ejbObject = (EJBObject)klass.cast(PortableRemoteObject.narrow((Object)wrapperRef, klass));
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getEJBObject : " + Util.identity((Object)ejbObject)));
        }
        return (T)ejbObject;
    }

    @Override
    public <T> T getBusinessObject(Class<T> klass) {
        T ejbObject;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getBusinessObject : " + this + " : " + klass), (Object[])new Object[0]);
        }
        try {
            ejbObject = klass.cast(this.getEJSWrapperCommon().getBusinessObject(klass.getName()));
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getBusinessObject : " + Util.identity(ejbObject)));
        }
        return ejbObject;
    }

    @Override
    public Object getAggregateLocalObject() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getAggregateLocalObject : " + this), (Object[])new Object[0]);
        }
        Object aggregate = this.getEJSWrapperCommon().getAggregateLocalWrapper();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getAggregateLocalObject : " + Util.identity((Object)aggregate)));
        }
        return aggregate;
    }

    @Override
    public void remove() {
        EJSWrapperCommon wc;
        EJSHome home;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("remove : " + this), (Object[])new Object[0]);
        }
        if (!(home = (EJSHome)(wc = this.getEJSWrapperCommon()).getBeanId().getHome()).isStatefulSessionHome()) {
            throw new UnsupportedOperationException();
        }
        BeanMetaData bmd = home.getBeanMetaData();
        EJSWrapperBase wrapper = bmd.ivBusinessLocalInterfaceClasses != null ? wc.getLocalBusinessWrapperBase(0) : wc.getRemoteBusinessWrapper(0);
        EJSContainer container2 = home.getContainer();
        try {
            container2.removeBean(wrapper);
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"remove");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.beanIdBytes == null) {
            this.beanIdBytes = this.beanId.getByteArrayBytes();
        }
        out.defaultWriteObject();
    }

    public String toString() {
        return super.toString() + "[" + this.beanId + "]";
    }
}

