/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.admin.internal;

import com.ibm.websphere.messaging.mbean.TopicMBean;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.admin.Controllable;
import com.ibm.ws.sib.admin.internal.JsBusImpl;
import com.ibm.ws.sib.admin.internal.JsMessagingEngineImpl;
import com.ibm.ws.sib.admin.internal.SIBMBeanResultFactory;
import com.ibm.ws.sib.admin.mxbean.MessagingSubscription;
import com.ibm.ws.sib.admin.mxbean.QueuedMessage;
import com.ibm.ws.sib.admin.mxbean.QueuedMessageDetail;
import com.ibm.ws.sib.mfp.JsJmsBytesMessage;
import com.ibm.ws.sib.mfp.JsJmsMapMessage;
import com.ibm.ws.sib.mfp.JsJmsMessage;
import com.ibm.ws.sib.mfp.JsJmsObjectMessage;
import com.ibm.ws.sib.mfp.JsJmsStreamMessage;
import com.ibm.ws.sib.mfp.JsJmsTextMessage;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageType;
import com.ibm.ws.sib.mfp.ObjectFailedToSerializeException;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPException;
import com.ibm.ws.sib.processor.exceptions.SIMPInvalidRuntimeIDException;
import com.ibm.ws.sib.processor.exceptions.SIMPRuntimeOperationFailedException;
import com.ibm.ws.sib.processor.runtime.SIMPLocalSubscriptionControllable;
import com.ibm.ws.sib.processor.runtime.SIMPLocalTopicSpaceControllable;
import com.ibm.ws.sib.processor.runtime.SIMPQueuedMessageControllable;
import com.ibm.ws.sib.processor.runtime.SIMPRemoteMessageControllable;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionNotFoundException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;

public class TopicImpl
implements TopicMBean,
Controllable {
    private static final TraceComponent tc = SibTr.register(TopicImpl.class, (String)"SIBAdmin", (String)"com.ibm.ws.sib.admin.internal.CWSIDMessages");
    private static final String CLASS_NAME = "com.ibm.ws.sib.admin.internal.TopicImpl";
    private String _name = null;
    private SIMPLocalTopicSpaceControllable _c = null;
    private JsMessagingEngineImpl _me = null;
    Properties props = new Properties();

    public Properties getProperties() {
        return (Properties)this.props.clone();
    }

    public TopicImpl(JsMessagingEngineImpl me, Controllable c) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)CLASS_NAME, (Object)new Object[]{me, c});
        }
        this._c = (SIMPLocalTopicSpaceControllable)c;
        this._name = c.getName();
        this._me = me;
        this.props.setProperty(((JsBusImpl)me.getBus()).getMBeanType(), ((JsBusImpl)me.getBus()).getName());
        this.props.setProperty(me.getMBeanType(), me.getName());
        this.props.setProperty("ID", this._c.getId());
        if (this._c.getConfigId() == null && TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)CLASS_NAME, (Object)this);
        }
    }

    public TopicImpl(JsMessagingEngineImpl me, Controllable c, String name) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)CLASS_NAME, (Object)new Object[]{me, c, name});
        }
        this._c = c == null ? (SIMPLocalTopicSpaceControllable)this : (SIMPLocalTopicSpaceControllable)c;
        this._name = name;
        this._me = me;
        Properties props = new Properties();
        props.setProperty(((JsBusImpl)me.getBus()).getMBeanType(), ((JsBusImpl)me.getBus()).getName());
        props.setProperty(me.getMBeanType(), me.getName());
        props.setProperty("UUID", this._c.getId());
        if (this._c.getConfigId() == null && TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)CLASS_NAME, (Object)this);
        }
    }

    public String getUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getUuid");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getUuid", (Object)this._c.getUuid());
        }
        return this._c.getUuid();
    }

    public String getName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getName");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getName", (Object)this._name);
        }
        return this._name;
    }

    @Override
    public String getIdentifier() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getIdentifier");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getIdentifier", (Object)this._name);
        }
        return this._name;
    }

    @Override
    public String getId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getId");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getId", (Object)this._c.getId());
        }
        return this._c.getId();
    }

    @Override
    public long getMaxQueueSize() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getHighMessageThreshold");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Long l = new Long(this._c.getDestinationHighMsgs());
            SibTr.exit((TraceComponent)tc, (String)"getHighMessageThreshold", (Object)l);
        }
        return this._c.getDestinationHighMsgs();
    }

    @Override
    public boolean isSendAllowed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isSendAllowed");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isSendAllowed");
        }
        return this._c.isSendAllowed();
    }

    @Override
    public long getDepth() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDepth");
        }
        long depth = this._c.getNumberOfQueuedMessages();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDepth", (Object)depth);
        }
        return depth;
    }

    @Override
    public MessagingSubscription[] listSubscriptions() throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSubscriptions");
        }
        ArrayList<SIMPLocalSubscriptionControllable> list = new ArrayList<SIMPLocalSubscriptionControllable>();
        Object iter = this._c.getTopicSpace().getLocalSubscriptionIterator();
        while (iter != null && iter.hasNext()) {
            SIMPLocalSubscriptionControllable o = (SIMPLocalSubscriptionControllable)iter.next();
            list.add(o);
        }
        MessagingSubscription[] retValue = new MessagingSubscription[list.size()];
        iter = list.iterator();
        int i = 0;
        while (iter.hasNext()) {
            Object o = iter.next();
            retValue[i++] = SIBMBeanResultFactory.createSIBSubscription((SIMPLocalSubscriptionControllable)o);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSubscriptions");
        }
        return retValue;
    }

    @Override
    public MessagingSubscription getSubscription(String subId) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSubscription", (Object)subId);
        }
        try {
            SIMPLocalSubscriptionControllable qpc = this._c.getTopicSpace().getLocalSubscriptionControlByID(subId);
            if (qpc != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"getSubscription", (Object)qpc);
                }
                return SIBMBeanResultFactory.createSIBSubscription(qpc);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getSubscription", null);
            }
            return null;
        }
        catch (SIMPException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getSubscription", (Object)((Object)e));
            }
            throw new Exception(e.getMessage());
        }
    }

    @Override
    public MessagingSubscription getSubscriptionByName(String subName) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSubscriptionByName", (Object)subName);
        }
        try {
            SIMPLocalSubscriptionControllable qpc = this._c.getTopicSpace().getLocalSubscriptionControlByName(subName);
            if (qpc != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"getSubscriptionByName", (Object)qpc);
                }
                return SIBMBeanResultFactory.createSIBSubscription(qpc);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getSubscriptionByName", null);
            }
            return null;
        }
        catch (SIMPException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getSubscriptionByName", (Object)((Object)e));
            }
            throw new Exception(e.getMessage());
        }
    }

    @Override
    public void deleteSubscription(String subId) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteSubscription", (Object)subId);
        }
        try {
            this._c.getTopicSpace().deleteLocalSubscriptionControlByID(subId);
        }
        catch (SIDurableSubscriptionNotFoundException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            throw new Exception(e.getMessage());
        }
        catch (SIMPInvalidRuntimeIDException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            throw new Exception(e.getMessage());
        }
        catch (SIIncorrectCallException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            throw new Exception(e.getMessage());
        }
        catch (SIResourceException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            throw new Exception(e.getMessage());
        }
        catch (SIMPControllableNotFoundException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            throw new Exception(e.getMessage());
        }
        catch (SIDestinationLockedException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            throw new Exception(e.getMessage());
        }
        catch (SIMPException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            throw new Exception(e.getMessage());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteSubscription");
        }
    }

    @Override
    public QueuedMessage[] getSubscriptionMessages(String subId) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSubscriptionMessages", (Object)subId);
        }
        QueuedMessage[] retValue = null;
        ArrayList<SIMPQueuedMessageControllable> list = new ArrayList<SIMPQueuedMessageControllable>();
        SIMPLocalSubscriptionControllable lsc = null;
        try {
            lsc = this._c.getTopicSpace().getLocalSubscriptionControlByID(subId);
        }
        catch (SIMPException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            throw new Exception(e.getMessage());
        }
        if (lsc != null) {
            Object iter = lsc.getQueuedMessageIterator();
            while (iter != null && iter.hasNext()) {
                SIMPQueuedMessageControllable o = (SIMPQueuedMessageControllable)iter.next();
                list.add(o);
            }
            ArrayList<QueuedMessage> resultList = new ArrayList<QueuedMessage>();
            iter = list.iterator();
            boolean i = false;
            while (iter.hasNext()) {
                Object o = iter.next();
                QueuedMessage qm = SIBMBeanResultFactory.createSIBQueuedMessage((SIMPQueuedMessageControllable)o);
                resultList.add(qm);
            }
            retValue = resultList.toArray(new QueuedMessage[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSubscriptionMessages", retValue);
        }
        return retValue;
    }

    @Override
    public QueuedMessage getSubscriptionMessage(String subId, String messageId) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSubscriptionMessage", (Object)(subId + " " + messageId));
        }
        SIMPLocalSubscriptionControllable lsc = null;
        SIMPQueuedMessageControllable qmc = null;
        QueuedMessage qm = null;
        try {
            lsc = this._c.getTopicSpace().getLocalSubscriptionControlByID(subId);
            if (lsc != null) {
                qmc = lsc.getQueuedMessageByID(messageId);
            }
            if (qmc != null) {
                QueuedMessage qmsg;
                qm = qmsg = SIBMBeanResultFactory.createSIBQueuedMessage(qmc);
            }
        }
        catch (SIMPControllableNotFoundException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Message no longer on subscription point", (Object)messageId);
            }
        }
        catch (SIMPException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            throw new Exception(e.getMessage());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSubscriptionMessage", qm);
        }
        return qm;
    }

    @Override
    public QueuedMessageDetail getSubscriptionMessageDetail(String subId, String messageId) throws Exception {
        return this.getSubscriptionMessageDetail(subId, messageId, null);
    }

    public QueuedMessageDetail getSubscriptionMessageDetail(String subId, String messageId, Locale locale) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSubscriptionMessageDetail", (Object)new Object[]{subId, messageId, locale});
        }
        SIMPLocalSubscriptionControllable lsc = null;
        SIMPQueuedMessageControllable qmc = null;
        QueuedMessageDetail qmd = null;
        try {
            lsc = this._c.getTopicSpace().getLocalSubscriptionControlByID(subId);
            if (lsc != null) {
                qmc = lsc.getQueuedMessageByID(messageId);
            }
            if (qmc != null) {
                QueuedMessageDetail qmsgd;
                qmd = qmsgd = SIBMBeanResultFactory.createSIBQueuedMessageDetail(qmc, locale);
            }
        }
        catch (SIMPControllableNotFoundException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Message no longer on subscription point", (Object)messageId);
            }
        }
        catch (SIMPException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getSubscriptionMessageDetail", (Object)((Object)e));
            }
            throw new Exception(e.getMessage());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSubscriptionMessageDetail", qmd);
        }
        return qmd;
    }

    @Override
    public byte[] getSubscriptionMessageData(String subId, String messageId, Integer size) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSubscriptionMessageData", (Object)(subId + " " + messageId + " " + size.toString()));
        }
        SIMPLocalSubscriptionControllable lsc = null;
        SIMPQueuedMessageControllable qmc = null;
        try {
            lsc = this._c.getTopicSpace().getLocalSubscriptionControlByID(subId);
            if (lsc != null) {
                qmc = lsc.getQueuedMessageByID(messageId);
            }
        }
        catch (SIMPControllableNotFoundException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Message no longer on subscription point", (Object)messageId);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getSubscriptionMessageData");
            }
            return null;
        }
        catch (SIMPException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            throw new Exception(e.getMessage());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSubscriptionMessageData");
        }
        return this.getMessageData(qmc, size);
    }

    @Override
    public void deleteSubscriptionMessage(String subId, String messageId, Boolean moveMessage) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteSubscriptionMessage", (Object)messageId);
        }
        boolean discard = true;
        SIMPLocalSubscriptionControllable lsc = null;
        SIMPQueuedMessageControllable qmc = null;
        if (moveMessage.booleanValue()) {
            discard = false;
        }
        try {
            lsc = this._c.getTopicSpace().getLocalSubscriptionControlByID(subId);
            if (lsc != null) {
                qmc = lsc.getQueuedMessageByID(messageId);
            }
            if (qmc != null) {
                qmc.moveMessage(discard);
            }
        }
        catch (SIMPControllableNotFoundException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Message no longer on subscription point", (Object)messageId);
            }
        }
        catch (SIMPRuntimeOperationFailedException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteSubscriptionMessage", (Object)"SIBRuntimeOperationFailedException");
            }
            throw new Exception(e.getMessage());
        }
        catch (SIMPException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteSubscriptionMessage", (Object)((Object)e));
            }
            throw new Exception(e.getMessage());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteSubscriptionMessage");
        }
    }

    private byte[] getData(byte[] in, Integer size) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getData", (Object)new Object[]{in, size});
        }
        byte[] tmp = null;
        if (in != null) {
            int len = 1024;
            if (size > 0) {
                len = size;
            }
            if (len > in.length) {
                len = in.length;
            }
            tmp = new byte[len];
            System.arraycopy(in, 0, tmp, 0, len);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getData", tmp);
        }
        return tmp;
    }

    public byte[] getMessageData(SIMPQueuedMessageControllable qmc, Integer size) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageData", (Object)size.toString());
        }
        byte[] data = null;
        if (qmc != null) {
            try {
                JsMessage jm = qmc.getJsMessage();
                data = this.getMessageData(jm, size);
            }
            catch (SIMPException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"getMessageData", (Object)((Object)e));
                }
                throw e;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessageData");
        }
        return data;
    }

    public byte[] getMessageData(SIMPRemoteMessageControllable rmc, Integer size) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageData", (Object)size.toString());
        }
        byte[] data = null;
        if (rmc != null) {
            try {
                JsMessage jm = rmc.getJsMessage();
                data = this.getMessageData(jm, size);
            }
            catch (SIMPException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"getMessageData", (Object)((Object)e));
                }
                throw e;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessageData");
        }
        return data;
    }

    private byte[] getMessageData(JsMessage jm, Integer size) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageData", (Object)new Object[]{jm, size});
        }
        byte[] data = null;
        MessageType mt = jm.getJsMessageType();
        if (mt == MessageType.JMS) {
            JsJmsMessage m = jm.makeInboundJmsMessage();
            if (m instanceof JsJmsTextMessage) {
                JsJmsTextMessage msg = (JsJmsTextMessage)m;
                String text = null;
                try {
                    text = msg.getText();
                }
                catch (UnsupportedEncodingException e) {
                    throw new Exception(e.getMessage());
                }
                if (text != null) {
                    data = this.getData(text.getBytes(), size);
                }
            } else if (m instanceof JsJmsBytesMessage) {
                JsJmsBytesMessage msg = (JsJmsBytesMessage)m;
                data = this.getData(msg.getBytes(), size);
            } else {
                if (m instanceof JsJmsObjectMessage) {
                    JsJmsObjectMessage msg = (JsJmsObjectMessage)m;
                    try {
                        data = this.getData(msg.getSerializedObject(), size);
                    }
                    catch (ObjectFailedToSerializeException ofse) {
                        data = null;
                        throw new Exception(ofse.getMessage());
                    }
                }
                if (m instanceof JsJmsMapMessage) {
                    JsJmsMapMessage msg = (JsJmsMapMessage)m;
                    try {
                        data = this.getData(msg.getUserFriendlyBytes(), size);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new Exception(e.getMessage());
                    }
                }
                if (m instanceof JsJmsStreamMessage) {
                    JsJmsStreamMessage msg = (JsJmsStreamMessage)m;
                    try {
                        data = this.getData(msg.getUserFriendlyBytes(), size);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new Exception(e.getMessage());
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessageData", data);
        }
        return data;
    }

    public String getConfigId() {
        return null;
    }

    public String getRemoteEngineUuid() {
        return null;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"com/ibm/ws/sib/admin/internal/TopicImpl.java");
        }
    }
}

