/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl.eventrecorder;

import com.ibm.ws.sib.jfapchannel.approxtime.QuickApproxTime;
import com.ibm.ws.sib.jfapchannel.impl.eventrecorder.ConnectionEventRecorder;
import com.ibm.ws.sib.jfapchannel.impl.eventrecorder.ConversationEventRecorder;
import com.ibm.ws.sib.jfapchannel.impl.eventrecorder.EventRecorderImpl;
import com.ibm.ws.sib.jfapchannel.impl.eventrecorder.SequenceNumberGenerator;
import java.util.Calendar;

public class ConversationEventRecorderImpl
extends EventRecorderImpl
implements ConversationEventRecorder {
    private final byte[] eventTypeArray;
    private final long[] eventTimestampArray;
    private final int[] eventSequenceArray;
    private final int[] eventThreadHashcode;
    private final String[] eventDescriptionArray;
    private int totalEvents;
    private int currentEvent;
    private final int maxEvents;
    private final ConnectionEventRecorder connectionEventRecorder;
    private final SequenceNumberGenerator sequenceNumberGenerator;
    private final QuickApproxTime approxTime;

    protected ConversationEventRecorderImpl(ConnectionEventRecorder connectionEventRecorder, SequenceNumberGenerator sequenceNumberGenerator, QuickApproxTime approxTime, int maxEvents) {
        this.connectionEventRecorder = connectionEventRecorder;
        this.sequenceNumberGenerator = sequenceNumberGenerator;
        this.maxEvents = maxEvents;
        this.approxTime = approxTime;
        this.eventTypeArray = new byte[maxEvents];
        this.eventTimestampArray = new long[maxEvents];
        this.eventSequenceArray = new int[maxEvents];
        this.eventThreadHashcode = new int[maxEvents];
        this.eventDescriptionArray = new String[maxEvents];
    }

    @Override
    protected synchronized void fillInNextEvent(byte type, String description) {
        this.eventTypeArray[this.currentEvent] = type;
        this.eventTimestampArray[this.currentEvent] = this.approxTime.getApproxTime();
        this.eventSequenceArray[this.currentEvent] = this.sequenceNumberGenerator.getNextSequenceNumber();
        this.eventDescriptionArray[this.currentEvent] = description;
        this.eventThreadHashcode[this.currentEvent] = Thread.currentThread().hashCode();
        this.currentEvent = (this.currentEvent + 1) % this.maxEvents;
        ++this.totalEvents;
    }

    @Override
    public ConnectionEventRecorder getConnectionEventRecorder() {
        return this.connectionEventRecorder;
    }

    public synchronized String toString() {
        StringBuffer sb = new StringBuffer("" + this.totalEvents);
        sb.append(" conversation events recorded in total\n");
        sb.append("timestamp/sequence/thread/type/description\n");
        int eventIndex = this.totalEvents >= this.maxEvents ? this.currentEvent : 0;
        for (int eventCount = 0; this.eventTypeArray[eventIndex] != 0 && eventCount < this.maxEvents; ++eventCount) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(this.eventTimestampArray[eventIndex]);
            sb.append(calendar.get(11));
            sb.append(":");
            sb.append(calendar.get(12));
            sb.append(":");
            sb.append(calendar.get(13));
            sb.append(":");
            sb.append(calendar.get(14));
            sb.append(" ");
            sb.append(this.eventSequenceArray[eventIndex]);
            sb.append(" ");
            sb.append(Integer.toHexString(this.eventThreadHashcode[eventIndex]));
            sb.append("\t");
            sb.append((char)this.eventTypeArray[eventIndex]);
            sb.append("\t");
            sb.append(this.eventDescriptionArray[eventIndex]);
            sb.append("\n");
            eventIndex = (eventIndex + 1) % this.maxEvents;
        }
        return sb.toString();
    }
}

