/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import com.ibm.asyncutil.iteration.AsyncTrampoline;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jboss.resteasy.plugins.providers.FileRange;
import org.jboss.resteasy.plugins.providers.ProviderHelper;
import org.jboss.resteasy.spi.AsyncMessageBodyWriter;
import org.jboss.resteasy.spi.AsyncOutputStream;
import org.jboss.resteasy.util.MediaTypeHelper;

@Provider
public class FileRangeWriter
implements AsyncMessageBodyWriter<FileRange> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.equals(FileRange.class) && !MediaTypeHelper.isBlacklisted(mediaType);
    }

    public long getSize(FileRange fileRange, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(FileRange fileRange, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        long fileSize = fileRange.getFile().length();
        String contentRange = "bytes " + fileRange.getBegin() + "-" + fileRange.getEnd() + "/" + fileSize;
        long length = fileRange.getEnd() - fileRange.getBegin() + 1L;
        httpHeaders.putSingle((Object)"Content-Range", (Object)contentRange);
        httpHeaders.putSingle((Object)"Content-Length", (Object)length);
        try (FileInputStream fis = new FileInputStream(fileRange.getFile());){
            if (fileRange.getBegin() > 0L) {
                fis.getChannel().position(fileRange.getBegin());
            }
            byte[] buf = new byte[2048];
            while (length > 0L) {
                int len = 2048L > length ? (int)length : 2048;
                int read = fis.read(buf, 0, len);
                if (read == -1) {
                    break;
                }
                entityStream.write(buf, 0, read);
                length -= (long)len;
            }
        }
    }

    @Override
    public CompletionStage<Void> asyncWriteTo(FileRange fileRange, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, AsyncOutputStream entityStream) {
        long fileSize = fileRange.getFile().length();
        String contentRange = "bytes " + fileRange.getBegin() + "-" + fileRange.getEnd() + "/" + fileSize;
        long length = fileRange.getEnd() - fileRange.getBegin() + 1L;
        httpHeaders.putSingle((Object)"Content-Range", (Object)contentRange);
        httpHeaders.putSingle((Object)"Content-Length", (Object)length);
        try {
            FileInputStream fis = new FileInputStream(fileRange.getFile());
            if (fileRange.getBegin() > 0L) {
                fis.getChannel().position(fileRange.getBegin());
            }
            byte[] buf = new byte[2048];
            return this.writeTo(fis, length, entityStream, buf).whenComplete((v, t) -> {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (IOException e) {
            return ProviderHelper.completedException(e);
        }
    }

    private CompletionStage<Void> writeTo(FileInputStream fis, long length, AsyncOutputStream entityStream, byte[] buf) {
        if (length > 0L) {
            long[] mutableLength = new long[]{length};
            return AsyncTrampoline.asyncWhile(read -> read != -1, read -> entityStream.asyncWrite(buf, 0, (int)read).thenApply(v -> {
                mutableLength[0] = mutableLength[0] - (long)read.intValue();
                if (mutableLength[0] > 0L) {
                    return ProviderHelper.asyncRead(fis, buf, 0, (int)Math.min((long)buf.length, mutableLength[0]));
                }
                return -1;
            }), ProviderHelper.asyncRead(fis, buf, 0, (int)Math.min((long)buf.length, mutableLength[0]))).thenApply(v -> null);
        }
        return CompletableFuture.completedFuture(null);
    }
}

