/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal;

import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.i18n.Messages;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.client.jaxrs.internal.ClientWebTarget;
import org.jboss.resteasy.concurrent.ContextualExecutors;
import org.jboss.resteasy.concurrent.ContextualScheduledExecutorService;

public class ResteasyClientImpl
implements ResteasyClient {
    protected final ClientHttpEngine httpEngine;
    private final ExecutorService asyncInvocationExecutor;
    private final ContextualScheduledExecutorService scheduledExecutorService;
    protected ClientConfiguration configuration;
    protected boolean closed;
    protected boolean cleanupExecutor;

    protected ResteasyClientImpl(ClientHttpEngine httpEngine, ExecutorService asyncInvocationExecutor, boolean cleanupExecutor, ScheduledExecutorService scheduledExecutorService, ClientConfiguration configuration) {
        this(httpEngine, asyncInvocationExecutor, cleanupExecutor, ContextualExecutors.wrap(scheduledExecutorService), configuration);
    }

    protected ResteasyClientImpl(ClientHttpEngine httpEngine, ExecutorService asyncInvocationExecutor, boolean cleanupExecutor, ContextualScheduledExecutorService scheduledExecutorService, ClientConfiguration configuration) {
        this.cleanupExecutor = cleanupExecutor;
        this.httpEngine = httpEngine;
        this.asyncInvocationExecutor = asyncInvocationExecutor;
        this.configuration = configuration;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    protected ResteasyClientImpl(ClientHttpEngine httpEngine, ExecutorService asyncInvocationExecutor, boolean cleanupExecutor, ClientConfiguration configuration) {
        this(httpEngine, asyncInvocationExecutor, cleanupExecutor, ContextualExecutors.scheduledThreadPool(), configuration);
    }

    @Override
    public ClientHttpEngine httpEngine() {
        this.abortIfClosed();
        return this.httpEngine;
    }

    @Override
    public ExecutorService asyncInvocationExecutor() {
        return this.asyncInvocationExecutor;
    }

    @Override
    public ScheduledExecutorService getScheduledExecutor() {
        return this.scheduledExecutorService;
    }

    @Override
    public void abortIfClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException(Messages.MESSAGES.clientIsClosed());
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        this.closed = true;
        try {
            this.httpEngine.close();
            if (this.cleanupExecutor) {
                this.asyncInvocationExecutor.shutdown();
            }
            if (this.scheduledExecutorService != null && !this.scheduledExecutorService.isManaged()) {
                this.scheduledExecutorService.shutdown();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Configuration getConfiguration() {
        this.abortIfClosed();
        return this.configuration;
    }

    public SSLContext getSslContext() {
        this.abortIfClosed();
        return this.httpEngine().getSslContext();
    }

    public HostnameVerifier getHostnameVerifier() {
        this.abortIfClosed();
        return this.httpEngine().getHostnameVerifier();
    }

    public ResteasyClientImpl property(String name, Object value) {
        this.abortIfClosed();
        this.configuration.property(name, value);
        return this;
    }

    public ResteasyClientImpl register(Class<?> componentClass) {
        this.abortIfClosed();
        this.configuration.register((Class)componentClass);
        return this;
    }

    public ResteasyClientImpl register(Class<?> componentClass, int priority) {
        this.abortIfClosed();
        this.configuration.register((Class)componentClass, priority);
        return this;
    }

    public ResteasyClientImpl register(Class<?> componentClass, Class<?> ... contracts) {
        this.abortIfClosed();
        this.configuration.register((Class)componentClass, (Class[])contracts);
        return this;
    }

    public ResteasyClientImpl register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        this.abortIfClosed();
        this.configuration.register((Class)componentClass, (Map)contracts);
        return this;
    }

    public ResteasyClientImpl register(Object component) {
        this.abortIfClosed();
        this.configuration.register(component);
        return this;
    }

    public ResteasyClientImpl register(Object component, int priority) {
        this.abortIfClosed();
        this.configuration.register(component, priority);
        return this;
    }

    public ResteasyClientImpl register(Object component, Class<?> ... contracts) {
        this.abortIfClosed();
        this.configuration.register(component, (Class[])contracts);
        return this;
    }

    public ResteasyClientImpl register(Object component, Map<Class<?>, Integer> contracts) {
        this.abortIfClosed();
        this.configuration.register(component, (Map)contracts);
        return this;
    }

    @Override
    public ResteasyWebTarget target(String uri) throws IllegalArgumentException, NullPointerException {
        this.abortIfClosed();
        if (uri == null) {
            throw new NullPointerException(Messages.MESSAGES.uriWasNull());
        }
        return this.createClientWebTarget(this, uri, this.configuration);
    }

    @Override
    public ResteasyWebTarget target(URI uri) throws NullPointerException {
        this.abortIfClosed();
        if (uri == null) {
            throw new NullPointerException(Messages.MESSAGES.uriWasNull());
        }
        return this.createClientWebTarget(this, uri, this.configuration);
    }

    @Override
    public ResteasyWebTarget target(UriBuilder uriBuilder) throws NullPointerException {
        this.abortIfClosed();
        if (uriBuilder == null) {
            throw new NullPointerException(Messages.MESSAGES.uriBuilderWasNull());
        }
        return this.createClientWebTarget(this, uriBuilder, this.configuration);
    }

    @Override
    public ResteasyWebTarget target(Link link) throws NullPointerException {
        this.abortIfClosed();
        if (link == null) {
            throw new NullPointerException(Messages.MESSAGES.linkWasNull());
        }
        URI uri = link.getUri();
        return this.createClientWebTarget(this, uri, this.configuration);
    }

    public Invocation.Builder invocation(Link link) throws NullPointerException, IllegalArgumentException {
        this.abortIfClosed();
        if (link == null) {
            throw new NullPointerException(Messages.MESSAGES.linkWasNull());
        }
        ResteasyWebTarget target = this.target(link);
        if (link.getType() != null) {
            return target.request(new String[]{link.getType()});
        }
        return target.request();
    }

    protected ResteasyWebTarget createClientWebTarget(ResteasyClientImpl client, String uri, ClientConfiguration configuration) {
        return new ClientWebTarget((ResteasyClient)client, uri, configuration);
    }

    protected ResteasyWebTarget createClientWebTarget(ResteasyClientImpl client, URI uri, ClientConfiguration configuration) {
        return new ClientWebTarget((ResteasyClient)client, uri, configuration);
    }

    protected ResteasyWebTarget createClientWebTarget(ResteasyClientImpl client, UriBuilder uriBuilder, ClientConfiguration configuration) {
        return new ClientWebTarget((ResteasyClient)client, uriBuilder, configuration);
    }
}

