/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal;

import jakarta.json.bind.JsonbException;
import jakarta.json.bind.config.PropertyVisibilityStrategy;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.yasson.internal.ClassMultiReleaseExtension;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.model.ClassModel;
import org.eclipse.yasson.internal.model.CreatorModel;
import org.eclipse.yasson.internal.model.JsonbAnnotatedElement;
import org.eclipse.yasson.internal.model.JsonbCreator;
import org.eclipse.yasson.internal.model.Property;
import org.eclipse.yasson.internal.model.PropertyModel;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;

class ClassParser {
    private static final String IS_PREFIX = "is";
    private static final String GET_PREFIX = "get";
    private static final String SET_PREFIX = "set";
    private final JsonbContext jsonbContext;

    ClassParser(JsonbContext jsonbContext) {
        this.jsonbContext = jsonbContext;
    }

    void parseProperties(ClassModel classModel, JsonbAnnotatedElement<Class<?>> classElement) {
        HashMap<String, Property> classProperties = new HashMap<String, Property>();
        ClassParser.parseFields(classElement, classProperties);
        this.parseClassAndInterfaceMethods(classElement, classProperties);
        List<PropertyModel> sortedParentProperties = this.getSortedParentProperties(classModel, classElement, classProperties);
        List<PropertyModel> classPropertyModels = classProperties.values().stream().map(property -> new PropertyModel(classModel, (Property)property, this.jsonbContext)).collect(Collectors.toList());
        ArrayList<PropertyModel> unsortedMerged = new ArrayList<PropertyModel>(sortedParentProperties.size() + classPropertyModels.size());
        unsortedMerged.addAll(sortedParentProperties);
        unsortedMerged.addAll(classPropertyModels);
        ClassParser.checkPropertyNameClash(unsortedMerged, classModel.getType());
        ClassParser.mergePropertyModels(classPropertyModels);
        ArrayList<PropertyModel> sortedPropertyModels = new ArrayList<PropertyModel>(sortedParentProperties.size() + classPropertyModels.size());
        sortedPropertyModels.addAll(sortedParentProperties);
        sortedPropertyModels.addAll(this.jsonbContext.getConfigProperties().getPropertyOrdering().orderProperties(classPropertyModels, classModel));
        JsonbCreator creator = classModel.getClassCustomization().getCreator();
        if (creator != null) {
            sortedPropertyModels.forEach(propertyModel -> {
                for (CreatorModel creatorModel : creator.getParams()) {
                    if (!creatorModel.getName().equals(propertyModel.getPropertyName())) continue;
                    creatorModel.getCustomization().setPropertyModel((PropertyModel)propertyModel);
                }
            });
        }
        classModel.setProperties(sortedPropertyModels);
    }

    private static void mergePropertyModels(List<PropertyModel> unsortedMerged) {
        PropertyModel[] clone = unsortedMerged.toArray(new PropertyModel[0]);
        for (int i = 0; i < clone.length; ++i) {
            for (int j = i + 1; j < clone.length; ++j) {
                PropertyModel firstPropertyModel = clone[i];
                PropertyModel secondPropertyModel = clone[j];
                if (!firstPropertyModel.equals(secondPropertyModel)) continue;
                unsortedMerged.remove(firstPropertyModel);
                unsortedMerged.remove(secondPropertyModel);
                if (!firstPropertyModel.isReadable() && !firstPropertyModel.isWritable()) {
                    unsortedMerged.add(secondPropertyModel);
                    continue;
                }
                if (!secondPropertyModel.isReadable() && !secondPropertyModel.isWritable()) {
                    unsortedMerged.add(firstPropertyModel);
                    continue;
                }
                unsortedMerged.add(new PropertyModel(firstPropertyModel, secondPropertyModel));
            }
        }
    }

    private void parseClassAndInterfaceMethods(JsonbAnnotatedElement<Class<?>> classElement, Map<String, Property> classProperties) {
        Class<?> concreteClass = classElement.getElement();
        this.parseMethods(concreteClass, classElement, classProperties);
        for (Class<?> ifc : this.jsonbContext.getAnnotationIntrospector().collectInterfaces(concreteClass)) {
            this.parseIfaceMethodAnnotations(ifc, classElement, classProperties);
        }
    }

    private void parseIfaceMethodAnnotations(Class<?> ifc, JsonbAnnotatedElement<Class<?>> classElement, Map<String, Property> classProperties) {
        Method[] declaredMethods;
        for (Method method : declaredMethods = AccessController.doPrivileged(ifc::getDeclaredMethods)) {
            String methodName = method.getName();
            if (!ClassParser.isPropertyMethod(method)) continue;
            String propertyName = ClassParser.toPropertyMethod(methodName);
            Property property = classProperties.get(propertyName);
            if (method.isDefault()) {
                if (property == null) {
                    property = this.registerMethod(propertyName, method, classElement, classProperties);
                } else if (ClassParser.isSetter(method)) {
                    if (property.getSetter() == null) {
                        property.setSetter(method);
                    }
                } else if (property.getGetter() == null) {
                    property.setGetter(method);
                }
            }
            if (property == null) continue;
            JsonbAnnotatedElement<Method> methodElement = ClassParser.isGetter(method) ? property.getGetterElement() : property.getSetterElement();
            for (Annotation ann : method.getDeclaredAnnotations()) {
                if (!methodElement.getAnnotation(ann.annotationType()).isEmpty()) continue;
                methodElement.putAnnotation(ann, true, null);
            }
        }
    }

    private Property registerMethod(String propertyName, Method method, JsonbAnnotatedElement<Class<?>> classElement, Map<String, Property> classProperties) {
        Property property = classProperties.computeIfAbsent(propertyName, n -> new Property((String)n, classElement));
        if (ClassParser.isSetter(method)) {
            property.setSetter(method);
        } else {
            property.setGetter(method);
        }
        return property;
    }

    private void parseMethods(Class<?> clazz, JsonbAnnotatedElement<Class<?>> classElement, Map<String, Property> classProperties) {
        Method[] declaredMethods;
        for (Method method : declaredMethods = AccessController.doPrivileged(clazz::getDeclaredMethods)) {
            boolean isAccessorMethod;
            String name = method.getName();
            boolean bl = isAccessorMethod = ClassMultiReleaseExtension.isSpecialAccessorMethod(method, classProperties) || ClassParser.isPropertyMethod(method);
            if (!isAccessorMethod || method.isBridge() || ClassParser.isSpecialCaseMethod(clazz, method)) continue;
            String propertyName = ClassMultiReleaseExtension.shouldTransformToPropertyName(method) ? ClassParser.toPropertyMethod(name) : name;
            this.registerMethod(propertyName, method, classElement, classProperties);
        }
    }

    private static boolean isSpecialCaseMethod(Class<?> clazz, Method m) {
        if (!Modifier.isPublic(m.getModifiers()) || Modifier.isStatic(m.getModifiers()) || m.isSynthetic()) {
            return false;
        }
        if (m.getName().equals("getMetaClass") && m.getReturnType().getCanonicalName().equals("groovy.lang.MetaClass")) {
            return true;
        }
        return m.getName().equals("getMetadata") && m.getReturnType().getCanonicalName().equals("org.jboss.weld.proxy.WeldClientProxy$Metadata");
    }

    private static boolean isGetter(Method m) {
        return (m.getName().startsWith(GET_PREFIX) || m.getName().startsWith(IS_PREFIX)) && m.getParameterCount() == 0;
    }

    private static boolean isSetter(Method m) {
        return m.getName().startsWith(SET_PREFIX) && m.getParameterCount() == 1;
    }

    private static String toPropertyMethod(String name) {
        return ClassParser.lowerFirstLetter(name.substring(name.startsWith(IS_PREFIX) ? 2 : 3));
    }

    private static String lowerFirstLetter(String name) {
        Objects.requireNonNull(name);
        if (name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private static boolean isPropertyMethod(Method m) {
        return ClassParser.isGetter(m) || ClassParser.isSetter(m);
    }

    private static void parseFields(JsonbAnnotatedElement<Class<?>> classElement, Map<String, Property> classProperties) {
        Field[] declaredFields;
        for (Field field : declaredFields = AccessController.doPrivileged(() -> ((Class)classElement.getElement()).getDeclaredFields())) {
            String name = field.getName();
            if (field.isSynthetic()) continue;
            Property property = new Property(name, classElement);
            property.setField(field);
            classProperties.put(name, property);
        }
    }

    private static void checkPropertyNameClash(List<PropertyModel> collectedProperties, Class<?> cls) {
        ArrayList<PropertyModel> checkedProperties = new ArrayList<PropertyModel>();
        for (PropertyModel collectedPropertyModel : collectedProperties) {
            for (PropertyModel checkedPropertyModel : checkedProperties) {
                if ((!checkedPropertyModel.getReadName().equals(collectedPropertyModel.getReadName()) || !checkedPropertyModel.isReadable() || !collectedPropertyModel.isReadable()) && (!checkedPropertyModel.getWriteName().equals(collectedPropertyModel.getWriteName()) || !checkedPropertyModel.isWritable() || !collectedPropertyModel.isWritable())) continue;
                throw new JsonbException(Messages.getMessage(MessageKeys.PROPERTY_NAME_CLASH, checkedPropertyModel.getPropertyName(), collectedPropertyModel.getPropertyName(), cls.getName()));
            }
            checkedProperties.add(collectedPropertyModel);
        }
    }

    private List<PropertyModel> getSortedParentProperties(ClassModel classModel, JsonbAnnotatedElement<Class<?>> classElement, Map<String, Property> classProperties) {
        ArrayList<PropertyModel> sortedProperties = new ArrayList<PropertyModel>();
        if (classModel.getParentClassModel() != null) {
            for (PropertyModel parentProp : classModel.getParentClassModel().getSortedProperties()) {
                Property current = classProperties.get(parentProp.getPropertyName());
                if (current == null) {
                    sortedProperties.add(parentProp);
                    continue;
                }
                Property merged = ClassParser.mergeProperty(current, parentProp, classElement);
                PropertyVisibilityStrategy propertyVisibilityStrategy = classModel.getClassCustomization().getPropertyVisibilityStrategy();
                if (PropertyModel.isPropertyReadable(current.getField(), current.getGetter(), propertyVisibilityStrategy)) {
                    classProperties.replace(current.getName(), merged);
                    continue;
                }
                sortedProperties.add(new PropertyModel(classModel, merged, this.jsonbContext));
                classProperties.remove(current.getName());
            }
        }
        return sortedProperties;
    }

    private static Method selectMostSpecificNonDefaultMethod(Method current, Method parent) {
        return current != null ? (parent != null && current.isDefault() && !parent.isDefault() ? parent : current) : parent;
    }

    private static Property mergeProperty(Property current, PropertyModel parentProp, JsonbAnnotatedElement<Class<?>> classElement) {
        Field field = current.getField() != null ? current.getField() : parentProp.getField();
        Method getter = ClassParser.selectMostSpecificNonDefaultMethod(current.getGetter(), parentProp.getGetter());
        Method setter = ClassParser.selectMostSpecificNonDefaultMethod(current.getSetter(), parentProp.getSetter());
        Property merged = new Property(parentProp.getPropertyName(), classElement);
        if (field != null) {
            merged.setField(field);
        }
        if (getter != null) {
            merged.setGetter(getter);
        }
        if (setter != null) {
            merged.setSetter(setter);
        }
        return merged;
    }
}

