/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.config;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.microprofile.config.ConfigValue;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface Config {
    public static final String PROFILE = "mp.config.profile";
    public static final String PROPERTY_EXPRESSIONS_ENABLED = "mp.config.property.expressions.enabled";

    public <T> T getValue(String var1, Class<T> var2);

    public ConfigValue getConfigValue(String var1);

    default public <T> List<T> getValues(String propertyName, Class<T> propertyType) {
        Class<?> arrayType = Array.newInstance(propertyType, 0).getClass();
        return Arrays.asList((Object[])this.getValue(propertyName, arrayType));
    }

    public <T> Optional<T> getOptionalValue(String var1, Class<T> var2);

    default public <T> Optional<List<T>> getOptionalValues(String propertyName, Class<T> propertyType) {
        Class<?> arrayType = Array.newInstance(propertyType, 0).getClass();
        return this.getOptionalValue(propertyName, arrayType).map(Arrays::asList);
    }

    public Iterable<String> getPropertyNames();

    public Iterable<ConfigSource> getConfigSources();

    public <T> Optional<Converter<T>> getConverter(Class<T> var1);

    public <T> T unwrap(Class<T> var1);
}

