/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.health40.services.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.cdi.CDIService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.health.services.HealthCheckBeanCallException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.health40.services.HealthCheck40CDIBeanInvoker;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.util.AnnotationLiteral;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.Liveness;
import org.eclipse.microprofile.health.Readiness;
import org.eclipse.microprofile.health.Startup;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/ejs/ras/TraceComponent;")
@InjectedFFDC
@Component(service={HealthCheck40CDIBeanInvoker.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class HealthCheck40CDIBeanInvokerImpl
implements HealthCheck40CDIBeanInvoker {
    private static final com.ibm.ejs.ras.TraceComponent tc = Tr.register(HealthCheck40CDIBeanInvokerImpl.class);
    private final Map<String, BeanManager> beanManagers;
    private CDIService cdiService;
    static final long serialVersionUID = 1161563389923931126L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public HealthCheck40CDIBeanInvokerImpl() {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"<init>", (Object)new Object[0]);
        }
        this.beanManagers = new HashMap<String, BeanManager>();
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    @Reference(service=CDIService.class)
    protected void setCdiService(CDIService cdiService) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"setCdiService", (Object)new Object[]{cdiService});
        }
        this.cdiService = cdiService;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"setCdiService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    protected void unsetCdiService(CDIService cdiService) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"unsetCdiService", (Object)new Object[]{cdiService});
        }
        if (this.cdiService == cdiService) {
            this.cdiService = null;
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"unsetCdiService");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public Set<HealthCheckResponse> checkAllBeans(String appName, String moduleName, String healthCheckProcedure) throws HealthCheckBeanCallException {
        void var8_12;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"checkAllBeans", (Object)new Object[]{appName, moduleName, healthCheckProcedure});
        }
        BeanManager beanManager = this.getBeanManager(appName, moduleName);
        HashSet<HealthCheckResponse> retVal = new HashSet<HealthCheckResponse>();
        Set<Object> healthCheckBeans = new HashSet();
        String string = healthCheckProcedure;
        int n = -1;
        switch (string.hashCode()) {
            case 79219778: {
                if (!string.equals("START")) break;
                boolean bl = false;
                break;
            }
            case 2337004: {
                if (!string.equals("LIVE")) break;
                boolean bl = true;
                break;
            }
            case 77848963: {
                if (!string.equals("READY")) break;
                int n2 = 2;
            }
        }
        switch (var8_12) {
            case 0: {
                healthCheckBeans = this.getHealthCheckStartupBeans(beanManager);
                break;
            }
            case 1: {
                healthCheckBeans = this.getHealthCheckLivenessBeans(beanManager);
                break;
            }
            case 2: {
                healthCheckBeans = this.getHealthCheckReadinessBeans(beanManager);
                break;
            }
            default: {
                healthCheckBeans = this.getAllHealthCheckBeans(beanManager);
            }
        }
        for (Object e : healthCheckBeans) {
            HealthCheck tempHCBean = (HealthCheck)e;
            try {
                retVal.add(tempHCBean.call());
            }
            catch (Throwable throwable) {
                void e2;
                FFDCFilter.processException((Throwable)throwable, (String)"io.openliberty.microprofile.health40.services.impl.HealthCheck40CDIBeanInvokerImpl", (String)"87", (Object)this, (Object[])new Object[]{appName, moduleName, healthCheckProcedure});
                HealthCheckBeanCallException hcbce = new HealthCheckBeanCallException((Throwable)e2);
                hcbce.setBeanName(e.getClass().toString());
                throw hcbce;
            }
            Tr.event((com.ibm.ejs.ras.TraceComponent)tc, (String)("HealthCheck beanClass: " + e.getClass() + " called"));
        }
        HashSet<HealthCheckResponse> hashSet = retVal;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            hashSet = hashSet;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"checkAllBeans", hashSet);
        }
        return hashSet;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private Set<Object> getHealthCheckStartupBeans(BeanManager beanManager) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"getHealthCheckStartupBeans", (Object)new Object[]{beanManager});
        }
        HashSet<Object> hcReadinessBeans = new HashSet();
        HashSet<Object> hashSet = hcReadinessBeans = this.getHealthCheckBeans(beanManager, (Annotation)new AnnotationLiteral<Startup>(){
            static final long serialVersionUID = -8284452265680409569L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = com.ibm.websphere.ras.Tr.register((String)"io.openliberty.microprofile.health40.services.impl.HealthCheck40CDIBeanInvokerImpl$1", 1.class, (String)"HEALTH", (String)"io.openliberty.microprofile.health.resources.Health");
            }
        });
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            hashSet = hashSet;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"getHealthCheckStartupBeans", hashSet);
        }
        return hashSet;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private Set<Object> getHealthCheckLivenessBeans(BeanManager beanManager) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"getHealthCheckLivenessBeans", (Object)new Object[]{beanManager});
        }
        HashSet<Object> hcLivenessBeans = new HashSet();
        HashSet<Object> hashSet = hcLivenessBeans = this.getHealthCheckBeans(beanManager, (Annotation)new AnnotationLiteral<Liveness>(){
            static final long serialVersionUID = -4359239304935187087L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = com.ibm.websphere.ras.Tr.register((String)"io.openliberty.microprofile.health40.services.impl.HealthCheck40CDIBeanInvokerImpl$2", 2.class, (String)"HEALTH", (String)"io.openliberty.microprofile.health.resources.Health");
            }
        });
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            hashSet = hashSet;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"getHealthCheckLivenessBeans", hashSet);
        }
        return hashSet;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private Set<Object> getHealthCheckReadinessBeans(BeanManager beanManager) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"getHealthCheckReadinessBeans", (Object)new Object[]{beanManager});
        }
        HashSet<Object> hcReadinessBeans = new HashSet();
        HashSet<Object> hashSet = hcReadinessBeans = this.getHealthCheckBeans(beanManager, (Annotation)new AnnotationLiteral<Readiness>(){
            static final long serialVersionUID = -8056999369493923435L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = com.ibm.websphere.ras.Tr.register((String)"io.openliberty.microprofile.health40.services.impl.HealthCheck40CDIBeanInvokerImpl$3", 3.class, (String)"HEALTH", (String)"io.openliberty.microprofile.health.resources.Health");
            }
        });
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            hashSet = hashSet;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"getHealthCheckReadinessBeans", hashSet);
        }
        return hashSet;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private Set<Object> getAllHealthCheckBeans(BeanManager beanManager) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"getAllHealthCheckBeans", (Object)new Object[]{beanManager});
        }
        HashSet<Object> hcAllBeans = new HashSet<Object>();
        hcAllBeans.addAll(this.getHealthCheckLivenessBeans(beanManager));
        hcAllBeans.addAll(this.getHealthCheckReadinessBeans(beanManager));
        hcAllBeans.addAll(this.getHealthCheckStartupBeans(beanManager));
        HashSet<Object> hashSet = hcAllBeans;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            hashSet = hashSet;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"getAllHealthCheckBeans", hashSet);
        }
        return hashSet;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private Set<Object> getHealthCheckBeans(BeanManager beanManager, Annotation hcQualifier) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"getHealthCheckBeans", (Object)new Object[]{beanManager, hcQualifier});
        }
        HashSet<Object> healthCheckBeans = new HashSet<Object>();
        if (beanManager != null) {
            Set beans = beanManager.getBeans(HealthCheck.class, new Annotation[]{hcQualifier});
            Tr.event((com.ibm.ejs.ras.TraceComponent)tc, (String)("Beans size : " + beans.size()));
            for (Bean bean : beans) {
                Set beanQualifiers = bean.getQualifiers();
                Tr.event((com.ibm.ejs.ras.TraceComponent)tc, (String)("Bean Found: HealthCheck beanClass = " + bean.getBeanClass() + ", class = " + bean.getClass() + ", name = " + bean.getName() + ", qualifers = " + beanQualifiers));
                if (!beanQualifiers.contains(hcQualifier)) continue;
                Tr.event((com.ibm.ejs.ras.TraceComponent)tc, (String)("Adding Bean : beanClass = " + bean.getBeanClass() + ", class = " + bean.getClass() + ", qualifers = " + beanQualifiers));
                healthCheckBeans.add(beanManager.getReference(bean, HealthCheck.class, beanManager.createCreationalContext((Contextual)bean)));
            }
        }
        HashSet<Object> hashSet = healthCheckBeans;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            hashSet = hashSet;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"getHealthCheckBeans", hashSet);
        }
        return hashSet;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private synchronized BeanManager getBeanManager(String appName, String moduleName) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"getBeanManager", (Object)new Object[]{appName, moduleName});
        }
        String key = appName + "#" + moduleName;
        this.beanManagers.entrySet().forEach(bm -> Tr.event((com.ibm.ejs.ras.TraceComponent)tc, (String)("BeanManager  : " + (String)bm.getKey() + " " + bm.getValue())));
        BeanManager manager = this.beanManagers.get(key);
        if (manager == null) {
            if (this.beanManagers.containsKey(key) || this.cdiService == null) {
                BeanManager beanManager = null;
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                    beanManager = beanManager;
                    Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"getBeanManager", beanManager);
                }
                return beanManager;
            }
            manager = this.cdiService.getCurrentModuleBeanManager();
            this.beanManagers.put(key, manager);
        }
        BeanManager beanManager = manager;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            beanManager = beanManager;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"getBeanManager", (Object)beanManager);
        }
        return beanManager;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public void removeModuleReferences(String appName, String moduleName) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"removeModuleReferences", (Object)new Object[]{appName, moduleName});
        }
        String key = appName + "#" + moduleName;
        this.beanManagers.remove(key);
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"removeModuleReferences");
        }
    }
}

