/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.selector.impl;

import com.ibm.ws.sib.matchspace.BadMessageFormatMatchingException;
import com.ibm.ws.sib.matchspace.Identifier;
import com.ibm.ws.sib.matchspace.MatchSpaceKey;
import com.ibm.ws.sib.matchspace.Operator;
import com.ibm.ws.sib.matchspace.Selector;
import com.ibm.ws.sib.matchspace.SimpleTest;
import com.ibm.ws.sib.matchspace.impl.EvalCacheImpl;
import com.ibm.ws.sib.matchspace.impl.Matching;
import com.ibm.ws.sib.matchspace.selector.impl.EvaluatorImpl;
import com.ibm.ws.sib.matchspace.selector.impl.LikeOperatorImpl;
import com.ibm.ws.sib.matchspace.selector.impl.LiteralImpl;
import com.ibm.ws.sib.matchspace.selector.impl.OperatorImpl;
import com.ibm.ws.sib.matchspace.utils.FFDC;
import java.util.List;

public class SimpleTestImpl
implements SimpleTest {
    private static final Class cclass = SimpleTestImpl.class;
    public Identifier identifier;
    public int kind;
    public Object value;
    public Number lower;
    public boolean lowIncl;
    public Number upper;
    public boolean upIncl;
    public Selector[] tests;

    public SimpleTestImpl() {
    }

    public SimpleTestImpl(Selector sel) {
        if (sel instanceof Identifier) {
            this.identifier = (Identifier)sel;
            this.kind = 0;
            return;
        }
        if (!(sel instanceof Operator)) {
            throw new IllegalArgumentException();
        }
        Operator oper = (Operator)sel;
        switch (oper.getOp()) {
            case 4: 
            case 5: {
                this.identifier = (Identifier)oper.getOperands()[0];
                this.kind = 3;
                this.tests = new Selector[]{sel};
                return;
            }
            case 1: {
                if (oper.getOperands()[0] instanceof Identifier) {
                    this.identifier = (Identifier)oper.getOperands()[0];
                    this.kind = 1;
                    return;
                }
                Operator subOp = (Operator)oper.getOperands()[0];
                this.identifier = (Identifier)subOp.getOperands()[0];
                if (subOp.getOp() == 4 || subOp.getOp() == 5) {
                    this.kind = 3;
                    this.tests = new Selector[]{sel};
                    return;
                }
                if (subOp.getOp() == 3) {
                    this.kind = 5;
                    return;
                }
                throw new IllegalArgumentException();
            }
            case 3: {
                this.identifier = (Identifier)oper.getOperands()[0];
                this.kind = 4;
                return;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                oper = SimpleTestImpl.simpleComparison(oper);
                this.identifier = (Identifier)oper.getOperands()[0];
                Object value = Matching.getEvaluator().eval(oper.getOperands()[1]);
                if (oper.getOp() == 45) {
                    this.kind = 2;
                    this.value = value;
                } else if (value instanceof String) {
                    this.kind = 3;
                    this.tests = new Selector[]{oper};
                } else {
                    this.recordNumericComparison(oper.getOp(), (Number)value);
                }
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    private void recordNumericComparison(int op, Number value) {
        this.kind = 6;
        switch (op) {
            case 42: {
                this.upper = value;
                return;
            }
            case 41: {
                this.lower = value;
                return;
            }
            case 44: {
                this.upper = value;
                this.upIncl = true;
                return;
            }
            case 43: {
                this.lower = value;
                this.lowIncl = true;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    private static Operator simpleComparison(Operator expr) {
        int op = expr.getOp();
        Selector idExpr = expr.getOperands()[0];
        Selector constantExpr = expr.getOperands()[1];
        if (idExpr.getNumIds() == 0) {
            Selector temp = constantExpr;
            constantExpr = idExpr;
            idExpr = temp;
            op = SimpleTestImpl.invertComparison(op);
        }
        while (!(idExpr instanceof Identifier)) {
            int newOp;
            Selector residue;
            Operator currOp = (Operator)idExpr;
            if (currOp.getOp() == 2) {
                op = SimpleTestImpl.invertComparison(op);
                idExpr = currOp.getOperands()[0];
                constantExpr = new OperatorImpl(2, constantExpr);
                continue;
            }
            if (currOp.getOperands()[0].getNumIds() == 0) {
                switch (currOp.getOp()) {
                    case 48: 
                    case 50: {
                        break;
                    }
                    case 49: {
                        op = SimpleTestImpl.invertComparison(op);
                        constantExpr = new OperatorImpl(2, constantExpr);
                        break;
                    }
                    case 51: {
                        op = SimpleTestImpl.invertComparison(op);
                        constantExpr = new OperatorImpl(51, new LiteralImpl(new Integer(1)), constantExpr);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                residue = currOp.getOperands()[0];
                idExpr = currOp.getOperands()[1];
            } else {
                residue = currOp.getOperands()[1];
                idExpr = currOp.getOperands()[0];
            }
            switch (currOp.getOp()) {
                case 48: {
                    newOp = 49;
                    break;
                }
                case 50: {
                    newOp = 51;
                    break;
                }
                case 49: {
                    newOp = 48;
                    break;
                }
                case 51: {
                    newOp = 50;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            constantExpr = new OperatorImpl(newOp, constantExpr, residue);
        }
        return new OperatorImpl(op, idExpr, constantExpr);
    }

    private static int invertComparison(int op) {
        switch (op) {
            case 40: 
            case 45: {
                return op;
            }
            case 42: {
                return 41;
            }
            case 41: {
                return 42;
            }
            case 44: {
                return 43;
            }
            case 43: {
                return 44;
            }
        }
        throw new IllegalArgumentException();
    }

    public Object getValue() {
        return this.value;
    }

    public boolean combine(SimpleTest other) {
        switch (this.kind) {
            case 0: 
            case 1: 
            case 4: {
                return this.kind == other.getKind();
            }
            case 5: {
                this.absorb(other);
                return true;
            }
            case 2: {
                if (other.getKind() == 2) {
                    return this.value.equals(other.getValue());
                }
                if (other.getKind() == 3) {
                    return this.selects((String)this.value, other.getTests());
                }
                return other.getKind() == 5;
            }
            case 3: {
                if (other.getKind() == 3) {
                    this.tests = this.append(this.tests, other.getTests());
                    return true;
                }
                if (other.getKind() == 2) {
                    if (this.selects((String)other.getValue(), this.tests)) {
                        this.absorb(other);
                        return true;
                    }
                    return false;
                }
                return other.getKind() == 5;
            }
            case 6: {
                if (other.getKind() == 6) {
                    return this.combineNumeric(other);
                }
                return other.getKind() == 5;
            }
        }
        throw new IllegalArgumentException();
    }

    protected void absorb(SimpleTest other) {
        this.identifier = other.getIdentifier();
        this.kind = other.getKind();
        this.value = other.getValue();
        this.tests = other.getTests();
        this.upper = other.getUpper();
        this.lower = other.getLower();
        this.upIncl = other.isUpIncl();
        this.lowIncl = other.isLowIncl();
    }

    private Selector[] append(Selector[] one, Selector[] two) {
        Selector[] ans = new Selector[one.length + two.length];
        System.arraycopy(one, 0, ans, 0, one.length);
        System.arraycopy(two, 0, ans, one.length, two.length);
        return ans;
    }

    private boolean selects(String value, Selector[] tests) {
        OneIdentifierContext ec = new OneIdentifierContext(value);
        EvalCacheImpl cache = new EvalCacheImpl();
        try {
            for (int i = 0; i < tests.length; ++i) {
                Boolean theEval = (Boolean)Matching.getEvaluator().eval(tests[i], ec, cache, null, false);
                if (theEval != null && theEval.booleanValue()) continue;
                return false;
            }
            return true;
        }
        catch (BadMessageFormatMatchingException e) {
            FFDC.processException((Object)this, (Class)cclass, (String)"com.ibm.ws.sib.matchspace.selector.impl.SimpleTest.selects", (Throwable)e, (String)"1:441:1.23");
            throw new IllegalStateException();
        }
    }

    private boolean combineNumeric(SimpleTest other) {
        boolean newLowIncl;
        Number newLower;
        boolean newUpIncl;
        Number newUpper;
        if (this.upper == null) {
            newUpper = other.getUpper();
            newUpIncl = other.isUpIncl();
        } else if (other.getUpper() == null) {
            newUpper = this.upper;
            newUpIncl = this.upIncl;
        } else {
            int upComp = EvaluatorImpl.compare(this.upper, other.getUpper());
            if (upComp < 0) {
                newUpper = this.upper;
                newUpIncl = this.upIncl;
            } else if (upComp == 0) {
                newUpper = this.upper;
                newUpIncl = this.upIncl & other.isUpIncl();
            } else {
                newUpper = other.getUpper();
                newUpIncl = other.isUpIncl();
            }
        }
        if (this.lower == null) {
            newLower = other.getLower();
            newLowIncl = other.isLowIncl();
        } else if (other.getLower() == null) {
            newLower = this.lower;
            newLowIncl = this.lowIncl;
        } else {
            int lowComp = EvaluatorImpl.compare(this.lower, other.getLower());
            if (lowComp > 0) {
                newLower = this.lower;
                newLowIncl = this.lowIncl;
            } else if (lowComp == 0) {
                newLower = this.lower;
                newLowIncl = this.lowIncl & other.isLowIncl();
            } else {
                newLower = other.getLower();
                newLowIncl = other.isLowIncl();
            }
        }
        if (newLower != null && newUpper != null) {
            int vTest = EvaluatorImpl.compare(newLower, newUpper);
            if (vTest > 0) {
                return false;
            }
            if (vTest == 0) {
                if (!newLowIncl || !newUpIncl) {
                    return false;
                }
                this.kind = 2;
                this.value = newUpper;
                this.lower = null;
                this.upper = null;
                this.lowIncl = false;
                this.upIncl = false;
                return true;
            }
        }
        this.upper = newUpper;
        this.lower = newLower;
        this.upIncl = newUpIncl;
        this.lowIncl = newLowIncl;
        return true;
    }

    public String toString() {
        return this.toSelector().toString();
    }

    public Selector toSelector() {
        switch (this.kind) {
            case 0: {
                return this.identifier;
            }
            case 1: {
                return new OperatorImpl(1, (Selector)this.identifier);
            }
            case 4: {
                return new OperatorImpl(3, (Selector)this.identifier);
            }
            case 5: {
                return new OperatorImpl(1, new OperatorImpl(3, (Selector)this.identifier));
            }
            case 2: {
                return new OperatorImpl(45, (Selector)this.identifier, new LiteralImpl(this.value));
            }
            case 3: {
                Object ans = null;
                for (int i = 0; i < this.tests.length; ++i) {
                    ans = ans == null ? this.tests[i] : new OperatorImpl(46, (Selector)ans, this.tests[i]);
                }
                return ans;
            }
            case 6: {
                if (this.upper == null) {
                    if (this.lowIncl) {
                        return new OperatorImpl(43, (Selector)this.identifier, new LiteralImpl(this.lower));
                    }
                    return new OperatorImpl(41, (Selector)this.identifier, new LiteralImpl(this.lower));
                }
                if (this.lower == null) {
                    if (this.upIncl) {
                        return new OperatorImpl(44, (Selector)this.identifier, new LiteralImpl(this.upper));
                    }
                    return new OperatorImpl(42, (Selector)this.identifier, new LiteralImpl(this.upper));
                }
                return new OperatorImpl(46, new OperatorImpl(this.lowIncl ? 43 : 41, (Selector)this.identifier, new LiteralImpl(this.lower)), new OperatorImpl(this.upIncl ? 44 : 42, (Selector)this.identifier, new LiteralImpl(this.upper)));
            }
        }
        throw new IllegalArgumentException();
    }

    boolean shedSubtests(List residual) {
        if (this.kind != 3) {
            return true;
        }
        Operator keep = null;
        for (int i = 0; i < this.tests.length; ++i) {
            Operator test = (Operator)this.tests[i];
            if (keep == null && test instanceof LikeOperatorImpl) {
                keep = test;
                continue;
            }
            residual.add(test);
        }
        if (keep == null) {
            return false;
        }
        this.tests = new Selector[]{keep};
        return true;
    }

    public int getKind() {
        return this.kind;
    }

    public Number getLower() {
        return this.lower;
    }

    public boolean isLowIncl() {
        return this.lowIncl;
    }

    public Selector[] getTests() {
        return this.tests;
    }

    public boolean isUpIncl() {
        return this.upIncl;
    }

    public Number getUpper() {
        return this.upper;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    private static final class OneIdentifierContext
    implements MatchSpaceKey {
        String value;

        OneIdentifierContext(String value) {
            this.value = value;
        }

        public Object getIdentifierValue(Identifier id, boolean ignoreType, Object contextValue, boolean returnList) {
            return this.value;
        }

        public Object getRootContext() {
            return null;
        }

        public Object getIdentifierValue(Identifier id, boolean ignoreType) throws BadMessageFormatMatchingException {
            return this.value;
        }
    }
}

