/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.context.service.serializable;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.container.service.metadata.extended.MetaDataIdentifierService;
import com.ibm.ws.context.service.serializable.ContextualCallable;
import com.ibm.ws.context.service.serializable.ContextualInvocationHandler;
import com.ibm.ws.context.service.serializable.ContextualRunnable;
import com.ibm.ws.context.service.serializable.ThreadContextDescriptorImpl;
import com.ibm.ws.javaee.version.JavaEEVersion;
import com.ibm.ws.kernel.service.util.SecureAction;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.threadcontext.ThreadContext;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import com.ibm.wsspi.threadcontext.ThreadContextProvider;
import com.ibm.wsspi.threadcontext.WSContextService;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(name="com.ibm.ws.context.manager", configurationPolicy=ConfigurationPolicy.IGNORE, service={WSContextService.class}, property={"service.pid=com.ibm.ws.context.manager", "default.for=contextService", "service.ranking:Integer=100"})
public class ThreadContextManager
implements WSContextService {
    static final SecureAction priv;
    private static final String COMPONENT_NAME = "component.name";
    private final Set<String> alwaysEnabled = Collections.newSetFromMap(new ConcurrentHashMap());
    volatile int eeVersion;
    private ServiceReference<JavaEEVersion> eeVersionRef;
    MetaDataIdentifierService metadataIdentifierService;
    final ConcurrentServiceReferenceMap<String, ThreadContextProvider> threadContextProviders = new ConcurrentServiceReferenceMap("threadContextProvider");
    static final long serialVersionUID = -2798422097181583173L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Activate
    protected void activate(ComponentContext context) {
        this.threadContextProviders.activate(context);
    }

    @Override
    public ThreadContextDescriptor captureThreadContext(Map<String, String> executionProperties, Map<String, ?> ... additionalThreadContextConfig) {
        Map<String, Map<String, ?>> threadContextConfigurations;
        Map<String, String> map = executionProperties = executionProperties == null ? new TreeMap<String, String>() : new TreeMap<String, String>(executionProperties);
        if (additionalThreadContextConfig.length > 0) {
            threadContextConfigurations = new HashMap();
            for (Map<String, ?> config : additionalThreadContextConfig) {
                String providerName = (String)config.get("threadContextProvider");
                if (providerName == null) {
                    throw new IllegalArgumentException("additionalThreadContextConfig: " + config);
                }
                threadContextConfigurations.put(providerName, config);
            }
        } else {
            threadContextConfigurations = Collections.emptyMap();
        }
        return this.captureThreadContext(threadContextConfigurations, executionProperties);
    }

    public ThreadContextDescriptor captureThreadContext(Map<String, Map<String, ?>> threadContextConfigurations, Map<String, String> execProps) {
        int initialCapacity = threadContextConfigurations == null ? 5 : threadContextConfigurations.size() + 5;
        ThreadContextDescriptorImpl capturedThreadContext = new ThreadContextDescriptorImpl(execProps, initialCapacity, this);
        if (!"ALL_CONTEXT_TYPES".equals(execProps.get("com.ibm.ws.concurrent.DEFAULT_CONTEXT"))) {
            int i;
            ArrayList<ThreadContextProvider> configuredProviders = new ArrayList<ThreadContextProvider>(threadContextConfigurations.size());
            ArrayList<Map.Entry> configuredProviderProps = new ArrayList<Map.Entry>(threadContextConfigurations.size());
            ArrayList<ThreadContextProvider> alwaysEnabledProviders = new ArrayList<ThreadContextProvider>(this.alwaysEnabled.size());
            ArrayList<String> alwaysEnabledProviderNames = new ArrayList<String>(this.alwaysEnabled.size());
            if (threadContextConfigurations != null) {
                for (Map.Entry entry : threadContextConfigurations.entrySet()) {
                    ThreadContextProvider provider2;
                    String threadContextProviderName = (String)entry.getKey();
                    if (capturedThreadContext.providerNamesToSkip.contains(threadContextProviderName) || (provider2 = (ThreadContextProvider)this.threadContextProviders.getService((Object)threadContextProviderName)) == null) continue;
                    configuredProviders.add(provider2);
                    configuredProviderProps.add(entry);
                }
            }
            for (String string : this.alwaysEnabled) {
                if (capturedThreadContext.providerNamesToSkip.contains(string)) continue;
                ThreadContextProvider provider3 = (ThreadContextProvider)this.threadContextProviders.getServiceWithException((Object)string);
                alwaysEnabledProviders.add(provider3);
                alwaysEnabledProviderNames.add(string);
            }
            for (i = 0; i < configuredProviders.size(); ++i) {
                ThreadContextProvider threadContextProvider = (ThreadContextProvider)configuredProviders.get(i);
                Map.Entry threadContextConfig = (Map.Entry)configuredProviderProps.get(i);
                ThreadContext context = threadContextProvider.captureThreadContext(execProps, (Map)threadContextConfig.getValue());
                capturedThreadContext.add((String)threadContextConfig.getKey(), context);
            }
            for (i = 0; i < alwaysEnabledProviders.size(); ++i) {
                ThreadContextProvider threadContextProvider = (ThreadContextProvider)alwaysEnabledProviders.get(i);
                if (configuredProviders.contains(threadContextProvider)) continue;
                ThreadContext context = threadContextProvider.captureThreadContext(execProps, null);
                capturedThreadContext.add((String)alwaysEnabledProviderNames.get(i), context);
            }
        }
        return capturedThreadContext;
    }

    @Override
    public <T> T createContextualProxy(ThreadContextDescriptor threadContextDescriptor, T instance, Class<T> intf) {
        if (intf == null || !intf.isInstance(instance)) {
            throw new IllegalArgumentException(instance + ", " + (intf == null ? null : intf.getName()));
        }
        if (Callable.class.equals(intf)) {
            Callable callable = (Callable)instance;
            instance = intf.cast(new ContextualCallable(threadContextDescriptor, callable, null));
        } else if (Runnable.class.equals(intf)) {
            instance = intf.cast(new ContextualRunnable(threadContextDescriptor, (Runnable)instance, null));
        } else {
            ContextualInvocationHandler handler = new ContextualInvocationHandler(threadContextDescriptor, instance, null);
            instance = AccessController.doPrivileged(new ProxyInstance(intf, handler));
        }
        return instance;
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.threadContextProviders.deactivate(context);
    }

    @Modified
    protected void modified(ComponentContext context) {
    }

    @Reference(service=JavaEEVersion.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setEEVersion(ServiceReference<JavaEEVersion> ref) {
        String version = (String)ref.getProperty("version");
        if (version == null) {
            this.eeVersion = 0;
        } else {
            int dot = version.indexOf(46);
            String major = dot > 0 ? version.substring(0, dot) : version;
            this.eeVersion = Integer.parseInt(major);
        }
        this.eeVersionRef = ref;
    }

    @Reference(service=MetaDataIdentifierService.class)
    protected void setMetadataIdentifierService(MetaDataIdentifierService svc) {
        this.metadataIdentifierService = svc;
    }

    @Reference(name="threadContextProvider", service=ThreadContextProvider.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setThreadContextProvider(ServiceReference<ThreadContextProvider> ref) {
        String threadContextProviderName = (String)ref.getProperty(COMPONENT_NAME);
        this.threadContextProviders.putReference((Object)threadContextProviderName, ref);
        if (Boolean.TRUE.equals(ref.getProperty("alwaysCaptureThreadContext"))) {
            this.alwaysEnabled.add(threadContextProviderName);
        }
    }

    protected void unsetEEVersion(ServiceReference<JavaEEVersion> ref) {
        if (this.eeVersionRef == ref) {
            this.eeVersionRef = null;
            this.eeVersion = 0;
        }
    }

    protected void unsetMetadataIdentifierService(MetaDataIdentifierService svc) {
        this.metadataIdentifierService = null;
    }

    protected void unsetThreadContextProvider(ServiceReference<ThreadContextProvider> ref) {
        String threadContextProviderName = (String)ref.getProperty(COMPONENT_NAME);
        if (this.threadContextProviders.removeReference((Object)threadContextProviderName, ref) && Boolean.TRUE.equals(ref.getProperty("alwaysCaptureThreadContext"))) {
            this.alwaysEnabled.remove(threadContextProviderName);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.context.service.serializable.ThreadContextManager", ThreadContextManager.class, (String)"context", (String)"com.ibm.ws.context.service.resources.CWWKCMessages");
        priv = (SecureAction)AccessController.doPrivileged(SecureAction.get());
    }

    @Trivial
    private static final class ProxyInstance<T>
    implements PrivilegedAction<T> {
        private final InvocationHandler handler;
        private final Class<T> intf;

        private ProxyInstance(Class<T> intf, InvocationHandler handler) {
            this.intf = intf;
            this.handler = handler;
        }

        @Override
        public T run() {
            return this.intf.cast(Proxy.newProxyInstance(this.intf.getClassLoader(), new Class[]{this.intf}, this.handler));
        }
    }
}

