/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.targets.internal;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.annocache.service.internal.AnnotationCacheServiceImpl_Logging;
import com.ibm.ws.annocache.targets.TargetsTableContainers;
import com.ibm.ws.annocache.targets.cache.TargetCache_ParseError;
import com.ibm.ws.annocache.targets.cache.TargetCache_Readable;
import com.ibm.ws.annocache.targets.cache.TargetCache_Reader;
import com.ibm.ws.annocache.targets.internal.AnnotationTargetsImpl_Factory;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.annocache.classsource.ClassSource;
import com.ibm.wsspi.annocache.classsource.ClassSource_Aggregate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class TargetsTableContainersImpl
implements TargetsTableContainers,
TargetCache_Readable {
    protected static final Logger logger = AnnotationCacheServiceImpl_Logging.ANNO_LOGGER;
    public static final String CLASS_NAME = TargetsTableContainersImpl.class.getSimpleName();
    protected final String hashText;
    protected final AnnotationTargetsImpl_Factory factory;
    protected final List<String> names;
    protected final Map<String, String> signatures;
    protected final Map<String, ClassSource_Aggregate.ScanPolicy> policies;
    public static final boolean DO_SHOW_DETAILS = true;
    public static final String COARSE_CHANGE = "Changed";
    static final long serialVersionUID = -1336051974029191989L;

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getHashText() {
        return this.hashText;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetsTableContainersImpl(AnnotationTargetsImpl_Factory factory) {
        String methodName = "<init>";
        this.factory = factory;
        this.hashText = this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
        this.names = new ArrayList<String>();
        this.signatures = new HashMap<String, String>();
        this.policies = new HashMap<String, ClassSource_Aggregate.ScanPolicy>();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ]", this.hashText);
        }
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public AnnotationTargetsImpl_Factory getFactory() {
        return this.factory;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void putSignature(String name, String signature) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "putSignature", new Object[]{name, signature});
        }
        if (signature != null) {
            this.signatures.put(name, signature);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "putSignature");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void addName(String name, String signature, ClassSource_Aggregate.ScanPolicy policy) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "addName", new Object[]{name, signature, policy});
        }
        this.names.add(name);
        this.putSignature(name, signature);
        this.policies.put(name, policy);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "addName");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void addNameAfter(String name, String signature, ClassSource_Aggregate.ScanPolicy policy, String afterName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "addNameAfter", new Object[]{name, signature, policy, afterName});
        }
        int addOffset = this.names.indexOf(afterName);
        if (addOffset == -1) {
            throw new IndexOutOfBoundsException("Name [ " + afterName + " ] is not within container table [ " + this.getHashText() + " ]");
        }
        this.names.add(addOffset + 1, name);
        this.putSignature(name, signature);
        this.policies.put(name, policy);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "addNameAfter");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void addNameBefore(String name, String signature, ClassSource_Aggregate.ScanPolicy policy, String beforeName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "addNameBefore", new Object[]{name, signature, policy, beforeName});
        }
        int addOffset = this.names.indexOf(beforeName);
        if (addOffset == -1) {
            throw new IndexOutOfBoundsException("Name [ " + beforeName + " ] is not within container table [ " + this.getHashText() + " ]");
        }
        this.names.add(addOffset, name);
        this.putSignature(name, signature);
        this.policies.put(name, policy);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "addNameBefore");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClassSource_Aggregate.ScanPolicy removeName(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "removeName", new Object[]{name});
        }
        this.names.remove(name);
        this.signatures.remove(name);
        ClassSource_Aggregate.ScanPolicy scanPolicy = this.policies.remove(name);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            scanPolicy = scanPolicy;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "removeName", (Object)scanPolicy);
        }
        return scanPolicy;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<String> getNames() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "getNames", new Object[0]);
        }
        List<String> list = this.names;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "getNames", list);
        }
        return list;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean containsName(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "containsName", new Object[]{name});
        }
        boolean bl = this.policies.containsKey(name);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "containsName", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getSignature(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "getSignature", new Object[]{name});
        }
        String string = this.signatures.get(name);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "getSignature", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ClassSource_Aggregate.ScanPolicy getPolicy(String name) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "getPolicy", new Object[]{name});
        }
        ClassSource_Aggregate.ScanPolicy scanPolicy = this.policies.get(name);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            scanPolicy = scanPolicy;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "getPolicy", (Object)scanPolicy);
        }
        return scanPolicy;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void addNames(ClassSource_Aggregate rootClassSource) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "addNames", new Object[]{rootClassSource});
        }
        for (ClassSource classSource : rootClassSource.getClassSources()) {
            ClassSource_Aggregate.ScanPolicy scanPolicy = rootClassSource.getScanPolicy(classSource);
            if (scanPolicy == ClassSource_Aggregate.ScanPolicy.EXTERNAL) continue;
            String canonicalName = classSource.getCanonicalName();
            String signature = classSource.getStamp();
            this.addName(canonicalName, signature, scanPolicy);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "addNames");
        }
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void log(Logger useLogger) {
        String methodName = "log";
        if (!useLogger.isLoggable(Level.FINER)) {
            return;
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Containers: BEGIN");
        for (String name : this.getNames()) {
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  Name: " + name);
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  Signature: " + this.getSignature(name));
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "  Policy: " + (Object)((Object)this.getPolicy(name)));
        }
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Containers: END");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String sameAs(TargetsTableContainersImpl otherTable, boolean showDetails) {
        List<String> otherNames;
        int otherCount;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "sameAs", new Object[]{otherTable, showDetails});
        }
        if (otherTable == null) {
            String string = showDetails ? "Prior null table" : COARSE_CHANGE;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "sameAs", string);
            }
            return string;
        }
        if (otherTable == this) {
            String string = null;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "sameAs", string);
            }
            return string;
        }
        List<String> theseNames = this.getNames();
        int thisCount = theseNames.size();
        if (thisCount != (otherCount = (otherNames = otherTable.getNames()).size())) {
            if (!showDetails) {
                String string = COARSE_CHANGE;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    string = string;
                    logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "sameAs", string);
                }
                return string;
            }
            String string = "Container count changed from [ " + otherCount + " ] to [ " + thisCount + " ]";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "sameAs", string);
            }
            return string;
        }
        for (int nameNo = 0; nameNo < thisCount; ++nameNo) {
            ClassSource_Aggregate.ScanPolicy otherPolicy;
            String otherName;
            String thisName = theseNames.get(nameNo);
            if (!thisName.equals(otherName = otherNames.get(nameNo))) {
                if (!showDetails) {
                    String string = COARSE_CHANGE;
                    if (logger != null && logger.isLoggable(Level.FINER)) {
                        string = string;
                        logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "sameAs", string);
                    }
                    return string;
                }
                String string = "Container number [ " + nameNo + " ]: Name changed from [ " + otherName + " ] to [ " + thisName + " ]";
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    string = string;
                    logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "sameAs", string);
                }
                return string;
            }
            String thisSig = this.getSignature(thisName);
            String otherSig = otherTable.getSignature(thisName);
            if (thisSig == null) {
                if (!showDetails) {
                    String string = COARSE_CHANGE;
                    if (logger != null && logger.isLoggable(Level.FINER)) {
                        string = string;
                        logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "sameAs", string);
                    }
                    return string;
                }
                String string = "Container number [ " + nameNo + " ] named [ " + thisName + " ]: Uncomparable signature [ " + thisSig + " ]";
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    string = string;
                    logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "sameAs", string);
                }
                return string;
            }
            if (otherSig == null || !thisSig.equals(otherSig)) {
                if (!showDetails) {
                    String string = COARSE_CHANGE;
                    if (logger != null && logger.isLoggable(Level.FINER)) {
                        string = string;
                        logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "sameAs", string);
                    }
                    return string;
                }
                String string = "Container number [ " + nameNo + " ] named [ " + thisName + " ]: Signature changed from [ " + otherSig + " ] to [ " + thisSig + " ]";
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    string = string;
                    logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "sameAs", string);
                }
                return string;
            }
            ClassSource_Aggregate.ScanPolicy thisPolicy = this.getPolicy(thisName);
            if (thisPolicy == (otherPolicy = otherTable.getPolicy(thisName))) continue;
            if (!showDetails) {
                String string = COARSE_CHANGE;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    string = string;
                    logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "sameAs", string);
                }
                return string;
            }
            String string = "Container number [ " + nameNo + " ] named [ " + thisName + " ]: Policy changed from [ " + (Object)((Object)otherPolicy) + " ] to [ " + (Object)((Object)thisPolicy) + " ]";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "sameAs", string);
            }
            return string;
        }
        String string = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "sameAs", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<TargetCache_ParseError> readUsing(TargetCache_Reader reader) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "readUsing", new Object[]{reader});
        }
        List<TargetCache_ParseError> list = reader.read(this);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl", "readUsing", list);
        }
        return list;
    }
}

