/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.InternalTransaction;
import com.ibm.ws.objectManager.LogRecord;
import com.ibm.ws.objectManager.LogicalUnitOfWork;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerByteArrayOutputStream;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.ObjectManagerState;
import com.ibm.ws.objectManager.Transaction;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import java.io.DataInputStream;

class TransactionBackoutLogRecord
extends LogRecord {
    private static final Class cclass = TransactionBackoutLogRecord.class;
    private static Trace trace = ObjectManager.traceFactory.getTrace(cclass, "ObjectManagerTransactions");
    private static final long serialVersionUID = 4921554013027150249L;
    protected LogicalUnitOfWork logicalUnitOfWork;

    protected TransactionBackoutLogRecord(InternalTransaction internalTransaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{internalTransaction});
        }
        this.logicalUnitOfWork = internalTransaction.getLogicalUnitOfWork();
        this.buffers = this.getBuffers(internalTransaction.logRecordByteArrayOutputStream);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    protected TransactionBackoutLogRecord(DataInputStream dataInputStream) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", dataInputStream);
        }
        this.logicalUnitOfWork = new LogicalUnitOfWork(dataInputStream);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    public ObjectManagerByteArrayOutputStream[] getBuffers(ObjectManagerByteArrayOutputStream byteArrayOutputStream) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "getBuffers");
        }
        ObjectManagerByteArrayOutputStream[] buffers = new ObjectManagerByteArrayOutputStream[1];
        byteArrayOutputStream.reset();
        buffers[0] = byteArrayOutputStream;
        buffers[0].writeInt(7);
        this.logicalUnitOfWork.writeSerializedBytes(buffers[0]);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getBuffers", new Object[]{buffers});
        }
        return buffers;
    }

    @Override
    public void performRecovery(ObjectManagerState objectManagerState) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "performRecovery", new Object[]{objectManagerState, this.logicalUnitOfWork});
        }
        Transaction transactionForRecovery = objectManagerState.getTransaction(this.logicalUnitOfWork);
        transactionForRecovery.backout(false);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "performRecovery");
        }
    }

    protected static long maximumSerializedSize() {
        return 4L + LogicalUnitOfWork.maximumSerializedSize();
    }
}

