/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.component.globalhandler;

import com.ibm.webservices.handler.impl.GlobalHandlerService;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxrs20.bus.LibertyApplicationBus;
import com.ibm.ws.jaxrs20.component.Jaxrs20GlobalHandlerServiceImpl;
import com.ibm.ws.jaxrs20.component.globalhandler.JAXRS20MessageContextImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.webservices.handler.GlobalHandlerMessageContext;
import com.ibm.wsspi.webservices.handler.Handler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cxf.jaxrs.interceptor.JAXRSInInterceptor;
import org.apache.cxf.jaxrs.interceptor.JAXRSOutInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class GlobalHandlerInterceptor<T extends Message>
extends AbstractPhaseInterceptor<T> {
    private final String flow;
    private final LibertyApplicationBus.Type busType;
    private List<Handler> handlersList;
    static final long serialVersionUID = 6724602399696660520L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public GlobalHandlerInterceptor(String phase, String flowType, LibertyApplicationBus.Type bus) {
        super(phase);
        this.flow = flowType.toLowerCase();
        this.busType = bus;
        if (flowType.equalsIgnoreCase("in")) {
            this.addBefore(JAXRSInInterceptor.class.getName());
        }
        if (flowType.equalsIgnoreCase("out")) {
            this.addAfter(JAXRSOutInterceptor.class.getName());
        }
    }

    public void handleMessage(Message message) {
        this.handlersList = this.getHanderList(this.busType, this.flow);
        if (this.handlersList == null || this.handlersList.size() == 0) {
            return;
        }
        ArrayList<Handler> excutedHandlers = new ArrayList<Handler>();
        JAXRS20MessageContextImpl jaxrsMessageContext = new JAXRS20MessageContextImpl(message);
        jaxrsMessageContext.isServerSide = this.busType.equals((Object)LibertyApplicationBus.Type.SERVER);
        jaxrsMessageContext.isClientSide = this.busType.equals((Object)LibertyApplicationBus.Type.CLIENT);
        jaxrsMessageContext.setProperty("flow.type", this.flow.toUpperCase());
        try {
            for (Handler handler : this.handlersList) {
                handler.handleMessage((GlobalHandlerMessageContext)jaxrsMessageContext);
                excutedHandlers.add(handler);
            }
        }
        catch (Exception it) {
            FFDCFilter.processException((Throwable)it, (String)"com.ibm.ws.jaxrs20.component.globalhandler.GlobalHandlerInterceptor", (String)"83", (Object)((Object)this), (Object[])new Object[]{message});
            for (int i = excutedHandlers.size() - 1; i >= 0; --i) {
                ((Handler)excutedHandlers.get(i)).handleFault((GlobalHandlerMessageContext)jaxrsMessageContext);
            }
        }
    }

    private List<Handler> getHanderList(LibertyApplicationBus.Type busType, String flow) {
        GlobalHandlerService globalHandlerService = Jaxrs20GlobalHandlerServiceImpl.globalHandlerService;
        if (globalHandlerService == null) {
            return Collections.emptyList();
        }
        if (busType == LibertyApplicationBus.Type.SERVER && flow.equalsIgnoreCase("IN")) {
            return globalHandlerService.getJAXRSServerSideInFlowGlobalHandlers();
        }
        if (busType == LibertyApplicationBus.Type.SERVER && flow.equalsIgnoreCase("OUT")) {
            return globalHandlerService.getJAXRSServerSideOutFlowGlobalHandlers();
        }
        if (busType == LibertyApplicationBus.Type.CLIENT && flow.equalsIgnoreCase("IN")) {
            return globalHandlerService.getJAXRSClientSideInFlowGlobalHandlers();
        }
        if (busType == LibertyApplicationBus.Type.CLIENT && flow.equalsIgnoreCase("OUT")) {
            return globalHandlerService.getJAXRSClientSideOutFlowGlobalHandlers();
        }
        return Collections.emptyList();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxrs20.component.globalhandler.GlobalHandlerInterceptor", GlobalHandlerInterceptor.class, null, null);
    }
}

