/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.spi.expression.literal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.data.messages.Messages;
import jakarta.data.spi.expression.literal.TemporalLiteral;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Year;
import java.time.ZoneOffset;
import java.time.temporal.Temporal;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
final class TemporalLiteralRecord<V extends Temporal & Comparable<? extends Temporal>>
extends Record
implements TemporalLiteral<V> {
    private final V value;
    static final long serialVersionUID = 7259571972096034002L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    TemporalLiteralRecord(V value) {
        Messages.requireNonNull(value, "value");
        this.value = value;
    }

    @Override
    public String toString() {
        Object temporal;
        V v = this.value;
        if (v instanceof Instant) {
            Instant i = (Instant)v;
            temporal = i.atOffset(ZoneOffset.UTC).toLocalDateTime();
        } else {
            temporal = this.value;
        }
        if (temporal instanceof Year) {
            Year y = (Year)temporal;
            return "{d '" + y.getValue() + "'}";
        }
        if (temporal instanceof LocalDate) {
            return "{d '" + String.valueOf(this.value) + "'}";
        }
        if (temporal instanceof LocalDateTime) {
            LocalDateTime d = (LocalDateTime)temporal;
            return "{ts '" + String.valueOf(d.toLocalDate()) + " " + String.valueOf(d.toLocalTime()) + "'}";
        }
        if (temporal instanceof LocalTime) {
            return "{t '" + String.valueOf(this.value) + "'}";
        }
        return "{TemporalLiteral '" + this.value.getClass().getName() + " '" + String.valueOf(this.value) + "'}";
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TemporalLiteralRecord.class, "value", "value"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TemporalLiteralRecord.class, "value", "value"}, this, o);
    }

    @Override
    public V value() {
        return this.value;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"jakarta.data.spi.expression.literal.TemporalLiteralRecord", TemporalLiteralRecord.class, null, null);
    }
}

