/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.spi.expression.function;

import jakarta.data.expression.Expression;
import jakarta.data.expression.NumericExpression;
import jakarta.data.messages.Messages;
import jakarta.data.spi.expression.function.NumericOperatorExpressionRecord;
import jakarta.data.spi.expression.literal.NumericLiteral;

public interface NumericOperatorExpression<T, N extends Number>
extends NumericExpression<T, N> {
    public Expression<? super T, N> left();

    public static <T, N extends Number> NumericOperatorExpression<T, N> of(Operator operator, N left, NumericExpression<T, N> right) {
        Messages.requireNonNull(left, "left");
        return new NumericOperatorExpressionRecord<T, N>(operator, NumericLiteral.of(left), right);
    }

    public static <T, N extends Number> NumericOperatorExpression<T, N> of(Operator operator, NumericExpression<T, N> left, N right) {
        Messages.requireNonNull(right, "right");
        return new NumericOperatorExpressionRecord<T, N>(operator, left, NumericLiteral.of(right));
    }

    public static <T, N extends Number> NumericOperatorExpression<T, N> of(Operator operator, NumericExpression<T, N> left, NumericExpression<? super T, N> right) {
        return new NumericOperatorExpressionRecord<T, N>(operator, left, right);
    }

    public Operator operator();

    public Expression<? super T, N> right();

    public static enum Operator {
        PLUS,
        MINUS,
        TIMES,
        DIVIDE;

    }
}

