/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.internal.oauth20.tokentype.impl;

import com.ibm.oauth.core.api.attributes.AttributeList;
import com.ibm.oauth.core.api.config.OAuthComponentConfiguration;
import com.ibm.oauth.core.api.error.OAuthException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20DuplicateParameterException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20MissingParameterException;
import com.ibm.oauth.core.api.oauth20.token.OAuth20Token;
import com.ibm.oauth.core.internal.oauth20.OAuth20Util;
import com.ibm.oauth.core.internal.oauth20.token.OAuth20TokenHelper;
import com.ibm.oauth.core.internal.oauth20.token.impl.OAuth20AccessTokenBearerImpl;
import com.ibm.oauth.core.internal.oauth20.tokentype.OAuth20TokenTypeHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class OAuth20TokenTypeHandlerBearerImpl
implements OAuth20TokenTypeHandler {
    static final String CLASS = OAuth20TokenTypeHandlerBearerImpl.class.getName();
    private static Logger _log = Logger.getLogger(CLASS);

    @Override
    public void init(OAuthComponentConfiguration config) {
    }

    @Override
    public String getTypeTokenType() {
        return "Bearer";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OAuth20Token createToken(Map<String, String[]> tokenMap) {
        String methodName = "createToken";
        _log.entering(CLASS, methodName);
        OAuth20AccessTokenBearerImpl token = null;
        try {
            String clientId = OAuth20Util.getValueFromMap("client_id", tokenMap);
            String componentId = OAuth20Util.getValueFromMap("COMPONENTID", tokenMap);
            String username = OAuth20Util.getValueFromMap("username", tokenMap);
            String redirectUri = OAuth20Util.getValueFromMap("redirect_uri", tokenMap);
            String[] scope = tokenMap.get("scope");
            int length = 0;
            int lifetime = 0;
            String lengthStr = OAuth20Util.getValueFromMap("LENGTH", tokenMap);
            length = Integer.parseInt(lengthStr);
            String lifeStr = OAuth20Util.getValueFromMap("LIFETIME", tokenMap);
            lifetime = Integer.parseInt(lifeStr);
            String stateId = OAuth20Util.getValueFromMap("state_id", tokenMap);
            if (stateId == null) {
                stateId = OAuth20Util.generateUUID();
            }
            String grantType = OAuth20Util.getValueFromMap("grant_type", tokenMap);
            Map<String, String[]> externalClaims = OAuth20TokenHelper.getExternalClaims(tokenMap);
            String tokenString = OAuth20Util.getRandom(length);
            token = new OAuth20AccessTokenBearerImpl(tokenString, componentId, clientId, username, redirectUri, stateId, scope, lifetime, externalClaims, grantType);
        }
        finally {
            _log.exiting(CLASS, methodName);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getKeysTokenType(AttributeList attributeList) throws OAuthException {
        String methodName = "getKeysTokenType";
        _log.entering(CLASS, methodName);
        ArrayList<String> tokenKeys = null;
        try {
            String token = attributeList.getAttributeValueByName("access_token");
            if (token == null || token.length() <= 0) {
                throw new OAuth20MissingParameterException("security.oauth20.error.missing.parameter", "access_token", null);
            }
            tokenKeys = new ArrayList<String>();
            tokenKeys.add(token);
        }
        finally {
            _log.exiting(CLASS, methodName);
        }
        return tokenKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateRequestTokenType(AttributeList attributeList, List<OAuth20Token> tokens) throws OAuthException {
        String methodName = "validateRequestTokenType";
        _log.entering(CLASS, methodName);
        try {
            String[] tokenArray = attributeList.getAttributeValuesByName("access_token");
            if (tokenArray != null && tokenArray.length > 1) {
                throw new OAuth20DuplicateParameterException("security.oauth20.error.duplicate.parameter", "access_token");
            }
        }
        finally {
            _log.exiting(CLASS, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildResponseTokenType(AttributeList attributeList, List<OAuth20Token> tokens) {
        String methodName = "buildResponseTokenType";
        _log.entering(CLASS, methodName);
        try {
            OAuth20Token token;
            if (tokens.size() >= 1 && (token = tokens.get(0)) != null) {
                attributeList.setAttribute("expires", "urn:ibm:names:oauth:response:decision", new String[]{OAuth20TokenHelper.expiresUTC(token)});
                attributeList.setAttribute("username", "urn:ibm:names:oauth:response:attribute", new String[]{token.getUsername()});
                attributeList.setAttribute("access_token", "urn:ibm:names:oauth:response:attribute", new String[]{token.getTokenString()});
                attributeList.setAttribute("access_token_id", "urn:ibm:names:oauth:response:metadata", new String[]{token.getId()});
                attributeList.setAttribute("oauth_token_client_id", "urn:ibm:names:oauth:response:attribute", new String[]{token.getClientId()});
                attributeList.setAttribute("state_id", "urn:ibm:names:oauth:state", new String[]{token.getStateId()});
                String[] scope = token.getScope();
                if (scope != null) {
                    attributeList.setAttribute("scope", "urn:ibm:names:oauth:response:attribute", scope);
                }
            }
        }
        finally {
            _log.exiting(CLASS, methodName);
        }
    }
}

