/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.security.impl;

import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.time.Instant;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.messaging.context.SAMLMessageInfoContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageLifetimeSecurityHandler
extends AbstractMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(MessageLifetimeSecurityHandler.class);
    @Nonnull
    private Duration clockSkew = Duration.ofMinutes(3L);
    @Nonnull
    private Duration messageLifetime = Duration.ofMinutes(3L);
    private boolean requiredRule = true;

    @Nonnull
    public Duration getClockSkew() {
        return this.clockSkew;
    }

    public void setClockSkew(@Nonnull Duration skew) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.clockSkew = (Duration)Constraint.isNotNull((Object)skew, (String)"Clock skew cannot be null");
    }

    @Nonnull
    public Duration getMessageLifetime() {
        return this.messageLifetime;
    }

    public synchronized void setMessageLifetime(@Nonnull Duration lifetime) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull((Object)lifetime, (String)"Lifetime cannot be null");
        Constraint.isFalse((boolean)lifetime.isNegative(), (String)"Lifetime cannot be negative");
        this.messageLifetime = lifetime;
    }

    public boolean isRequiredRule() {
        return this.requiredRule;
    }

    public void setRequiredRule(boolean required) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.requiredRule = required;
    }

    public void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        SAMLMessageInfoContext msgInfoContext = (SAMLMessageInfoContext)messageContext.getSubcontext(SAMLMessageInfoContext.class, true);
        if (msgInfoContext.getMessageIssueInstant() == null) {
            if (this.requiredRule) {
                this.log.warn("{} Inbound SAML message issue instant not present in message context", (Object)this.getLogPrefix());
                throw new MessageHandlerException("Inbound SAML message issue instant not present in message context");
            }
            return;
        }
        Instant issueInstant = msgInfoContext.getMessageIssueInstant();
        Instant now = Instant.now();
        Instant latestValid = now.plus(this.getClockSkew().abs());
        Instant expiration = issueInstant.plus(this.getClockSkew().abs()).plus(this.getMessageLifetime());
        if (issueInstant.isAfter(latestValid)) {
            this.log.warn("{} Message was not yet valid: message time was {}, latest valid is: {}", new Object[]{this.getLogPrefix(), issueInstant, latestValid});
            throw new MessageHandlerException("Message was rejected because it was issued in the future");
        }
        if (expiration.isBefore(now)) {
            this.log.warn("{} Message was expired: message time was '{}', message expired at: '{}', current time: '{}'", new Object[]{this.getLogPrefix(), issueInstant, expiration, now});
            throw new MessageHandlerException("Message was rejected due to issue instant expiration");
        }
    }
}

