/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.wssecurity;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import io.openliberty.wssecurity.WSSecurityFeatureHelperService;
import java.net.URL;
import java.util.Map;
import org.apache.cxf.binding.soap.SoapMessage;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={WSSecurityFeatureHelper.class}, name="WSSecurityFeatureHelper", immediate=true, property={"service.vendor=IBM"})
public class WSSecurityFeatureHelper {
    private static final TraceComponent tc = Tr.register(WSSecurityFeatureHelper.class, null, null);
    static final String WSSEC_HELPER_SERVICE = "WSSecurityFeatureHelperService";
    protected static final AtomicServiceReference<WSSecurityFeatureHelperService> WssecurityFeatureHelperServiceRef = new AtomicServiceReference("WSSecurityFeatureHelperService");
    static final long serialVersionUID = 4830735359454212151L;

    public boolean isWSSecurityFeatureHelperServiceActive() {
        return WssecurityFeatureHelperServiceRef.getService() != null;
    }

    public void handleEhcache2Mapping(String key, URL url, SoapMessage message) {
        WSSecurityFeatureHelperService wssecFeatureHelperservice = this.getWSSecurityFeatureHelperService();
        if (wssecFeatureHelperservice != null) {
            wssecFeatureHelperservice.handleEhcache2Mapping(key, url, message);
        }
    }

    private WSSecurityFeatureHelperService getWSSecurityFeatureHelperService() {
        return (WSSecurityFeatureHelperService)WssecurityFeatureHelperServiceRef.getService();
    }

    @Reference(service=WSSecurityFeatureHelperService.class, name="WSSecurityFeatureHelperService", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setWSSecurityFeatureHelperService(ServiceReference<WSSecurityFeatureHelperService> ref) {
        WssecurityFeatureHelperServiceRef.setReference(ref);
    }

    protected void unsetWSSecurityFeatureHelperService(ServiceReference<WSSecurityFeatureHelperService> ref) {
        WssecurityFeatureHelperServiceRef.unsetReference(ref);
    }

    @Activate
    protected void activate(ComponentContext cc) {
        WssecurityFeatureHelperServiceRef.activate(cc);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"WssecurityFeatureHelper  service is activated", (Object[])new Object[0]);
        }
    }

    @Modified
    protected void modified(Map<String, Object> props) {
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        WssecurityFeatureHelperServiceRef.deactivate(cc);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"WssecurityFeatureHelper service is de-activated", (Object[])new Object[0]);
        }
    }
}

