/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.api.error.oauth20;

import com.ibm.oauth.core.api.error.oauth20.OAuth20Exception;
import com.ibm.oauth.core.api.error.oauth20.OAuth20ExceptionUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.security.oauth20.web.WebUtils;
import java.text.MessageFormat;
import java.util.Locale;

public class OAuth20InvalidTokenRequestMethodException
extends OAuth20Exception {
    private static final TraceComponent tc = Tr.register(OAuth20InvalidTokenRequestMethodException.class, (String)"OAUTH20", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    private static final long serialVersionUID = 1L;
    private String _method;

    public OAuth20InvalidTokenRequestMethodException(String method) {
        super("invalid_request", "An invalid HTTP method was used at the token endpoint: " + method, null);
        this._method = method;
    }

    public OAuth20InvalidTokenRequestMethodException(String msgKey, String method) {
        super("invalid_request", Tr.formatMessage((TraceComponent)tc, (String)msgKey, (Object[])new Object[]{method}), null);
        this._msgKey = msgKey;
        this._method = method;
    }

    @Override
    public String formatSelf(Locale locale, String encoding) {
        return MessageFormat.format(OAuth20ExceptionUtil.getResourceBundle(locale).getString(this._msgKey), WebUtils.encode(this._method, locale, encoding));
    }

    public String getMethod() {
        return this._method;
    }
}

