/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.GraphQLContext;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.ExecutionId;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.schema.GraphQLSchema;
import io.smallrye.graphql.SmallRyeGraphQLServerLogging;
import io.smallrye.graphql.api.Context;
import io.smallrye.graphql.bootstrap.Config;
import io.smallrye.graphql.bootstrap.DataFetcherFactory;
import io.smallrye.graphql.execution.QueryCache;
import io.smallrye.graphql.execution.context.SmallRyeBatchLoaderContextProvider;
import io.smallrye.graphql.execution.context.SmallRyeContext;
import io.smallrye.graphql.execution.datafetcher.helper.BatchLoaderHelper;
import io.smallrye.graphql.execution.error.ExceptionHandler;
import io.smallrye.graphql.execution.error.ExecutionErrorsService;
import io.smallrye.graphql.execution.event.EventEmitter;
import io.smallrye.graphql.schema.model.Operation;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonValue;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;
import org.dataloader.BatchLoaderContextProvider;
import org.dataloader.BatchLoaderWithContext;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderOptions;
import org.dataloader.DataLoaderRegistry;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ExecutionService {
    private static final JsonBuilderFactory jsonObjectFactory;
    private static final JsonReaderFactory jsonReaderFactory;
    private static final Jsonb jsonB;
    private final String executionIdPrefix;
    private final AtomicLong executionId = new AtomicLong();
    private final ExecutionErrorsService errorsService = new ExecutionErrorsService();
    private final Config config;
    private final GraphQLSchema graphQLSchema;
    private final BatchLoaderHelper batchLoaderHelper = new BatchLoaderHelper();
    private final DataFetcherFactory dataFetcherFactory;
    private final List<Operation> batchOperations;
    private final EventEmitter eventEmitter;
    private GraphQL graphQL;
    private static final String DATA = "data";
    private static final String ERRORS = "errors";
    static final long serialVersionUID = -1098276501510409417L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ExecutionService(Config config, GraphQLSchema graphQLSchema, List<Operation> batchOperations) {
        this.config = config;
        this.graphQLSchema = graphQLSchema;
        this.dataFetcherFactory = new DataFetcherFactory(config);
        this.batchOperations = batchOperations;
        this.eventEmitter = EventEmitter.getInstance(config);
        this.executionIdPrefix = Integer.toString(Objects.hashCode(graphQLSchema));
    }

    @FFDCIgnore(value={Throwable.class})
    public JsonObject execute(JsonObject jsonInput) {
        SmallRyeContext context = new SmallRyeContext(jsonInput);
        ExecutionId finalExecutionId = ExecutionId.from((String)(this.executionIdPrefix + this.executionId.getAndIncrement()));
        try {
            GraphQL g;
            String query = context.getQuery();
            if (this.config.logPayload()) {
                SmallRyeGraphQLServerLogging.log.payloadIn(query);
            }
            if ((g = this.getGraphQL()) != null) {
                ExecutionInput.Builder executionBuilder = ExecutionInput.newExecutionInput().query(query).executionId(finalExecutionId);
                context.getVariables().ifPresent(arg_0 -> ((ExecutionInput.Builder)executionBuilder).variables(arg_0));
                context.getOperationName().ifPresent(arg_0 -> ((ExecutionInput.Builder)executionBuilder).operationName(arg_0));
                executionBuilder.context((Object)this.toGraphQLContext(context));
                if (this.batchOperations != null && !this.batchOperations.isEmpty()) {
                    DataLoaderRegistry dataLoaderRegistry = this.getDataLoaderRegistry(this.batchOperations);
                    executionBuilder.dataLoaderRegistry(dataLoaderRegistry);
                }
                ExecutionInput executionInput = executionBuilder.build();
                context = context.withDataFromExecution(executionInput);
                ((GraphQLContext)executionInput.getContext()).put((Object)"context", (Object)context);
                this.eventEmitter.fireBeforeExecute(context);
                ExecutionResult executionResult = g.execute(executionInput);
                this.eventEmitter.fireAfterExecute(context);
                JsonObjectBuilder returnObjectBuilder = jsonObjectFactory.createObjectBuilder();
                returnObjectBuilder = this.addErrorsToResponse(returnObjectBuilder, executionResult);
                returnObjectBuilder = this.addDataToResponse(returnObjectBuilder, executionResult);
                JsonObject jsonResponse = returnObjectBuilder.build();
                if (this.config.logPayload()) {
                    SmallRyeGraphQLServerLogging.log.payloadOut(jsonResponse.toString());
                }
                return jsonResponse;
            }
            SmallRyeGraphQLServerLogging.log.noGraphQLMethodsFound();
            return null;
        }
        catch (Throwable t) {
            this.eventEmitter.fireOnExecuteError(finalExecutionId.toString(), t);
            throw t;
        }
    }

    private <K, T> DataLoaderRegistry getDataLoaderRegistry(List<Operation> operations) {
        DataLoaderRegistry dataLoaderRegistry = new DataLoaderRegistry();
        for (Operation operation : operations) {
            BatchLoaderWithContext batchLoader = this.dataFetcherFactory.getSourceBatchLoader(operation);
            SmallRyeBatchLoaderContextProvider ctxProvider = new SmallRyeBatchLoaderContextProvider();
            DataLoaderOptions options = DataLoaderOptions.newOptions().setBatchLoaderContextProvider((BatchLoaderContextProvider)ctxProvider);
            DataLoader dataLoader = DataLoader.newDataLoader(batchLoader, (DataLoaderOptions)options);
            ctxProvider.setDataLoader(dataLoader);
            dataLoaderRegistry.register(this.batchLoaderHelper.getName(operation), dataLoader);
        }
        return dataLoaderRegistry;
    }

    private GraphQLContext toGraphQLContext(Context context) {
        GraphQLContext.Builder builder = GraphQLContext.newContext();
        builder = builder.of((Object)"context", (Object)context);
        return builder.build();
    }

    private JsonObjectBuilder addDataToResponse(JsonObjectBuilder returnObjectBuilder, ExecutionResult executionResult) {
        Object pojoData = executionResult.getData();
        return this.addDataToResponse(returnObjectBuilder, pojoData);
    }

    private JsonObjectBuilder addDataToResponse(JsonObjectBuilder returnObjectBuilder, Object pojoData) {
        if (pojoData != null) {
            JsonValue data = this.toJsonValue(pojoData);
            return returnObjectBuilder.add(DATA, data);
        }
        return returnObjectBuilder.addNull(DATA);
    }

    private JsonObjectBuilder addErrorsToResponse(JsonObjectBuilder returnObjectBuilder, ExecutionResult executionResult) {
        List errors = executionResult.getErrors();
        if (errors != null) {
            JsonArray jsonArray = this.errorsService.toJsonErrors(errors);
            if (!jsonArray.isEmpty()) {
                returnObjectBuilder = returnObjectBuilder.add(ERRORS, (JsonValue)jsonArray);
            }
            return returnObjectBuilder;
        }
        return returnObjectBuilder;
    }

    private JsonValue toJsonValue(Object pojo) {
        JsonValue jsonValue;
        StringReader sr;
        block10: {
            String json = jsonB.toJson(pojo);
            sr = new StringReader(json);
            JsonReader reader = jsonReaderFactory.createReader((Reader)sr);
            try {
                jsonValue = reader.readValue();
                if (reader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    FFDCFilter.processException((Throwable)throwable, (String)"io.smallrye.graphql.execution.ExecutionService", (String)"214", (Object)this, (Object[])new Object[]{pojo});
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            FFDCFilter.processException((Throwable)throwable2, (String)"io.smallrye.graphql.execution.ExecutionService", (String)"214", (Object)this, (Object[])new Object[]{pojo});
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    FFDCFilter.processException((Throwable)throwable3, (String)"io.smallrye.graphql.execution.ExecutionService", (String)"214", (Object)this, (Object[])new Object[]{pojo});
                    try {
                        sr.close();
                    }
                    catch (Throwable throwable4) {
                        FFDCFilter.processException((Throwable)throwable4, (String)"io.smallrye.graphql.execution.ExecutionService", (String)"214", (Object)this, (Object[])new Object[]{pojo});
                        throwable3.addSuppressed(throwable4);
                    }
                    throw throwable3;
                }
            }
            reader.close();
        }
        sr.close();
        return jsonValue;
    }

    private GraphQL getGraphQL() {
        if (this.graphQL == null) {
            ExceptionHandler exceptionHandler = new ExceptionHandler(this.config);
            if (this.graphQLSchema != null) {
                QueryCache queryCache = new QueryCache();
                GraphQL.Builder graphqlBuilder = GraphQL.newGraphQL((GraphQLSchema)this.graphQLSchema);
                graphqlBuilder = graphqlBuilder.defaultDataFetcherExceptionHandler((DataFetcherExceptionHandler)exceptionHandler);
                graphqlBuilder = graphqlBuilder.instrumentation((Instrumentation)queryCache);
                graphqlBuilder = graphqlBuilder.preparsedDocumentProvider((PreparsedDocumentProvider)queryCache);
                graphqlBuilder = this.eventEmitter.fireBeforeGraphQLBuild(graphqlBuilder);
                this.graphQL = graphqlBuilder.build();
            } else {
                SmallRyeGraphQLServerLogging.log.noGraphQLMethodsFound();
            }
        }
        return this.graphQL;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.smallrye.graphql.execution.ExecutionService", ExecutionService.class, null, null);
        jsonObjectFactory = Json.createBuilderFactory(null);
        jsonReaderFactory = Json.createReaderFactory(null);
        jsonB = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withNullValues(Boolean.TRUE).withFormatting(Boolean.TRUE));
    }
}

