/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.event;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.audit.AuditEvent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.audit.source.utils.AuditUtils;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JMSAuthenticationEvent
extends AuditEvent {
    private static final TraceComponent tc = Tr.register(JMSAuthenticationEvent.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
    static final long serialVersionUID = 1108597277091648125L;

    public JMSAuthenticationEvent() {
        this.set("eventName", "SECURITY_JMS_AUTHN");
        this.setInitiator((Map)AuditEvent.STD_INITIATOR.clone());
        this.setObserver((Map)AuditEvent.STD_OBSERVER.clone());
        this.setTarget((Map)AuditEvent.STD_TARGET.clone());
    }

    /*
     * WARNING - void declaration
     */
    public JMSAuthenticationEvent(String userName, String hostAddress, String port, String chainName, String busName, String messagingEngine, String credentialType, Integer statusCode) {
        block12: {
            this();
            try {
                if (busName != null) {
                    this.set("target.messaging.busname", busName);
                }
                if (messagingEngine != null) {
                    this.set("target.messaging.engine", messagingEngine);
                }
                this.set("observer.name", "JMSMessagingImplementation");
                if (userName != null) {
                    this.set("target.credential.token", userName);
                    this.set("target.credential.type", "BASIC");
                }
                if (credentialType != null) {
                    this.set("target.messaging.loginType", credentialType);
                }
                if (hostAddress != null) {
                    this.set("target.messaging.callType", "remote");
                    this.set("target.host.address", hostAddress);
                    if (port != null) {
                        this.set("target.host.address", hostAddress + ":" + port);
                    }
                } else {
                    this.set("target.messaging.callType", "local");
                    this.set("target.host.address", "127.0.0.1:8010");
                }
                this.set("target.realm", AuditUtils.getRealmName());
                if (chainName != null) {
                    this.set("target.messaging.remote.chainName", chainName);
                }
                if (statusCode == 200) {
                    this.setOutcome("success");
                    this.set("reason.reasonCode", statusCode);
                    this.set("reason.reasonType", "JMS");
                } else {
                    this.setOutcome("failure");
                    this.set("reason.reasonCode", statusCode);
                    this.set("reason.reasonType", "JMS");
                }
                this.set("target.typeURI", "service/jms/messagingEngine");
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.audit.event.JMSAuthenticationEvent", (String)"87", (Object)((Object)this), (Object[])new Object[]{userName, hostAddress, port, chainName, busName, messagingEngine, credentialType, statusCode});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block12;
                Tr.debug((TraceComponent)tc, (String)"Internal error creating JMSAuthenticationEvent", (Object[])new Object[]{e});
            }
        }
    }
}

