/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.security.impl;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.KeyException;
import java.time.Duration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Timer;
import java.util.TimerTask;
import javax.crypto.SecretKey;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonNegative;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.TimerSupport;
import net.shibboleth.utilities.java.support.scripting.EvaluableScript;
import net.shibboleth.utilities.java.support.security.DataSealerKeyStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptedKeyStrategy
extends AbstractInitializableComponent
implements DataSealerKeyStrategy {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ScriptedKeyStrategy.class);
    @NonnullAfterInit
    private EvaluableScript keyScript;
    @Nullable
    private Object customObject;
    @NonnullAfterInit
    private String currentAlias;
    @NonnullAfterInit
    private SecretKey defaultKey;
    @Nonnull
    private final LinkedHashMap<String, SecretKey> keyCache = new LinkedHashMap((int)this.cacheSize);
    @Nonnull
    private Duration updateInterval = Duration.ofMinutes(15L);
    @Nullable
    private Timer updateTaskTimer;
    @Nullable
    private Timer internalTaskTimer;
    @Nullable
    private TimerTask updateTask;
    @NonNegative
    private long cacheSize = 30L;

    public void setKeyScript(@Nonnull EvaluableScript script) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        this.keyScript = Constraint.isNotNull(script, "Script cannot be null");
    }

    public void setCustomObject(@Nullable Object object) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        this.customObject = object;
    }

    public void setUpdateInterval(@Nonnull Duration interval) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        Constraint.isNotNull(interval, "Interval cannot be null");
        Constraint.isFalse(interval.isNegative(), "Interval cannot be negative");
        this.updateInterval = interval;
    }

    public void setUpdateTaskTimer(@Nullable Timer timer) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        this.updateTaskTimer = timer;
    }

    public void setCacheSize(@NonNegative long size) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        this.cacheSize = Constraint.isGreaterThanOrEqual(0L, size, "Key cache size cannot be negative");
    }

    @Override
    public void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.keyScript == null) {
            throw new ComponentInitializationException("Script cannot be null");
        }
        try {
            this.updateDefaultKey();
        }
        catch (KeyException e) {
            this.log.error("Error loading default key: {}", (Object)e.getMessage());
            throw new ComponentInitializationException("Exception loading the default key", e);
        }
        if (!this.updateInterval.isZero()) {
            this.updateTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        ScriptedKeyStrategy.this.updateDefaultKey();
                    }
                    catch (KeyException keyException) {
                        // empty catch block
                    }
                }
            };
            this.internalTaskTimer = this.updateTaskTimer == null ? new Timer(TimerSupport.getTimerName(this), true) : this.updateTaskTimer;
            this.internalTaskTimer.schedule(this.updateTask, this.updateInterval.toMillis(), this.updateInterval.toMillis());
        }
    }

    @Override
    protected void doDestroy() {
        if (this.updateTask != null) {
            this.updateTask.cancel();
            this.updateTask = null;
            if (this.updateTaskTimer == null) {
                this.internalTaskTimer.cancel();
            }
            this.internalTaskTimer = null;
        }
        super.doDestroy();
    }

    @Override
    @Nonnull
    public Pair<String, SecretKey> getDefaultKey() throws KeyException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException(this);
        ScriptedKeyStrategy scriptedKeyStrategy = this;
        synchronized (scriptedKeyStrategy) {
            if (this.defaultKey != null) {
                return new Pair<String, SecretKey>(this.currentAlias, this.defaultKey);
            }
            throw new KeyException("Default key unavailable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public SecretKey getKey(@Nonnull @NotEmpty String name) throws KeyException {
        ScriptedKeyStrategy scriptedKeyStrategy = this;
        synchronized (scriptedKeyStrategy) {
            if (this.defaultKey != null && name.equals(this.currentAlias)) {
                return this.defaultKey;
            }
            if (this.keyCache.containsKey(name)) {
                return this.keyCache.get(name);
            }
        }
        try {
            SimpleScriptContext scriptContext = new SimpleScriptContext();
            scriptContext.setAttribute("custom", this.customObject, 100);
            scriptContext.setAttribute("name", name, 100);
            Object result = this.keyScript.eval(scriptContext);
            if (result instanceof SecretKey) {
                ScriptedKeyStrategy scriptedKeyStrategy2 = this;
                synchronized (scriptedKeyStrategy2) {
                    this.keyCache.put(name, (SecretKey)result);
                }
                this.log.debug("Loaded key '{}' from external script", (Object)name);
                return (SecretKey)result;
            }
            if (result instanceof Pair && ((Pair)result).getSecond() instanceof SecretKey) {
                ScriptedKeyStrategy scriptedKeyStrategy3 = this;
                synchronized (scriptedKeyStrategy3) {
                    this.keyCache.put(name, (SecretKey)((Pair)result).getSecond());
                }
                this.log.debug("Loaded key '{}' from external script", (Object)name);
                return (SecretKey)((Pair)result).getSecond();
            }
            throw new KeyException("Script did not return SecretKey or Pair<String,SecretKey> result.");
        }
        catch (ScriptException e) {
            throw new KeyException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDefaultKey() throws KeyException {
        block16: {
            ScriptedKeyStrategy scriptedKeyStrategy = this;
            synchronized (scriptedKeyStrategy) {
                int size = this.keyCache.size();
                if ((long)size > this.cacheSize) {
                    Iterator<String> iter = this.keyCache.keySet().iterator();
                    while ((long)size > this.cacheSize) {
                        iter.next();
                        iter.remove();
                        --size;
                    }
                }
            }
            try {
                SimpleScriptContext scriptContext = new SimpleScriptContext();
                scriptContext.setAttribute("custom", this.customObject, 100);
                Object result = this.keyScript.eval(scriptContext);
                if (result instanceof Pair) {
                    Pair p = (Pair)result;
                    if (p.getFirst() instanceof String && p.getSecond() instanceof SecretKey) {
                        ScriptedKeyStrategy scriptedKeyStrategy2 = this;
                        synchronized (scriptedKeyStrategy2) {
                            if (this.currentAlias == null) {
                                this.log.info("Loaded initial default key: {}", p.getFirst());
                            } else if (!this.currentAlias.equals(p.getFirst())) {
                                this.log.info("Updated default key from {} to {}", (Object)this.currentAlias, p.getFirst());
                            } else {
                                this.log.debug("Default key version has not changed, still {}", (Object)this.currentAlias);
                                return;
                            }
                            this.currentAlias = (String)p.getFirst();
                            this.defaultKey = (SecretKey)p.getSecond();
                            this.keyCache.put((String)p.getFirst(), (SecretKey)p.getSecond());
                            break block16;
                        }
                    }
                    throw new KeyException("Script did not return Pair<String,SecretKey> result.");
                }
                throw new KeyException("Script did not return Pair<String,SecretKey> result.");
            }
            catch (ScriptException e) {
                throw new KeyException(e);
            }
        }
    }
}

