/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transport.netty;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sip.stack.transport.netty.SipHandlerUtils;
import com.ibm.ws.sip.stack.transport.netty.SipMessageEvent;
import com.ibm.ws.sip.stack.transport.sip.netty.SIPConnectionFactoryImplWs;
import com.ibm.ws.sip.stack.transport.sip.netty.SipUdpConnLink;
import com.ibm.ws.sip.stack.transport.sip.netty.SipUdpInboundChannel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import jain.protocol.ip.sip.ListeningPoint;

public class SipDatagramHandler
extends SimpleChannelInboundHandler<SipMessageEvent> {
    private static final TraceComponent tc = Tr.register(SipDatagramHandler.class);
    private final AttributeKey<SipUdpConnLink> attrKey = AttributeKey.valueOf((String)"SipUdpConnLink");

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("channelActive. " + ctx.channel()), (Object[])new Object[0]);
        }
        SipUdpInboundChannel inboundChannel = null;
        ListeningPoint lp = SipHandlerUtils.getListeningPoint(ctx.channel().localAddress(), "udp");
        if (lp != null) {
            inboundChannel = (SipUdpInboundChannel)SIPConnectionFactoryImplWs.instance().getInboundChannels().get(lp);
        }
        if (inboundChannel != null) {
            inboundChannel.setChannel(ctx.channel());
            Attribute attr = ctx.channel().attr(this.attrKey);
            attr.setIfAbsent((Object)((SipUdpConnLink)inboundChannel.getConnectionLink()));
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"channelActive", (Object[])new Object[]{"could not associate an incoming connection with a SIP channel"});
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Attribute attr;
        SipUdpConnLink connLink;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"channelInactive", (Object[])new Object[]{ctx.channel().remoteAddress() + " has been disconnected"});
        }
        if ((connLink = (SipUdpConnLink)(attr = ctx.channel().attr(this.attrKey)).get()) != null) {
            connLink.close();
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"channelInactive", (Object[])new Object[]{ctx.name() + "could not find a SIP channel"});
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, SipMessageEvent msg) throws Exception {
        Attribute attr;
        SipUdpConnLink connLink;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("channelRead0. " + ctx.channel() + ". [" + msg.getSipMsg().getMarkedBytesNumber() + "] bytes received"), (Object[])new Object[0]);
        }
        if ((connLink = (SipUdpConnLink)(attr = ctx.channel().attr(this.attrKey)).get()) != null) {
            connLink.complete(msg.getSipMsg(), msg.getRemoteAddress());
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"channelRead0", (Object[])new Object[]{"could not find a SIP channel"});
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("exceptionCaught. " + cause.getClass()), (Object[])new Object[0]);
        }
        Attribute attr = ctx.channel().attr(this.attrKey);
        if (cause instanceof Exception) {
            SipUdpConnLink connLink = (SipUdpConnLink)attr.get();
            if (connLink != null) {
                connLink.close(cause);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"exceptionCaught", (Object[])new Object[]{"could not find a SIP channel"});
            }
        }
        ctx.close();
    }
}

