/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.servlets;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.sip.util.seqlog.SequenceLogger;
import com.ibm.ws.sip.container.properties.PropertiesStore;
import com.ibm.ws.sip.parser.util.ObjectPool;

public class SipSessionSeqLog
extends SequenceLogger {
    private static final LogMgr c_logger = Log.get(SipSessionSeqLog.class);
    public static final int INIT = 257;
    public static final int SIPLET_DESC = 258;
    public static final int PROCESS_REQ = 259;
    public static final int PROCESS_RESP = 260;
    public static final int SENDING_RES = 261;
    public static final int SENDING_REQ = 262;
    public static final int IS_PROXY = 263;
    public static final int IS_UAS = 264;
    public static final int PROXY_BRANCH_CREATED = 265;
    public static final int PROXY_BRANCH_RESP = 266;
    public static final int PROXY_SUBSEQUENT_REQ = 267;
    public static final int PROXY_SUBSEQUENT_RESP = 268;
    public static final int PROXY_IS_RR = 269;
    public static final int PROXY_IS_PARALELL = 270;
    public static final int PROXY_IS_RECURSE = 271;
    public static final int PROXY_UPDATE_BEST_RESP = 272;
    public static final int PROCESS_TIMEOUT = 65537;
    public static final int PROXY_TRANSACTION_TIMED_OUT = 65538;
    public static final int INVALIDATED = 4097;
    public static final int EXPIRED = 4098;
    public static final int REUSED = 4099;
    public static final int ERROR_SESSION_TERMINATED = 0x100001;
    public static final int ERROR_TRANSACTION_TERMINATED = 0x100002;
    public static final int ERROR_DISPATCH_EXCEPTION = 0x100003;
    public static final int ERROR_SEND_REQ = 0x100004;
    public static final int ERROR_SEND_RESP = 0x100005;
    private static ObjectPool c_pool = new ObjectPool(SipSessionSeqLog.class, null, -1);
    private static boolean c_isEnabled;

    @Override
    public void dumpStateDesc(int state, StringBuffer buf) {
        switch (state) {
            case 257: {
                buf.append("Init");
                break;
            }
            case 258: {
                buf.append("Siplet Description");
                break;
            }
            case 259: {
                buf.append("Received Request");
                break;
            }
            case 260: {
                buf.append("Received Response");
                break;
            }
            case 262: {
                buf.append("Sending Request");
                break;
            }
            case 261: {
                buf.append("Sending Response");
                break;
            }
            case 65537: {
                buf.append("Process Timeout");
                break;
            }
            case 4097: {
                buf.append("Invalidated");
                break;
            }
            case 264: {
                buf.append("Is UAS");
                break;
            }
            case 263: {
                buf.append("Is Proxy");
                break;
            }
            case 0x100001: {
                buf.append("Session has terminated");
                break;
            }
            case 0x100002: {
                buf.append("Transaction has terminated");
                break;
            }
            case 0x100003: {
                buf.append("Exception in dispatch to siplet");
                break;
            }
            case 265: {
                buf.append("Proxy branch created");
                break;
            }
            case 266: {
                buf.append("Proxy branch response");
                break;
            }
            case 267: {
                buf.append("Proxying subsequent request");
                break;
            }
            case 268: {
                buf.append("Proxy received response");
                break;
            }
            case 272: {
                buf.append("Proxy best response");
                break;
            }
            case 271: {
                buf.append("Proxy is recurse");
                break;
            }
            case 270: {
                buf.append("Proxy is parallel");
                break;
            }
            case 269: {
                buf.append("Proxy is record-route");
                break;
            }
            case 0x100004: {
                buf.append("Error sending request");
                break;
            }
            case 0x100005: {
                buf.append("Error sending response");
                break;
            }
            case 65538: {
                buf.append("Failed to send response upstream");
                break;
            }
            default: {
                super.dumpStateDesc(state, buf);
            }
        }
    }

    public static SipSessionSeqLog getInstance() {
        if (!SipSessionSeqLog.isEnabled()) {
            return null;
        }
        return (SipSessionSeqLog)c_pool.get();
    }

    public void returnToPool() {
        this.clear();
        c_pool.putBack(this);
    }

    public static void setThreshold(int threshold) {
        c_logThreshold = threshold;
    }

    protected static String getDesc() {
        return "SIP Session Log";
    }

    public static boolean isEnabled() {
        return c_isEnabled;
    }

    static {
        PropertiesStore store = PropertiesStore.getInstance();
        String value = store.getProperties().getString("sessionSeqLogLevel");
        if (value != null) {
            if ((value = value.trim().toLowerCase()).equals("warning")) {
                SipSessionSeqLog.setThreshold(65536);
                c_isEnabled = true;
            } else if (value.equals("error")) {
                SipSessionSeqLog.setThreshold(0x100000);
                c_isEnabled = true;
            } else if (value.equals("all")) {
                SipSessionSeqLog.setThreshold(4096);
                c_isEnabled = true;
            }
            if (c_isEnabled && c_logger.isInfoEnabled()) {
                Object[] args = new Object[]{value};
                c_logger.info("info.sequence.logger.enabled", (Object)"Config", args);
            }
        }
    }
}

