/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.pmi;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.parser.SipAppDesc;
import com.ibm.ws.sip.container.pmi.ApplicationModuleInterface;
import com.ibm.ws.sip.container.pmi.PerformanceMgr;
import java.util.HashMap;

public class LoadedApplicationsContainer {
    private static final LogMgr c_logger = Log.get(LoadedApplicationsContainer.class);
    private HashMap _appTable = new HashMap(10);
    private static LoadedApplicationsContainer s_singelton;
    private static int c_lastPMIIndex;

    public static LoadedApplicationsContainer getInstance() {
        if (s_singelton == null) {
            s_singelton = new LoadedApplicationsContainer();
        }
        return s_singelton;
    }

    public ApplicationModuleInterface getAppObj(Integer appIndex) {
        if (appIndex == null) {
            return null;
        }
        try {
            return (ApplicationModuleInterface)this._appTable.get(appIndex);
        }
        catch (IndexOutOfBoundsException e2) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getAppObj", "appIndex is out of range. Index = " + appIndex);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appLoaded(String applicationName, SipAppDesc desc) {
        ApplicationModuleInterface application = this.getAppObj(desc.getAppIndexForPmi());
        if (application == null) {
            application = PerformanceMgr.getInstance().getApplicationsPMIListener().getApplicationModule(applicationName);
            HashMap hashMap = this._appTable;
            synchronized (hashMap) {
                Integer index = new Integer(c_lastPMIIndex++);
                this._appTable.put(index, application);
                desc.setAppIndexForPmi(index);
                if (c_logger.isTraceDebugEnabled()) {
                    StringBuffer buff = new StringBuffer(100);
                    buff.append("Application loaded name < ");
                    buff.append(applicationName);
                    buff.append("> index < ");
                    buff.append(index);
                    buff.append(">");
                    c_logger.traceDebug(this, "appLoaded", buff.toString());
                }
            }
        } else if (c_logger.isWarnEnabled()) {
            Object[] args = new Object[]{applicationName};
            c_logger.error("warn.server.application.exist", "Report", args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appUnloaded(String applicationName, Integer appIndex) {
        StringBuffer buff;
        ApplicationModuleInterface application = null;
        HashMap hashMap = this._appTable;
        synchronized (hashMap) {
            application = (ApplicationModuleInterface)this._appTable.remove(appIndex);
            if (this._appTable.isEmpty()) {
                PerformanceMgr.setIsApplicationDurationPMIEnabled(false);
            }
        }
        if (application == null) {
            buff = new StringBuffer(100);
            buff.append("Failed to find application name < ");
            buff.append(applicationName);
            buff.append("> index < ");
            buff.append(appIndex);
            buff.append(">");
            c_logger.traceDebug(this, "appUnloaded", buff.toString());
        } else {
            application.destroy();
            if (c_logger.isTraceDebugEnabled()) {
                buff = new StringBuffer(100);
                buff.append("Application UnLoaded name < ");
                buff.append(applicationName);
                buff.append("> index < ");
                buff.append(appIndex);
                buff.append(">");
                c_logger.traceDebug(this, "appUnloaded", buff.toString());
            }
        }
    }

    public void sipAppSessionCreated(String applicationName, Integer applicationIndex) {
        ApplicationModuleInterface appObjModule = this.getAppObj(applicationIndex);
        if (appObjModule != null) {
            appObjModule.getSessionModule().incrementSipAppSessionCount();
        } else if (c_logger.isTraceDebugEnabled()) {
            StringBuffer buff = new StringBuffer(100);
            buff.append("Application not found by name < ");
            buff.append(applicationName);
            buff.append("> index < ");
            buff.append(applicationIndex);
            buff.append(">");
            c_logger.traceDebug(this, "sipAppSessionCreated", buff.toString());
        }
    }

    public void sipAppSessionDestroyed(String applicationName, Integer appIndex) {
        ApplicationModuleInterface appObjModule = this.getAppObj(appIndex);
        if (appObjModule != null) {
            appObjModule.getSessionModule().decrementSipAppSessionCount();
        } else if (c_logger.isTraceDebugEnabled()) {
            StringBuffer buff = new StringBuffer(100);
            buff.append("Application not found by name < ");
            buff.append(applicationName);
            buff.append("> index < ");
            buff.append(appIndex);
            buff.append(">");
            c_logger.traceDebug(this, "sipAppSessionDestroyed", buff.toString());
        }
    }

    public void sipSessionCreated(String applicationName, Integer appIndex) {
        ApplicationModuleInterface appObjModule = this.getAppObj(appIndex);
        if (appObjModule != null) {
            appObjModule.getSessionModule().incrementSipSessionCount();
        } else if (c_logger.isTraceDebugEnabled()) {
            StringBuffer buff = new StringBuffer(100);
            buff.append("Application not found by name < ");
            buff.append(applicationName);
            buff.append("> index < ");
            buff.append(appIndex);
            buff.append(">");
            c_logger.traceDebug(this, "sipSessionCreated", buff.toString());
        }
    }

    public void sipSessionDestroyed(String applicationName, Integer appIndex) {
        ApplicationModuleInterface appObjModule = this.getAppObj(appIndex);
        if (appObjModule != null) {
            appObjModule.getSessionModule().decrementSipSessionCount();
        } else if (c_logger.isTraceDebugEnabled()) {
            StringBuffer buff = new StringBuffer(100);
            buff.append("Application not found by name < ");
            buff.append(applicationName);
            buff.append("> index < ");
            buff.append(appIndex);
            buff.append(">");
            c_logger.traceDebug(this, "sipSessionDestroyed", buff.toString());
        }
    }

    public void inRequest(String applicationName, Integer appIndex, String method) {
        ApplicationModuleInterface appObjModule = this.getAppObj(appIndex);
        if (appObjModule != null) {
            appObjModule.getRequestModule().incrementInRequest(method);
        } else if (c_logger.isTraceDebugEnabled()) {
            StringBuffer buff = new StringBuffer(100);
            buff.append("Application not found by name < ");
            buff.append(applicationName);
            buff.append("> index < ");
            buff.append(appIndex);
            buff.append(">");
            c_logger.traceDebug(this, "inRequest", buff.toString());
        }
    }

    public void outRequest(String applicationName, Integer appIndex, String method) {
        ApplicationModuleInterface appObjModule = this.getAppObj(appIndex);
        if (appObjModule != null) {
            appObjModule.getRequestModule().incrementOutRequest(method);
        } else if (c_logger.isTraceDebugEnabled()) {
            StringBuffer buff = new StringBuffer(100);
            buff.append("Application not found by name < ");
            buff.append(applicationName);
            buff.append("> index < ");
            buff.append(appIndex);
            buff.append(">");
            c_logger.traceDebug(this, "outRequest", buff.toString());
        }
    }

    public void inResponse(String applicationName, Integer appIndex, int code) {
        ApplicationModuleInterface appObjModule = this.getAppObj(appIndex);
        if (appObjModule != null) {
            appObjModule.getResponseModule().incrementInResponse(code);
        } else if (c_logger.isTraceDebugEnabled()) {
            StringBuffer buff = new StringBuffer(100);
            buff.append("Application not found by name < ");
            buff.append(applicationName);
            buff.append("> index < ");
            buff.append(appIndex);
            buff.append(">");
            c_logger.traceDebug(this, "inResponse", buff.toString());
        }
    }

    public void outResponse(String applicationName, Integer appIndex, int code) {
        ApplicationModuleInterface appObjModule = this.getAppObj(appIndex);
        if (appObjModule != null) {
            appObjModule.getResponseModule().incrementOutResponse(code);
        } else if (c_logger.isTraceDebugEnabled()) {
            StringBuffer buff = new StringBuffer(100);
            buff.append("Application not found by name < ");
            buff.append(applicationName);
            buff.append("> index < ");
            buff.append(appIndex);
            buff.append(">");
            c_logger.traceDebug(this, "outResponse", buff.toString());
        }
    }

    public void updateApplicationTaskDurationStatistics(String applicationName, Integer appIndex, long ms) {
        ApplicationModuleInterface appObjModule = this.getAppObj(appIndex);
        if (appObjModule != null && appObjModule.getApplicationTaskDurationModule() != null) {
            appObjModule.getApplicationTaskDurationModule().updateTaskDurationInApplication(ms);
        } else if (c_logger.isTraceDebugEnabled()) {
            StringBuffer buff = new StringBuffer(100);
            buff.append("Application not found by name or ApplicationTaskDurationModule disabled< ");
            buff.append(applicationName);
            buff.append("> index < ");
            buff.append(appIndex);
            buff.append(">");
            c_logger.traceDebug(this, "task Duration", buff.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updatePmi() {
        ApplicationModuleInterface obj2 = null;
        HashMap hashMap = this._appTable;
        synchronized (hashMap) {
            for (ApplicationModuleInterface obj2 : this._appTable.values()) {
                if (obj2 == null) continue;
                obj2.updateCounters();
            }
        }
    }

    static {
        c_lastPMIIndex = 0;
    }
}

