/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.cxf.validator;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.registry.UserRegistry;
import com.ibm.ws.security.registry.UserRegistryService;
import com.ibm.ws.wssecurity.cxf.validator.Utils;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.UsernameTokenUtil;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.token.UsernameToken;
import org.apache.wss4j.dom.validate.Credential;
import org.apache.wss4j.dom.validate.Validator;
import org.apache.xml.security.utils.XMLUtils;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class UsernameTokenValidator
implements Validator {
    protected static final TraceComponent tc = Tr.register(UsernameTokenValidator.class, (String)"WSSecurity", (String)"com.ibm.ws.wssecurity.resources.WSSecurityMessages");
    private static SecurityService securityService = null;
    static final long serialVersionUID = -9022239441165067382L;

    public static void setSecurityService(SecurityService serv) {
        securityService = serv;
    }

    public static SecurityService getSecurityService() {
        return securityService;
    }

    public Credential validate(Credential credential, RequestData data) throws WSSecurityException {
        if (credential == null || credential.getUsernametoken() == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "noCredential");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("RequestData ClassName:" + data.getClass().getName()), (Object[])new Object[0]);
            Object msg = data.getMsgContext();
            if (msg != null) {
                Tr.debug((TraceComponent)tc, (String)("MsgContext ClassName:" + msg.getClass().getName()), (Object[])new Object[0]);
            } else {
                Tr.debug((TraceComponent)tc, (String)"MsgContext**** ClassName**** is null", (Object[])new Object[0]);
            }
        }
        boolean handleCustomPasswordTypes = false;
        boolean passwordsAreEncoded = false;
        String requiredPasswordType = null;
        WSSConfig wssConfig = null;
        if (data != null) {
            wssConfig = data.getWssConfig();
            handleCustomPasswordTypes = data.isHandleCustomPasswordTypes();
            passwordsAreEncoded = data.isEncodePasswords();
            requiredPasswordType = data.getRequiredPasswordType();
        }
        UsernameToken usernameToken = credential.getUsernametoken();
        this.validateCreated(usernameToken, data);
        usernameToken.setPasswordsAreEncoded(passwordsAreEncoded);
        String pwType = usernameToken.getPasswordType();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("UsernameToken user " + usernameToken.getName()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("UsernameToken password type " + pwType), (Object[])new Object[0]);
        }
        if (requiredPasswordType != null && !requiredPasswordType.equals(pwType)) {
            Tr.error((TraceComponent)tc, (String)"password_type_mismatch", (Object[])new Object[]{pwType, requiredPasswordType});
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
        }
        String password = usernameToken.getPassword();
        if (usernameToken.isHashed()) {
            this.verifyDigestPassword(usernameToken, data);
        } else if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText".equals(pwType) || password != null && (pwType == null || "".equals(pwType.trim()))) {
            this.verifyPlaintextPassword(usernameToken, data);
        } else if (password != null) {
            if (!handleCustomPasswordTypes) {
                Tr.error((TraceComponent)tc, (String)"cannot_handle_custom_password_types", (Object[])new Object[0]);
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
            }
            this.verifyCustomPassword(usernameToken, data);
        } else {
            this.verifyUnknownPassword(usernameToken, data);
        }
        return credential;
    }

    protected void verifyCustomPassword(@Sensitive UsernameToken usernameToken, RequestData data) throws WSSecurityException {
        this.verifyPlaintextCustomPassword(usernameToken, data);
    }

    protected void verifyPlaintextPassword(@Sensitive UsernameToken usernameToken, RequestData data) throws WSSecurityException {
        String user = null;
        String password = null;
        user = usernameToken.getName();
        String pwType = usernameToken.getPasswordType();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("UsernameToken user " + usernameToken.getName()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("UsernameToken password type " + pwType), (Object[])new Object[0]);
        }
        password = usernameToken.getPassword();
        if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText".equals(pwType)) {
            Tr.error((TraceComponent)tc, (String)"password_type_mismatch", (Object[])new Object[]{pwType, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText"});
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
        }
        if (user == null || user.length() <= 0 || password == null || password.length() <= 0) {
            Tr.error((TraceComponent)tc, (String)"empty_user_or_password", (Object[])new Object[0]);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
        }
        this.checkUserAndPassword(user, password);
    }

    protected void verifyPlaintextCustomPassword(@Sensitive UsernameToken usernameToken, RequestData data) throws WSSecurityException {
        String user = null;
        String password = null;
        user = usernameToken.getName();
        String pwType = usernameToken.getPasswordType();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("UsernameToken user " + usernameToken.getName()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("UsernameToken password type " + pwType), (Object[])new Object[0]);
        }
        password = usernameToken.getPassword();
        if (user == null || user.length() <= 0 || password == null || password.length() <= 0) {
            Tr.error((TraceComponent)tc, (String)"empty_user_or_password", (Object[])new Object[0]);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
        }
        this.checkUserAndPassword(user, password);
    }

    /*
     * WARNING - void declaration
     */
    protected String checkUserAndPassword(String user, @Sensitive String password) throws WSSecurityException {
        String authnPrincipal = null;
        try {
            UserRegistryService userRegistryService = securityService.getUserRegistryService();
            UserRegistry userRegistry = userRegistryService.getUserRegistry();
            authnPrincipal = userRegistry.checkPassword(user, password);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Authenticated principal for " + user + " is  " + authnPrincipal), (Object[])new Object[0]);
            }
        }
        catch (RegistryException userRegistryService) {
            void e;
            Object[] objectArray = new Object[2];
            objectArray[0] = user;
            objectArray[1] = "<sensitive java.lang.String>";
            FFDCFilter.processException((Throwable)userRegistryService, (String)"com.ibm.ws.wssecurity.cxf.validator.UsernameTokenValidator", (String)"235", (Object)this, (Object[])objectArray);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught exception getting the access id for " + user + ": " + e), (Object[])new Object[0]);
            }
            Tr.error((TraceComponent)tc, (String)"registry_exception_checking_password", (Object[])new Object[]{user, e.getLocalizedMessage()});
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION, (Exception)e);
        }
        if (authnPrincipal == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("User " + user + " could not be validated."), (Object[])new Object[0]);
            }
            Tr.error((TraceComponent)tc, (String)"check_password_failed", (Object[])new Object[]{user});
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("UsernameToken for " + user + " has been validated."), (Object[])new Object[0]);
        }
        return authnPrincipal;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean checkUser(String user) throws WSSecurityException {
        boolean isValid = false;
        try {
            UserRegistryService userRegistryService = securityService.getUserRegistryService();
            UserRegistry userRegistry = userRegistryService.getUserRegistry();
            isValid = userRegistry.isValidUser(user);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("User " + user + " is valid " + isValid), (Object[])new Object[0]);
            }
            if (!isValid) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
            }
        }
        catch (RegistryException userRegistryService) {
            void e;
            FFDCFilter.processException((Throwable)userRegistryService, (String)"com.ibm.ws.wssecurity.cxf.validator.UsernameTokenValidator", (String)"273", (Object)this, (Object[])new Object[]{user});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught exception getting the access id for " + user + ": " + e), (Object[])new Object[0]);
            }
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, (Exception)e);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected void verifyDigestPassword(@Sensitive UsernameToken usernameToken, RequestData data) throws WSSecurityException {
        if (data.getCallbackHandler() == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "noCallback");
        }
        String user = usernameToken.getName();
        String password = usernameToken.getPassword();
        String nonce = usernameToken.getNonce();
        String createdTime = usernameToken.getCreated();
        String pwType = usernameToken.getPasswordType();
        boolean passwordsAreEncoded = usernameToken.getPasswordsAreEncoded();
        WSPasswordCallback pwCb = new WSPasswordCallback(user, null, pwType, 2);
        try {
            data.getCallbackHandler().handle(new Callback[]{pwCb});
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[2];
            objectArray[0] = "<sensitive org.apache.wss4j.dom.message.token.UsernameToken>";
            objectArray[1] = data;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.wssecurity.cxf.validator.UsernameTokenValidator", (String)"305", (Object)this, (Object[])objectArray);
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)e.getMessage(), (Object[])new Object[0]);
            }
            WSSecurityException wSSecurityException = new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
        }
        catch (UnsupportedCallbackException e) {
            Object[] objectArray = new Object[2];
            objectArray[0] = "<sensitive org.apache.wss4j.dom.message.token.UsernameToken>";
            objectArray[1] = data;
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.wssecurity.cxf.validator.UsernameTokenValidator", (String)"311", (Object)this, (Object[])objectArray);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)e.getMessage(), (Object[])new Object[0]);
            }
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION, (Exception)e);
        }
        String origPassword = pwCb.getPassword();
        if (origPassword == null) {
            Tr.error((TraceComponent)tc, (String)"no_password_returned_by_callback", (Object[])new Object[0]);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
        }
        if (usernameToken.isHashed()) {
            byte[] decodedNonce = XMLUtils.decode((String)nonce);
            String passDigest = passwordsAreEncoded ? UsernameTokenUtil.doPasswordDigest((byte[])decodedNonce, (String)createdTime, (byte[])XMLUtils.decode((String)origPassword)) : UsernameTokenUtil.doPasswordDigest((byte[])decodedNonce, (String)createdTime, (String)origPassword);
            if (!passDigest.equals(password)) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
            }
        } else if (!origPassword.equals(password)) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
        }
        this.checkUserAndPassword(user, origPassword);
    }

    protected void verifyUnknownPassword(@Sensitive UsernameToken usernameToken, RequestData data) throws WSSecurityException {
        String pwType = usernameToken.getPasswordType();
        if (pwType == null) {
            boolean bPolicyNoPasswordSet = false;
            Object msgContext = data.getMsgContext();
            if (msgContext != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("MsgContext ClassName:" + msgContext.getClass().getName()), (Object[])new Object[0]);
                }
                if (msgContext instanceof SoapMessage) {
                    bPolicyNoPasswordSet = Utils.checkPolicyNoPassword((SoapMessage)msgContext);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Policy NoPassword is " + bPolicyNoPasswordSet), (Object[])new Object[0]);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"MsgContext**** is null", (Object[])new Object[0]);
            }
            if (bPolicyNoPasswordSet || usernameToken.isDerivedKey()) {
                String user = usernameToken.getName();
                if (!this.checkUser(user)) {
                    throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
                }
            } else {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
            }
        }
    }

    protected void validateCreated(@Sensitive UsernameToken usernameToken, RequestData data) throws WSSecurityException {
        boolean isValid;
        String created = usernameToken.getCreated();
        if (created == null || created.isEmpty()) {
            return;
        }
        if (data.getWssConfig() == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE);
        }
        WSSConfig wssConfig = data.getWssConfig();
        int utTTL = 300;
        int utFutureTTL = 300;
        if (wssConfig != null) {
            utTTL = data.getUtTTL();
            utFutureTTL = data.getUtFutureTTL();
        }
        if (!(isValid = this.verifyCreated(created, utTTL, utFutureTTL))) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.MESSAGE_EXPIRED);
        }
    }

    protected boolean verifyCreated(String created, int timeToLive, int futureTimeToLive) throws WSSecurityException {
        Date createdDate;
        Date validCreation = new Date();
        long currentTime = validCreation.getTime();
        if (futureTimeToLive > 0) {
            validCreation.setTime(currentTime + (long)futureTimeToLive * 1000L);
        }
        if ((createdDate = UsernameTokenValidator.convertDate(created)) != null && createdDate.after(validCreation)) {
            return false;
        }
        validCreation.setTime(currentTime -= (long)timeToLive * 1000L);
        return createdDate == null || !createdDate.before(validCreation);
    }

    /*
     * WARNING - void declaration
     */
    public static Date convertDate(String strTimeStamp) throws WSSecurityException {
        Date date;
        try {
            String datePattern = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
            if (strTimeStamp.length() <= 20) {
                datePattern = "yyyy-MM-dd'T'HH:mm:ss'Z'";
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat(datePattern, Locale.US);
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            date = dateFormat.parse(strTimeStamp);
        }
        catch (ParseException datePattern) {
            void pe;
            FFDCFilter.processException((Throwable)datePattern, (String)"com.ibm.ws.wssecurity.cxf.validator.UsernameTokenValidator", (String)"472", null, (Object[])new Object[]{strTimeStamp});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught exception while parse a timestamp as '" + strTimeStamp + "' : " + pe), (Object[])new Object[0]);
            }
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, (Exception)pe);
        }
        return date;
    }
}

