/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.grpc.internal.client.monitor;

import com.ibm.websphere.monitor.annotation.Monitor;
import com.ibm.websphere.monitor.annotation.ProbeAtEntry;
import com.ibm.websphere.monitor.annotation.ProbeAtReturn;
import com.ibm.websphere.monitor.annotation.ProbeSite;
import com.ibm.websphere.monitor.annotation.PublishedMetric;
import com.ibm.websphere.monitor.annotation.This;
import com.ibm.websphere.monitor.meters.MeterCollection;
import io.openliberty.grpc.internal.client.monitor.GrpcClientStats;
import io.openliberty.grpc.internal.client.monitor.GrpcClientStatsMonitor;
import io.openliberty.grpc.internal.client.monitor.GrpcMethod;

@Monitor(group={"GrpcClient"})
public class GrpcClientMonitor {
    private static final String METRIC_KEY_DELIMETER = "/";
    @PublishedMetric
    public MeterCollection<GrpcClientStats> grpcClientCountByName = new MeterCollection("GrpcClient", (Object)this);

    @ProbeAtEntry
    @ProbeSite(clazz="io.openliberty.grpc.internal.client.monitor.GrpcClientStatsMonitor", method="recordCallStarted")
    public void atRpcCallStart(@This Object clientStats) {
        GrpcClientStatsMonitor stats = (GrpcClientStatsMonitor)clientStats;
        this.getGrpcClientStats(stats.getMethod()).recordCallStarted();
    }

    @ProbeAtReturn
    @ProbeSite(clazz="io.openliberty.grpc.internal.client.monitor.GrpcClientStatsMonitor", method="recordClientHandled")
    public void atGrpcClientHandled(@This Object clientStats) {
        GrpcClientStatsMonitor stats = (GrpcClientStatsMonitor)clientStats;
        GrpcClientStats grpcClientStats = this.getGrpcClientStats(stats.getMethod());
        grpcClientStats.recordClientHandled();
        long elapsed = stats.getLatency();
        grpcClientStats.recordLatency(elapsed < 0L ? 0L : elapsed);
    }

    @ProbeAtReturn
    @ProbeSite(clazz="io.openliberty.grpc.internal.client.monitor.GrpcClientStatsMonitor", method="recordMsgReceived")
    public void atClientMsgReceived(@This Object clientStats) {
        GrpcClientStatsMonitor stats = (GrpcClientStatsMonitor)clientStats;
        this.getGrpcClientStats(stats.getMethod()).incrementReceivedMsgCountBy(1);
    }

    @ProbeAtReturn
    @ProbeSite(clazz="io.openliberty.grpc.internal.client.monitor.GrpcClientStatsMonitor", method="recordMsgSent")
    public void atGrpcClientMsgSent(@This Object clientStats) {
        GrpcClientStatsMonitor stats = (GrpcClientStatsMonitor)clientStats;
        this.getGrpcClientStats(stats.getMethod()).incrementSentMsgCountBy(1);
    }

    private synchronized GrpcClientStats getGrpcClientStats(GrpcMethod method) {
        String key = method.serviceName() + METRIC_KEY_DELIMETER + method.methodName();
        GrpcClientStats stats = (GrpcClientStats)this.grpcClientCountByName.get(key);
        if (stats == null) {
            stats = new GrpcClientStats(method);
            this.grpcClientCountByName.put(key, (Object)stats);
        }
        return stats;
    }
}

