/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.telemetry.internal.common.rest;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.opentelemetry.context.Scope;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TelemetryServletRequestListener
implements ServletRequestListener {
    private static final TraceComponent tc = Tr.register(TelemetryServletRequestListener.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
    static final long serialVersionUID = 3579189809207300096L;

    /*
     * WARNING - void declaration
     */
    public void requestDestroyed(ServletRequestEvent sre) {
        try {
            Scope scope = (Scope)sre.getServletRequest().getAttribute("otel.span.server.scope");
            if (scope != null) {
                scope.close();
                sre.getServletRequest().removeAttribute("otel.span.server.scope");
            }
            if ((scope = (Scope)sre.getServletRequest().getAttribute("otel.span.http.scope")) != null) {
                scope.close();
                sre.getServletRequest().removeAttribute("otel.span.http.scope");
            }
        }
        catch (Exception scope) {
            void e;
            FFDCFilter.processException((Throwable)scope, (String)"io.openliberty.microprofile.telemetry.internal.common.rest.TelemetryServletRequestListener", (String)"47", (Object)this, (Object[])new Object[]{sre});
            Tr.error((TraceComponent)tc, (String)Tr.formatMessage((TraceComponent)tc, (String)"CWMOT5002.telemetry.error", (Object[])new Object[]{e}), (Object[])new Object[0]);
            return;
        }
    }

    public void requestInitialized(ServletRequestEvent sre) {
    }
}

