/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.internal.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashMap;
import java.util.Map;
import org.opensaml.messaging.handler.MessageHandlerException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SignatureMethods {
    static final Map<String, Integer> validMethods;
    static final long serialVersionUID = 3797303527579230315L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private static SignatureMethodType getSignatureMethodType(String samlMessageMethod) {
        if (samlMessageMethod.contains("ecdsa")) {
            return SignatureMethodType.ECDSA;
        }
        if (samlMessageMethod.contains("rsa")) {
            return SignatureMethodType.RSA;
        }
        return SignatureMethodType.UNSUPPORTED;
    }

    public static boolean isInboundSignatureMethodWeakerThanConfigured(String inboundMessageMethod, String configuredMethod) throws MessageHandlerException {
        boolean isWeaker = false;
        SignatureMethodType inboundMessageMethodType = SignatureMethods.getSignatureMethodType(inboundMessageMethod);
        SignatureMethodType configuredMethodType = SignatureMethods.getSignatureMethodType(configuredMethod);
        if (inboundMessageMethodType == SignatureMethodType.UNSUPPORTED) {
            throw new MessageHandlerException("SAML assertion is signed with an unsupported signature method algorithm \"" + (Object)((Object)inboundMessageMethodType) + "\".");
        }
        if (inboundMessageMethodType.equals((Object)configuredMethodType)) {
            isWeaker = SignatureMethods.toInteger(inboundMessageMethod) < SignatureMethods.toInteger(configuredMethod);
        } else if (inboundMessageMethodType == SignatureMethodType.RSA && configuredMethodType == SignatureMethodType.ECDSA) {
            isWeaker = true;
        }
        return isWeaker;
    }

    public static int toInteger(String method) {
        Integer num = validMethods.get(method);
        if (num != null) {
            return num;
        }
        return 0;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.saml.sso20.internal.utils.SignatureMethods", SignatureMethods.class, null, null);
        validMethods = new HashMap<String, Integer>();
        validMethods.put("http://www.w3.org/2000/09/xmldsig#rsa-sha1", 1);
        validMethods.put("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256", 256);
        validMethods.put("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384", 384);
        validMethods.put("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512", 512);
        validMethods.put("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", 256);
        validMethods.put("http://www.w3.org/2001/04/xmldsig-more#rsa-sha384", 384);
        validMethods.put("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512", 512);
    }

    private static enum SignatureMethodType {
        RSA,
        ECDSA,
        UNSUPPORTED;

    }
}

