/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.acs;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.saml.SsoRequest;
import com.ibm.ws.security.saml.SsoSamlService;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.sso20.acs.AssertionValidator;
import com.ibm.ws.security.saml.sso20.acs.ResponseValidator;
import com.ibm.ws.security.saml.sso20.acs.StatusBuilderUtil;
import com.ibm.ws.security.saml.sso20.binding.BasicMessageContext;
import com.ibm.ws.security.saml.sso20.binding.BasicMessageContextBuilder;
import com.ibm.ws.security.saml.sso20.internal.utils.DumpData;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLProtocolContext;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WebSSOConsumer<InboundMessageType extends SAMLObject, OutboundMessageType extends SAMLObject, NameIdentifierType extends SAMLObject> {
    private static TraceComponent tc = Tr.register(WebSSOConsumer.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    static WebSSOConsumer<?, ?, ?> instance = new WebSSOConsumer();
    static final long serialVersionUID = -4501459823190113743L;

    public static WebSSOConsumer<?, ?, ?> getInstance() {
        return instance;
    }

    static void setInstance(WebSSOConsumer<?, ?, ?> instance) {
        WebSSOConsumer.instance = instance;
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={SamlException.class})
    public BasicMessageContext<InboundMessageType, OutboundMessageType> handleSAMLResponse(HttpServletRequest req, HttpServletResponse res, SsoSamlService ssoService, String externalRelayState, SsoRequest samlRequest) throws SamlException {
        BasicMessageContext<?, ?> messageContext = null;
        try {
            BasicMessageContextBuilder<?, ?, ?> ctxBuilder = BasicMessageContextBuilder.getInstance();
            messageContext = ctxBuilder.buildAcs(req, res, ssoService, externalRelayState, samlRequest);
            MessageContext mc = messageContext.getMessageContext();
            Response samlResponse = (Response)mc.getMessage();
            String inboundMsgIssuer = samlResponse.getIssuer().getValue();
            messageContext.setInboundSamlMessageIssuer(inboundMsgIssuer);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("samlResponse:" + samlResponse), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)DumpData.dumpXMLObject(null, (XMLObject)samlResponse, 0).toString(), (Object[])new Object[0]);
            }
            if (messageContext.getPeerEntityMetadata() != null) {
                String issuer = messageContext.getPeerEntityMetadata().getEntityID();
                ((SAMLPeerEntityContext)mc.getSubcontext(SAMLPeerEntityContext.class, true)).setEntityId(issuer);
            }
            ((SAMLPeerEntityContext)mc.getSubcontext(SAMLPeerEntityContext.class, true)).setRole(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
            ((SAMLProtocolContext)mc.getSubcontext(SAMLProtocolContext.class, true)).setProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
            ResponseValidator validator = new ResponseValidator(messageContext, samlResponse);
            validator.validate();
            List<Assertion> assertions = this.decryptEncryptedAssertion(samlResponse, messageContext);
            Assertion validatedAssertion = null;
            SamlException lastException = null;
            for (Assertion assertion : assertions) {
                if (assertion.getAuthnStatements().size() > 0 && assertion.getSubject() != null) {
                    try {
                        AssertionValidator assertionValidator = new AssertionValidator(messageContext, assertion);
                        assertionValidator.validateAssertion();
                        validatedAssertion = assertion;
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug((TraceComponent)tc, (String)("Found valid Asserion " + assertion.getID()), (Object[])new Object[0]);
                        break;
                    }
                    catch (Exception assertionValidator) {
                        void e;
                        FFDCFilter.processException((Throwable)assertionValidator, (String)"com.ibm.ws.security.saml.sso20.acs.WebSSOConsumer", (String)"116", (Object)this, (Object[])new Object[]{req, res, ssoService, externalRelayState, samlRequest});
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Invalid Asserion " + assertion.getID()), (Object[])new Object[0]);
                        }
                        lastException = e;
                        continue;
                    }
                }
                if (assertion.getSubject() == null) {
                    lastException = new SamlException("SAML20_ELEMENT_ERR", null, new Object[]{"Subject"});
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Assertion " + assertion.getID() + " does not contain Subject"), (Object[])new Object[0]);
                    continue;
                }
                if (assertion.getAuthnStatements().size() != 0) continue;
                lastException = new SamlException("SAML20_ELEMENT_ERR", null, new Object[]{"AuthnStatement"});
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Assertion " + assertion.getID() + " does not contain AuthnStatement"), (Object[])new Object[0]);
            }
            if (validatedAssertion == null) {
                throw lastException;
            }
            messageContext.setValidatedAssertion(validatedAssertion);
        }
        catch (SamlException e) {
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.saml.sso20.acs.WebSSOConsumer", (String)"149", (Object)this, (Object[])new Object[]{req, res, ssoService, externalRelayState, samlRequest});
            throw new SamlException(e);
        }
        return messageContext;
    }

    @FFDCIgnore(value={SamlException.class})
    public BasicMessageContext<InboundMessageType, OutboundMessageType> handleSAMLLogoutResponse(HttpServletRequest req, HttpServletResponse res, SsoSamlService ssoService, String externalRelayState, SsoRequest samlRequest) throws SamlException {
        BasicMessageContext<?, ?> messageContext = null;
        try {
            BasicMessageContextBuilder<?, ?, ?> ctxBuilder = BasicMessageContextBuilder.getInstance();
            messageContext = ctxBuilder.buildSLO(req, res, ssoService, externalRelayState, samlRequest);
            MessageContext mc = messageContext.getMessageContext();
            LogoutResponse samlLogoutResponse = (LogoutResponse)messageContext.getMessageContext().getMessage();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("saml logoutResponse:" + samlLogoutResponse), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)DumpData.dumpXMLObject(null, (XMLObject)samlLogoutResponse, 0).toString(), (Object[])new Object[0]);
            }
            messageContext.setInboundSamlMessageIssuer(samlLogoutResponse.getIssuer().getValue());
            if (messageContext.getPeerEntityMetadata() != null) {
                String issuer = messageContext.getPeerEntityMetadata().getEntityID();
                ((SAMLPeerEntityContext)mc.getSubcontext(SAMLPeerEntityContext.class, true)).setEntityId(issuer);
            }
            ((SAMLPeerEntityContext)mc.getSubcontext(SAMLPeerEntityContext.class, true)).setRole(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
            ((SAMLProtocolContext)mc.getSubcontext(SAMLProtocolContext.class, true)).setProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
            ResponseValidator validator = new ResponseValidator(messageContext, samlLogoutResponse);
            messageContext.setSLOResponseStatus(validator.validateLogoutStatus());
            if ("urn:oasis:names:tc:SAML:2.0:status:Success".equals(messageContext.getSLOResponseStatus().getStatusCode().getValue())) {
                validator.validateLogoutResponse();
            }
        }
        catch (SamlException e) {
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.saml.sso20.acs.WebSSOConsumer", (String)"193", (Object)this, (Object[])new Object[]{req, res, ssoService, externalRelayState, samlRequest});
            throw new SamlException(e);
        }
        return messageContext;
    }

    public BasicMessageContext<InboundMessageType, OutboundMessageType> handleSAMLLogoutRequest(HttpServletRequest req, HttpServletResponse res, SsoSamlService ssoService, String externalRelayState, SsoRequest samlRequest) throws SamlException {
        BasicMessageContext<?, ?> messageContext = null;
        BasicMessageContextBuilder<?, ?, ?> ctxBuilder = BasicMessageContextBuilder.getInstance();
        messageContext = ctxBuilder.buildSLO(req, res, ssoService, externalRelayState, samlRequest);
        MessageContext mc = messageContext.getMessageContext();
        LogoutRequest samlLogoutRequest = (LogoutRequest)messageContext.getMessageContext().getMessage();
        messageContext.setInboundSamlMessageIssuer(samlLogoutRequest.getIssuer().getValue());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("saml logoutRequest:" + samlLogoutRequest), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("saml logoutRequest ID :" + samlLogoutRequest.getID()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)DumpData.dumpXMLObject(null, (XMLObject)samlLogoutRequest, 0).toString(), (Object[])new Object[0]);
        }
        if (messageContext.getPeerEntityMetadata() != null) {
            String issuer = messageContext.getPeerEntityMetadata().getEntityID();
            ((SAMLPeerEntityContext)mc.getSubcontext(SAMLPeerEntityContext.class, true)).setEntityId(issuer);
        }
        ((SAMLPeerEntityContext)mc.getSubcontext(SAMLPeerEntityContext.class, true)).setRole(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
        ((SAMLProtocolContext)mc.getSubcontext(SAMLProtocolContext.class, true)).setProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        StatusBuilderUtil statusBuilderUtil = new StatusBuilderUtil();
        messageContext.setSLOResponseStatus(statusBuilderUtil.buildStatus());
        ResponseValidator validator = new ResponseValidator(messageContext, samlLogoutRequest);
        if (validator.validateLogoutRequest()) {
            statusBuilderUtil.setStatus(messageContext.getSLOResponseStatus(), "urn:oasis:names:tc:SAML:2.0:status:Success");
        }
        messageContext.setInResponseTo(samlLogoutRequest.getID());
        return messageContext;
    }

    /*
     * WARNING - void declaration
     */
    List<Assertion> decryptEncryptedAssertion(Response samlResponse, BasicMessageContext<?, ?> context) throws SamlException {
        ArrayList<Assertion> assertionList = samlResponse.getAssertions();
        List encryptedAssertionList = samlResponse.getEncryptedAssertions();
        if (encryptedAssertionList.size() > 0) {
            int numberOfAssertions = samlResponse.getAssertions().size() + samlResponse.getEncryptedAssertions().size();
            assertionList = new ArrayList<Assertion>(numberOfAssertions);
            assertionList.addAll(samlResponse.getAssertions());
            Decrypter decrypter = context.getDecrypter();
            for (EncryptedAssertion eA : encryptedAssertionList) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("encryptedAssertion:" + eA + " decrypter:" + decrypter), (Object[])new Object[0]);
                    }
                    Assertion decryptedAssertion = decrypter.decrypt(eA);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("decryptedAssertion:" + decryptedAssertion), (Object[])new Object[0]);
                    }
                    assertionList.add(decryptedAssertion);
                    samlResponse.getAssertions().add(decryptedAssertion);
                }
                catch (Exception decryptedAssertion) {
                    void e;
                    FFDCFilter.processException((Throwable)decryptedAssertion, (String)"com.ibm.ws.security.saml.sso20.acs.WebSSOConsumer", (String)"262", (Object)this, (Object[])new Object[]{samlResponse, context});
                    throw new SamlException((Exception)e);
                }
            }
        }
        return assertionList;
    }
}

