/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.module.web.el;

import jakarta.el.ELContext;
import jakarta.el.ExpressionFactory;
import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;
import org.jboss.weld.logging.ElLogger;
import org.jboss.weld.module.web.el.WeldMethodExpression;
import org.jboss.weld.module.web.el.WeldValueExpression;
import org.jboss.weld.module.web.util.el.ForwardingExpressionFactory;

public class WeldExpressionFactory
extends ForwardingExpressionFactory {
    private final ExpressionFactory delegate;

    public WeldExpressionFactory(ExpressionFactory expressionFactory) {
        if (expressionFactory == null) {
            throw ElLogger.LOG.nullExpressionFactory();
        }
        this.delegate = expressionFactory;
    }

    @Override
    protected ExpressionFactory delegate() {
        return this.delegate;
    }

    public ValueExpression createValueExpression(ELContext context, String expression, Class expectedType) {
        return new WeldValueExpression(super.createValueExpression(context, expression, expectedType));
    }

    public MethodExpression createMethodExpression(ELContext context, String expression, Class expectedReturnType, Class[] expectedParamTypes) {
        return new WeldMethodExpression(super.createMethodExpression(context, expression, expectedReturnType, expectedParamTypes));
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) || obj instanceof WeldExpressionFactory && this.delegate().equals(((WeldExpressionFactory)((Object)obj)).delegate());
    }
}

