/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.unchecked.Unchecked;
import io.smallrye.reactive.messaging.IncomingInterceptor;
import io.smallrye.reactive.messaging.PublisherDecorator;
import io.smallrye.reactive.messaging.providers.helpers.CDIUtils;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.List;
import org.eclipse.microprofile.reactive.messaging.Message;

@ApplicationScoped
public class IncomingInterceptorDecorator
implements PublisherDecorator {
    @Any
    @Inject
    Instance<IncomingInterceptor> interceptors;

    @Override
    public int getPriority() {
        return 500;
    }

    @Override
    public Multi<? extends Message<?>> decorate(Multi<? extends Message<?>> publisher, String channelName, boolean isConnector) {
        Multi multi = publisher;
        if (isConnector) {
            List<IncomingInterceptor> matching;
            Instance instances = CDIUtils.getInstanceById(this.interceptors, channelName);
            if (instances.isUnsatisfied()) {
                instances = this.interceptors.select(new Annotation[0]).select(new Annotation[]{Default.Literal.INSTANCE});
            }
            if (!(matching = CDIUtils.getSortedInstances(instances)).isEmpty()) {
                IncomingInterceptor interceptor = matching.get(0);
                multi = multi.map(m -> {
                    Message<?> before = interceptor.afterMessageReceive((Message<?>)m);
                    Message withAck = before.withAckWithMetadata(metadata -> before.ack(metadata).thenAccept(Unchecked.consumer(x -> interceptor.onMessageAck(before))));
                    return withAck.withNackWithMetadata((reason, metadata) -> withAck.nack(reason, metadata).thenAccept(Unchecked.consumer(x -> interceptor.onMessageNack((Message<?>)withAck, (Throwable)reason))));
                });
            }
        }
        return multi;
    }
}

