/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.context;

import io.smallrye.graphql.api.Context;
import io.smallrye.graphql.execution.context.SmallRyeContext;
import java.util.Map;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;
import org.eclipse.microprofile.context.spi.ThreadContextSnapshot;

public class SmallRyeContextThreadContextProvider
implements ThreadContextProvider {
    public static final String TYPE = "MICROPROFILE_GRAPHQL_CONTEXT";

    public ThreadContextSnapshot currentContext(Map<String, String> props) {
        SmallRyeContext captured = SmallRyeContext.getContext();
        return () -> {
            Context current = this.restore(captured);
            return () -> this.restore(current);
        };
    }

    private Context restore(Context context) {
        SmallRyeContext currentContext = SmallRyeContext.getContext();
        if (context == null) {
            SmallRyeContext.remove();
        } else {
            SmallRyeContext.setContext((SmallRyeContext)context);
        }
        return currentContext;
    }

    public ThreadContextSnapshot clearedContext(Map<String, String> props) {
        return () -> {
            Context current = this.restore(null);
            return () -> this.restore(current);
        };
    }

    public String getThreadContextType() {
        return TYPE;
    }
}

