/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openid20.consumer;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.openid20.OpenidClientAuthenticator;
import com.ibm.ws.security.openid20.OpenidClientConfig;
import com.ibm.ws.security.openid20.consumer.BoundedHashMap;
import com.ibm.ws.security.openid20.consumer.ConsumerManagerFactory;
import com.ibm.ws.security.openid20.consumer.MessageDigestUtil;
import com.ibm.ws.security.openid20.consumer.Utils;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.ProviderAuthenticationResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.security.auth.Subject;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.VerificationResult;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.ParameterList;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpenidClientAuthenticatorImpl
implements OpenidClientAuthenticator {
    static final TraceComponent tc = Tr.register(OpenidClientAuthenticatorImpl.class, (String)"OpenId", (String)"com.ibm.ws.security.openid20.internal.resources.OpenIDMessages");
    OpenidClientConfig openidClientConfig;
    static Map<String, Object> requestCache = null;
    ConsumerManagerFactory consumerManagerFactory = new ConsumerManagerFactory(null);
    Utils utils;
    ConsumerManager consumerManager;
    static final long serialVersionUID = 6451218519631986087L;

    @Override
    public void initialize(OpenidClientConfig openidClientConfig, SSLContext sslContext) {
        this.openidClientConfig = openidClientConfig;
        this.consumerManager = this.consumerManagerFactory.getConsumerManager(openidClientConfig, sslContext);
        requestCache = Collections.synchronizedMap(new BoundedHashMap(openidClientConfig.getMaxDiscoveryCacheSize()));
        this.utils = new Utils(openidClientConfig);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void createAuthRequest(ServletRequest request, ServletResponse response) throws ServletException, Exception {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        String identifier = (String)req.getAttribute("openid_identifier");
        if (identifier == null) {
            identifier = req.getParameter("openid_identifier");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("openID identifier from request parameter:" + identifier), (Object[])new Object[0]);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("openID identifier from request attribute(TAI):" + identifier), (Object[])new Object[0]);
        }
        DiscoveryInformation discoveryInformation = this.utils.discoverOpenID(this.consumerManager, identifier);
        String uniqueKey = MessageDigestUtil.getDigest();
        String return_to_url = this.utils.createReturnToUrl(req, uniqueKey);
        String rpRealm = this.utils.getRpRealm(req);
        AuthRequest authRequest = null;
        try {
            authRequest = this.consumerManager.authenticate(discoveryInformation, return_to_url, rpRealm);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.openid20.consumer.OpenidClientAuthenticatorImpl", (String)"105", (Object)this, (Object[])new Object[]{request, response});
            Tr.error((TraceComponent)tc, (String)"OPENID_AUTHENTICATE_FAILED", (Object[])new Object[]{identifier});
            throw new IOException((Throwable)e);
        }
        this.utils.addUserInfoAttributes(authRequest);
        resp.setStatus(401);
        resp.sendRedirect(authRequest.getDestinationUrl(true));
        requestCache.put(uniqueKey, discoveryInformation);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ProviderAuthenticationResult verifyResponse(ServletRequest request) throws ServletException, IOException {
        String mapUserName;
        Hashtable<String, Object> customProperties;
        ProviderAuthenticationResult result = null;
        HttpServletRequest req = (HttpServletRequest)request;
        String receivingUrl = this.utils.getReceivingUrl(req);
        ParameterList response = new ParameterList(req.getParameterMap());
        VerificationResult verificationResult = null;
        DiscoveryInformation discoveryInfo = this.getDiscoveryInfoFromCache(req);
        try {
            verificationResult = this.consumerManager.verify(receivingUrl, response, discoveryInfo);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.openid20.consumer.OpenidClientAuthenticatorImpl", (String)"140", (Object)this, (Object[])new Object[]{request});
            Tr.error((TraceComponent)tc, (String)"OPENID_VERIFY_RESPONSE_FAILED", (Object[])new Object[]{discoveryInfo.getClaimedIdentifier()});
            throw new IOException(e.getLocalizedMessage());
        }
        Identifier verifiedIdentifier = verificationResult.getVerifiedId();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Verification identifier:" + verifiedIdentifier), (Object[])new Object[0]);
        }
        if (verifiedIdentifier == null) {
            this.utils.verificationFailed(verificationResult, discoveryInfo);
        }
        AuthSuccess authSuccess = (AuthSuccess)verificationResult.getAuthResponse();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("AuthSuccess:" + authSuccess), (Object[])new Object[0]);
        }
        String identifier = verifiedIdentifier.getIdentifier();
        if (authSuccess != null) {
            ArrayList<String> groupIds;
            String realm;
            customProperties = new Hashtable<String, Object>();
            Map<String, Object> attributes = this.utils.receiveUserInfoAttributes(authSuccess);
            String opEndPoint = this.utils.getOpEndPoint(discoveryInfo, authSuccess, attributes);
            customProperties.put("openidProvider", opEndPoint);
            mapUserName = this.utils.resolveMapUserName(authSuccess, attributes);
            if (this.openidClientConfig.isIncludeCustomCacheKeyInSubject()) {
                String customCacheKey = mapUserName + attributes.hashCode();
                customProperties.put("com.ibm.wsspi.security.cred.cacheKey", customCacheKey);
                customProperties.put("com.ibm.ws.authentication.internal.assertion", Boolean.TRUE);
            }
            if ((realm = this.utils.getRealmName(this.openidClientConfig, attributes)) != null && !realm.isEmpty()) {
                customProperties.put("com.ibm.wsspi.security.cred.realm", realm);
            }
            if ((groupIds = this.utils.getGroups(this.openidClientConfig, attributes, realm)) != null && !groupIds.isEmpty()) {
                customProperties.put("com.ibm.wsspi.security.cred.groups", groupIds);
            }
            if (this.openidClientConfig.isIncludeUserInfoInSubject()) {
                customProperties.putAll(attributes);
            }
        } else {
            Tr.error((TraceComponent)tc, (String)"OPENID_AUTHENTICATE_FAILED", (Object[])new Object[]{identifier});
            throw new IOException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.openid20.internal.resources.OpenIDMessages", (String)"OPENID_AUTHENTICATE_FAILED", (Object[])new Object[]{identifier}, (String)"CWWKS1513E: OpenID authentication failed for identifier {0}."));
        }
        result = new ProviderAuthenticationResult(AuthResult.SUCCESS, 200, mapUserName, (Subject)null, customProperties, null);
        return result;
    }

    private DiscoveryInformation getDiscoveryInfoFromCache(HttpServletRequest req) throws IOException {
        String uniqueKey = req.getParameter("rp_identifier");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("uniqueKey:" + uniqueKey), (Object[])new Object[0]);
        }
        if (uniqueKey == null || uniqueKey.trim().isEmpty()) {
            Tr.error((TraceComponent)tc, (String)"OPENID_RP_REQUEST_IDENTIFIER_NULL", (Object[])new Object[0]);
            throw new IOException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.openid20.internal.resources.OpenIDMessages", (String)"OPENID_RP_REQUEST_IDENTIFIER_NULL", null, (String)"CWWKS1512E: OpenID replying party request identifier is null."));
        }
        DiscoveryInformation discoveryInfo = (DiscoveryInformation)requestCache.get(uniqueKey);
        if (discoveryInfo == null) {
            Tr.error((TraceComponent)tc, (String)"OPENID_CACHE_MISS_FOR_UNIQUE_KEY", (Object[])new Object[]{uniqueKey});
            throw new IOException(TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.openid20.internal.resources.OpenIDMessages", (String)"OPENID_CACHE_MISS_FOR_UNIQUE_KEY", null, (String)"CWWKS1514E: There is no cache entry found for unique key {0}."));
        }
        requestCache.remove(uniqueKey);
        return discoveryInfo;
    }
}

