/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore.jdbc;

import com.arjuna.ats.arjuna.common.ObjectStoreEnvironmentBean;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStoreAPI;
import com.arjuna.ats.arjuna.objectstore.jdbc.JDBCAccess;
import com.arjuna.ats.arjuna.state.InputBuffer;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputBuffer;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.objectstore.jdbc.JDBCImple_driver;
import java.io.IOException;
import java.io.SyncFailedException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class JDBCStore
implements ObjectStoreAPI {
    protected JDBCImple_driver _theImple;
    private static final String DEFAULT_TABLE_NAME = "JBossTSTxTable";
    protected String tableName;
    protected final ObjectStoreEnvironmentBean jdbcStoreEnvironmentBean;
    private String _storeName;
    private static Map<String, JDBCImple_driver> imples = new HashMap();
    private static Map<String, String> storeNames = new HashMap();

    public void start() {
    }

    public void stop() {
    }

    public boolean fullCommitNeeded() {
        return true;
    }

    public void sync() throws SyncFailedException, ObjectStoreException {
    }

    public boolean isType(Uid u, String tn, int st) throws ObjectStoreException {
        return this.currentState(u, tn) == st;
    }

    public String getStoreName() {
        return this._storeName;
    }

    public boolean allObjUids(String s, InputObjectState buff) throws ObjectStoreException {
        return this.allObjUids(s, buff, -1);
    }

    public boolean commit_state(Uid objUid, String tName) throws ObjectStoreException {
        return this._theImple.commit_state(objUid, tName);
    }

    public boolean hide_state(Uid objUid, String tName) throws ObjectStoreException {
        return this._theImple.hide_state(objUid, tName);
    }

    public boolean reveal_state(Uid objUid, String tName) throws ObjectStoreException {
        return this._theImple.reveal_state(objUid, tName);
    }

    public int currentState(Uid objUid, String tName) throws ObjectStoreException {
        return this._theImple.currentState(objUid, tName);
    }

    public InputObjectState read_committed(Uid storeUid, String tName) throws ObjectStoreException {
        return this._theImple.read_state(storeUid, tName, 1);
    }

    public InputObjectState read_uncommitted(Uid storeUid, String tName) throws ObjectStoreException {
        return this._theImple.read_state(storeUid, tName, 2);
    }

    public boolean remove_committed(Uid storeUid, String tName) throws ObjectStoreException {
        return this._theImple.remove_state(storeUid, tName, 1);
    }

    public boolean remove_uncommitted(Uid storeUid, String tName) throws ObjectStoreException {
        return this._theImple.remove_state(storeUid, tName, 2);
    }

    public boolean write_committed(Uid storeUid, String tName, OutputObjectState state) throws ObjectStoreException {
        return this._theImple.write_state(storeUid, tName, state, 1);
    }

    public boolean write_uncommitted(Uid storeUid, String tName, OutputObjectState state) throws ObjectStoreException {
        return this._theImple.write_state(storeUid, tName, state, 2);
    }

    public boolean allObjUids(String tName, InputObjectState state, int match) throws ObjectStoreException {
        return this._theImple.allObjUids(tName, state, match);
    }

    public boolean allTypes(InputObjectState foundTypes) throws ObjectStoreException {
        return this._theImple.allTypes(foundTypes);
    }

    public synchronized void packInto(OutputBuffer buff) throws IOException {
        buff.packString(this.tableName);
    }

    public synchronized void unpackFrom(InputBuffer buff) throws IOException {
        this.tableName = buff.unpackString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDBCStore(ObjectStoreEnvironmentBean jdbcStoreEnvironmentBean) throws ObjectStoreException {
        this.jdbcStoreEnvironmentBean = jdbcStoreEnvironmentBean;
        String connectionDetails = jdbcStoreEnvironmentBean.getJdbcAccess();
        if (connectionDetails == null) {
            throw new ObjectStoreException(tsLogger.i18NLogger.get_objectstore_JDBCStore_5());
        }
        String impleTableName = DEFAULT_TABLE_NAME;
        String tablePrefix = jdbcStoreEnvironmentBean.getTablePrefix();
        if (tablePrefix != null && tablePrefix.length() > 0) {
            impleTableName = tablePrefix + impleTableName;
        }
        this.tableName = impleTableName;
        String key = connectionDetails + this.tableName;
        this._theImple = (JDBCImple_driver)imples.get(key);
        this._storeName = (String)storeNames.get(key);
        if (this._theImple == null) {
            try {
                int minor;
                int major;
                String name;
                StringTokenizer stringTokenizer = new StringTokenizer(connectionDetails, ";");
                JDBCAccess jdbcAccess = (JDBCAccess)Class.forName(stringTokenizer.nextToken()).newInstance();
                jdbcAccess.initialise(stringTokenizer);
                this._storeName = jdbcAccess.getClass().getName() + ":" + this.tableName;
                try (Connection connection = jdbcAccess.getConnection();){
                    DatabaseMetaData md = connection.getMetaData();
                    name = md.getDriverName();
                    major = md.getDriverMajorVersion();
                    minor = md.getDriverMinorVersion();
                }
                int index = name.indexOf(32);
                if (index != -1) {
                    name = name.substring(0, index);
                }
                name = name.replaceAll("-", "_");
                name = name.toLowerCase();
                String packagePrefix = JDBCStore.class.getName().substring(0, JDBCStore.class.getName().lastIndexOf(46)) + ".drivers.";
                Class<?> jdbcImpleClass = null;
                try {
                    jdbcImpleClass = Class.forName(packagePrefix + name + "_" + major + "_" + minor + "_driver");
                }
                catch (ClassNotFoundException cnfe) {
                    try {
                        jdbcImpleClass = Class.forName(packagePrefix + name + "_" + major + "_driver");
                    }
                    catch (ClassNotFoundException cnfe2) {
                        jdbcImpleClass = Class.forName(packagePrefix + name + "_driver");
                    }
                }
                this._theImple = (JDBCImple_driver)jdbcImpleClass.newInstance();
                this._theImple.initialise(jdbcAccess, this.tableName, jdbcStoreEnvironmentBean);
                imples.put(key, this._theImple);
                storeNames.put(key, this._storeName);
            }
            catch (Exception e) {
                tsLogger.i18NLogger.fatal_objectstore_JDBCStore_2(this._storeName, (Throwable)e);
                throw new ObjectStoreException((Throwable)e);
            }
        }
    }
}

