/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.mcp.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.mcp.annotations.Tool;
import io.openliberty.mcp.internal.SpecialArgumentType;
import io.openliberty.mcp.internal.ToolMetadata;
import io.openliberty.mcp.internal.ToolRegistry;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessManagedBean;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class McpCdiExtension
implements Extension {
    private static final TraceComponent tc = Tr.register(McpCdiExtension.class, (String)"MCP", null);
    private ToolRegistry tools = new ToolRegistry();
    private ConcurrentHashMap<String, LinkedList<String>> duplicateToolsMap = new ConcurrentHashMap();
    static final long serialVersionUID = -7660993903738045561L;

    void registerTools(@Observes ProcessManagedBean<?> pmb) {
        AnnotatedType type = pmb.getAnnotatedBeanClass();
        Class javaClass = type.getJavaClass();
        for (AnnotatedMethod m : type.getMethods()) {
            Tool toolAnnotation = (Tool)m.getAnnotation(Tool.class);
            if (toolAnnotation == null) continue;
            this.registerTool(toolAnnotation, pmb.getBean(), m);
        }
    }

    void afterDeploymentValidation(@Observes AfterDeploymentValidation afterDeploymentValidation, BeanManager manager) {
        this.reportOnDuplicateTools(afterDeploymentValidation);
        this.reportOnToolArgEdgeCases(afterDeploymentValidation);
        this.reportOnDuplicateSpecialArguments(afterDeploymentValidation);
        this.reportOnInvalidSpecialArguments(afterDeploymentValidation);
    }

    private void reportOnToolArgEdgeCases(AfterDeploymentValidation afterDeploymentValidation) {
        StringBuilder sbBlankArgs = new StringBuilder("Blank arguments found in MCP Tool:");
        StringBuilder sbDuplicateArgs = new StringBuilder("Duplicate arguments found in MCP Tool:");
        StringBuilder sbMissingArgs = new StringBuilder("Missing arguments found in MCP Tool:");
        boolean blankArgumentsFound = false;
        boolean duplicateArgumentsFound = false;
        boolean missingArgumentName = false;
        for (ToolMetadata tool : this.tools.getAllTools()) {
            Map<String, ToolMetadata.ArgumentMetadata> arguments = tool.arguments();
            for (String argName : arguments.keySet()) {
                if (argName.isBlank()) {
                    sbBlankArgs.append("\n").append("Tool: " + tool.getToolQualifiedName());
                    blankArgumentsFound = true;
                    continue;
                }
                if (arguments.get(argName).isDuplicate()) {
                    sbDuplicateArgs.append("\n").append("Tool: " + tool.getToolQualifiedName() + " -  Argument: " + argName);
                    duplicateArgumentsFound = true;
                    continue;
                }
                if (!argName.equals("<<<MISSING TOOL_ARG NAME>>>")) continue;
                sbMissingArgs.append("\n").append("Tool: " + tool.getToolQualifiedName());
                sbMissingArgs.append("\n Tool argument name was not provided for the parameter. Either add a name to the @ToolArg annotation, or to add the -parameters compiler option to use the parameter name");
                missingArgumentName = true;
            }
        }
        if (blankArgumentsFound) {
            afterDeploymentValidation.addDeploymentProblem((Throwable)new Exception(sbBlankArgs.toString()));
        }
        if (duplicateArgumentsFound) {
            afterDeploymentValidation.addDeploymentProblem((Throwable)new Exception(sbDuplicateArgs.toString()));
        }
        if (missingArgumentName) {
            afterDeploymentValidation.addDeploymentProblem((Throwable)new Exception(sbMissingArgs.toString()));
        }
    }

    private void reportOnDuplicateTools(AfterDeploymentValidation afterDeploymentValidation) {
        this.duplicateToolsMap.entrySet().removeIf(e -> ((LinkedList)e.getValue()).size() == 1);
        StringBuilder sb = new StringBuilder("More than one MCP tool has the same name: \n");
        for (String toolName : this.duplicateToolsMap.keySet()) {
            LinkedList<String> qualifiedNames = this.duplicateToolsMap.get(toolName);
            sb.append("Tool: ").append(toolName);
            sb.append(" -- Methods found:\n");
            for (String qualifiedName : qualifiedNames) {
                sb.append("    - ").append(qualifiedName + "\n");
            }
        }
        if (this.duplicateToolsMap.size() != 0) {
            afterDeploymentValidation.addDeploymentProblem((Throwable)new Exception(sb.toString()));
        }
    }

    private void reportOnDuplicateSpecialArguments(AfterDeploymentValidation afterDeploymentValidation) {
        StringBuilder sbDuplicateSpecialArgs = new StringBuilder("Only 1 instance is allowed, of type: ");
        for (ToolMetadata tool : this.tools.getAllTools()) {
            HashMap<SpecialArgumentType.Resolution, Integer> resultCountMap = new HashMap<SpecialArgumentType.Resolution, Integer>();
            for (ToolMetadata.SpecialArgumentMetadata specialArgument : tool.specialArguments()) {
                SpecialArgumentType.Resolution specialArgumentTypeResolution = specialArgument.typeResolution();
                if (specialArgumentTypeResolution.specialArgsType() == SpecialArgumentType.UNSUPPORTED) continue;
                resultCountMap.merge(specialArgumentTypeResolution, 1, Integer::sum);
                if ((Integer)resultCountMap.get(specialArgumentTypeResolution) <= 1) continue;
                sbDuplicateSpecialArgs.append(specialArgumentTypeResolution);
                sbDuplicateSpecialArgs.append("\n  But more than 1 argument was found. Please remove the extra instance, or check if you meant to include @ToolArg to one of them");
                sbDuplicateSpecialArgs.append("\n").append("Tool: " + tool.getToolQualifiedName());
                afterDeploymentValidation.addDeploymentProblem((Throwable)new Exception(sbDuplicateSpecialArgs.toString()));
            }
        }
    }

    private void reportOnInvalidSpecialArguments(AfterDeploymentValidation afterDeploymentValidation) {
        StringBuilder sbInvalidSpecialArgs = new StringBuilder("Special argument type not supported: ");
        for (ToolMetadata tool : this.tools.getAllTools()) {
            for (ToolMetadata.SpecialArgumentMetadata specialArgument : tool.specialArguments()) {
                if (specialArgument.typeResolution().specialArgsType() != SpecialArgumentType.UNSUPPORTED) continue;
                sbInvalidSpecialArgs.append(specialArgument.typeResolution());
                sbInvalidSpecialArgs.append("\n  Please check if you have the correct class imported for your argument, or you meant to include @ToolArg");
                sbInvalidSpecialArgs.append("\n").append("Tool: " + tool.getToolQualifiedName());
                afterDeploymentValidation.addDeploymentProblem((Throwable)new Exception(sbInvalidSpecialArgs.toString()));
            }
        }
    }

    private void registerTool(Tool tool, Bean<?> bean, AnnotatedMethod<?> method) {
        ToolMetadata toolmd = ToolMetadata.createFrom(tool, bean, method);
        this.duplicateToolsMap.computeIfAbsent(toolmd.name(), key -> new LinkedList()).add(toolmd.getToolQualifiedName());
        this.tools.addTool(toolmd);
        if (TraceComponent.isAnyTracingEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Registered tool: " + toolmd.name()), (Object[])new Object[]{toolmd});
            } else if (tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Registered tool: " + toolmd.name()), (Object[])new Object[]{method});
            }
        }
    }

    public ToolRegistry getToolRegistry() {
        return this.tools;
    }
}

