/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.server.plugins;

import com.ibm.oauth.core.api.error.OidcServerException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.ProvidersService;
import com.ibm.ws.security.oauth20.api.OAuth20Provider;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClient;
import com.ibm.ws.security.openidconnect.server.plugins.OIDCProvidersConfig;
import com.ibm.ws.security.openidconnect.server.plugins.ProviderInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class UIHelperService {
    private static TraceComponent tc = Tr.register(UIHelperService.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages");
    static final String epPrefix = "/oidc/endpoint/";
    static final long serialVersionUID = -1660408183177031521L;

    public static List<Map<String, String>> getProviderInfo() {
        ArrayList<Map<String, String>> providerData = new ArrayList<Map<String, String>>();
        ArrayList<ProviderInfo> pinfo = OIDCProvidersConfig.getProviderNames();
        UIHelperService me = new UIHelperService();
        for (ProviderInfo p : pinfo) {
            providerData.add(me.determineProviderConfig(p));
        }
        return providerData;
    }

    Map<String, String> determineProviderConfig(ProviderInfo info) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", info.getName());
        boolean apppw = false;
        boolean apptok = false;
        boolean clientadmin = false;
        OidcBaseClient client = null;
        OAuth20Provider provider = ProvidersService.getOAuth20Provider((String)info.getOauthProviderName());
        try {
            client = provider.getClientProvider().get(provider.getInternalClientId());
        }
        catch (OidcServerException oidcServerException) {
            FFDCFilter.processException((Throwable)oidcServerException, (String)"com.ibm.ws.security.openidconnect.server.plugins.UIHelperService", (String)"71", (Object)this, (Object[])new Object[]{info});
        }
        boolean bl = clientadmin = !provider.isLocalStoreUsed();
        if (client != null) {
            map.put("personalTokenManagement", epPrefix + info.getName() + "/personalTokenManagement");
            map.put("usersTokenManagement", epPrefix + info.getName() + "/usersTokenManagement");
        }
        if (clientadmin) {
            map.put("clientManagement", epPrefix + info.getName() + "/clientManagement");
        }
        return map;
    }
}

