/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ui.internal.v1.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.feature.FeatureProvisioner;
import com.ibm.ws.kernel.provisioning.BundleRepositoryRegistry;
import com.ibm.ws.kernel.provisioning.ContentBasedLocalBundleRepository;
import com.ibm.ws.kernel.provisioning.ProductExtension;
import com.ibm.ws.kernel.provisioning.ProductExtensionInfo;
import com.ibm.ws.ui.internal.RequestNLS;
import com.ibm.ws.ui.internal.v1.IFeatureToolService;
import com.ibm.ws.ui.internal.v1.pojo.FeatureTool;
import com.ibm.ws.ui.internal.v1.utils.ManifestUtils;
import com.ibm.ws.ui.internal.v1.utils.SortedBundle;
import com.ibm.wsspi.kernel.service.location.VariableRegistry;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.aries.util.manifest.ManifestHeaderProcessor;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.VersionRange;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

@Component(service={IFeatureToolService.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class FeatureToolService
implements IFeatureToolService,
EventHandler {
    private static final TraceComponent tc = Tr.register(FeatureToolService.class);
    private final AtomicReference<Map<String, Long>> processedManifestFiles = new AtomicReference(new HashMap());
    private boolean initialProcess = true;
    private final Map<String, IconInfo> iconMap = new HashMap<String, IconInfo>();
    private FeatureProvisioner provisionerService;
    private VariableRegistry variableRegistryService;
    private ServiceRegistration<EventHandler> eventHandlerReg = null;
    private static final String FEATURE_MANAGER_TOPIC = "com/ibm/ws/kernel/feature/internal/FeatureManager/*";
    private static final String FEATURE_PROVISIONING_STARTED = "started";
    private static final String FEATURE_PROVISIONING_COMPLETE = "complete";
    private static final String FEATURE_PROVISIONING_PENDING = "pending";
    private final AtomicReference<String> featureProvisioningState = new AtomicReference<String>("complete");
    private boolean bundleRepoRefreshed = false;
    private final int featureProvisionCheckInterval = 200;
    private final int featureProvisionMaxLoopCount = 10;

    @Reference(service=FeatureProvisioner.class)
    protected synchronized void setKernelProvisioner(FeatureProvisioner provisionerService) {
        this.provisionerService = provisionerService;
    }

    protected synchronized void unsetKernelProvisioner(FeatureProvisioner provisionerService) {
        if (this.provisionerService == provisionerService) {
            this.provisionerService = null;
        }
    }

    @Reference(service=VariableRegistry.class)
    protected synchronized void setVariableRegistry(VariableRegistry variableRegistryService) {
        this.variableRegistryService = variableRegistryService;
    }

    protected synchronized void unsetVariableRegistry(VariableRegistry variableRegistryService) {
        if (this.variableRegistryService == variableRegistryService) {
            this.variableRegistryService = null;
        }
    }

    protected void activate(ComponentContext componentCtx) {
        Hashtable<String, String[]> svcProps = new Hashtable<String, String[]>();
        ((Dictionary)svcProps).put("event.topics", new String[]{FEATURE_MANAGER_TOPIC});
        this.eventHandlerReg = componentCtx.getBundleContext().registerService(EventHandler.class, (Object)this, svcProps);
    }

    protected void deactivate() {
        if (this.eventHandlerReg != null) {
            this.eventHandlerReg.unregister();
        }
    }

    @Override
    public Set<FeatureTool> getTools() {
        return this.processToolFeatures(Locale.getDefault());
    }

    private synchronized Set<FeatureTool> processToolFeatures(Locale locale) {
        HashSet<FeatureTool> toolFeatures = new HashSet<FeatureTool>();
        HashMap<String, Long> newTimestamps = new HashMap<String, Long>();
        Map<String, Long> oldTimestamps = this.processedManifestFiles.get();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Previously processed Manifests: ", (Object[])new Object[]{oldTimestamps});
        }
        this.bundleRepoRefreshed = false;
        File featureDir = new File(this.variableRegistryService.resolveString("${wlp.install.dir}"), "lib/features");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Processing Core Manifests: " + featureDir), (Object[])new Object[0]);
        }
        File[] manifestFiles = this.getFeatureManifests(newTimestamps, oldTimestamps, featureDir);
        this.addAllFeatureTools(toolFeatures, locale, featureDir, "", manifestFiles, "");
        featureDir = new File(this.variableRegistryService.resolveString("${feature:usr}"));
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Processing Usr Manifests: " + featureDir), (Object[])new Object[0]);
        }
        manifestFiles = this.getFeatureManifests(newTimestamps, oldTimestamps, featureDir);
        this.addAllFeatureTools(toolFeatures, locale, featureDir, "usr:", manifestFiles, "usr");
        for (ProductExtensionInfo productExtension : ProductExtension.getProductExtensions()) {
            String featureType = productExtension.getName();
            String productExtnFeatureDirName = this.variableRegistryService.resolveString("${feature:" + featureType + "}");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing " + featureType + " Production Extension Manifests: " + productExtnFeatureDirName), (Object[])new Object[0]);
            }
            featureDir = new File(productExtnFeatureDirName);
            manifestFiles = this.getFeatureManifests(newTimestamps, oldTimestamps, featureDir);
            this.addAllFeatureTools(toolFeatures, locale, featureDir, featureType + ":", manifestFiles, featureType);
        }
        this.processedManifestFiles.set(newTimestamps);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Setting processed Manifest Files: " + this.processedManifestFiles), (Object[])new Object[0]);
        }
        this.waitForFeatureProvision();
        BundleRepositoryRegistry.disposeAll();
        this.initialProcess = false;
        return toolFeatures;
    }

    private boolean hasNewOrChangedManifests(Map<String, Long> newTimestamps, Map<String, Long> oldTimestamps) {
        for (Map.Entry<String, Long> newTimestamp : newTimestamps.entrySet()) {
            Long oldTimestamp = oldTimestamps.get(newTimestamp.getKey());
            if (oldTimestamp != null && newTimestamp.getValue() <= oldTimestamp) continue;
            return true;
        }
        return false;
    }

    private File[] getFeatureManifests(Map<String, Long> newTimestamps, Map<String, Long> oldTimestamps, File featureDir) {
        File[] manifestFiles = ManifestUtils.findAllFeatureManifests(featureDir);
        Map<String, Long> theseTimestamps = this.getManifestPaths(manifestFiles);
        if (this.hasNewOrChangedManifests(theseTimestamps, oldTimestamps) && !this.initialProcess) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"New or updated feature manifests detected. Refreshing the Feature Manager", (Object[])new Object[0]);
            }
            this.featureProvisioningState.set(FEATURE_PROVISIONING_PENDING);
            this.provisionerService.refreshFeatures();
            this.waitForFeatureProvision();
        }
        newTimestamps.putAll(theseTimestamps);
        return manifestFiles;
    }

    private void addAllFeatureTools(Set<FeatureTool> toolFeatures, Locale locale, File featureDir, String featureType, File[] manifestFiles, String bundleRepoType) {
        Map<String, Map<String, String>> featureToolManifests = this.getFeatureToolManifests(manifestFiles, featureType);
        if (!featureToolManifests.isEmpty()) {
            if (!this.bundleRepoRefreshed && this.waitForFeatureProvision()) {
                BundleRepositoryRegistry.disposeAll();
                this.bundleRepoRefreshed = true;
            }
            this.addToolsToCatalog(toolFeatures, featureToolManifests, bundleRepoType, featureDir, locale);
        }
    }

    private Map<String, Map<String, String>> getFeatureToolManifests(File[] manifests, String installedFeaturePrefix) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Processing manifests: " + Arrays.toString(manifests)), (Object[])new Object[0]);
        }
        Set installedFeatures = this.provisionerService.getInstalledFeatures();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Installed features: " + installedFeatures), (Object[])new Object[0]);
        }
        Map<String, Map<String, String>> allToolFeatureManifests = ManifestUtils.findToolFeatureManifests(manifests);
        return this.filterInstalledToolFeatureManifests(allToolFeatureManifests, installedFeatures, installedFeaturePrefix);
    }

    private Map<String, Long> getManifestPaths(File[] manifestsToProcess) {
        HashMap<String, Long> manifestPaths = new HashMap<String, Long>();
        if (manifestsToProcess != null) {
            for (File manifest : manifestsToProcess) {
                manifestPaths.put(manifest.getAbsolutePath(), this.getLastModified(manifest));
            }
        }
        return manifestPaths;
    }

    private Long getLastModified(final File fileToCheck) {
        return AccessController.doPrivileged(new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                return fileToCheck.lastModified();
            }
        });
    }

    private Map<String, Map<String, String>> filterInstalledToolFeatureManifests(Map<String, Map<String, String>> featureManifests, Set<String> installedFeatures, String installedFeaturePrefix) {
        HashMap<String, Map<String, String>> installedFeatureManifests = new HashMap<String, Map<String, String>>();
        if (installedFeatures != null) {
            for (Map<String, String> manifestHeaders : featureManifests.values()) {
                String featureName = ManifestUtils.getInstalledFeatureName(manifestHeaders.get("Subsystem-SymbolicName"), manifestHeaders.get("IBM-ShortName"), installedFeaturePrefix);
                if (!installedFeatures.contains(featureName)) continue;
                installedFeatureManifests.put(featureName, manifestHeaders);
            }
        }
        return installedFeatureManifests;
    }

    private FeatureTool getTool(Set<FeatureTool> set, String featureName, String version) {
        FeatureTool tool = null;
        for (FeatureTool checkTool : set) {
            String checkToolFeatureName = checkTool.getFeatureName();
            String checkToolVersion = checkTool.getFeatureVersion();
            if (featureName == null || version == null || !featureName.equals(checkToolFeatureName) || !version.equals(checkToolVersion)) continue;
            tool = checkTool;
        }
        return tool;
    }

    @FFDCIgnore(value={IOException.class})
    private ResourceBundle getResourceBundle(File l10nDir, String symbolicName, Locale locale) {
        File[] files;
        for (File file : files = new File[]{new File(l10nDir, symbolicName + "_" + locale.toString() + ".properties"), new File(l10nDir, symbolicName + "_" + locale.getLanguage() + ".properties"), new File(l10nDir, symbolicName + ".properties")}) {
            if (!file.exists()) continue;
            try {
                return new PropertyResourceBundle(new FileReader(file));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private String getTranslatedProperty(File featureDir, String symbolicName, String property, Locale locale) {
        File l10nDir = new File(featureDir, "l10n");
        ResourceBundle rb = this.getResourceBundle(l10nDir, symbolicName, locale);
        if (rb != null) {
            return rb.getString(property);
        }
        return property;
    }

    private void addToolsToCatalog(Set<FeatureTool> set, Map<String, Map<String, String>> toolManifests, String bundleRepoType, File featureDir, Locale locale) {
        for (Map.Entry<String, Map<String, String>> featureManifest : toolManifests.entrySet()) {
            FeatureTool existingTool;
            String icon;
            String description;
            String featureName = featureManifest.getKey();
            Map<String, String> featureHeaders = featureManifest.getValue();
            String symbolicName = ManifestHeaderProcessor.parseBundleSymbolicName((String)featureHeaders.get("Subsystem-SymbolicName")).getName();
            String featureVersion = featureHeaders.get("Subsystem-Version");
            String shortName = featureHeaders.get("IBM-ShortName");
            String name = featureHeaders.get("Subsystem-Name");
            if (name == null) {
                name = shortName != null ? shortName : symbolicName;
            } else if (name.charAt(0) == '%') {
                name = this.getTranslatedProperty(featureDir, symbolicName, name.substring(1), locale);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Processing feature " + featureName + ":"), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("   SymbolicName:" + symbolicName), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("   IBMShortName:" + shortName), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("   Version:     " + featureVersion), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("   Name:        " + name), (Object[])new Object[0]);
            }
            if ((description = featureHeaders.get("Subsystem-Description")) != null && description.charAt(0) == '%') {
                description = this.getTranslatedProperty(featureDir, symbolicName, description.substring(1), locale);
            }
            if ((icon = featureHeaders.get("Subsystem-Icon")) != null) {
                this.iconMap.put(symbolicName, new IconInfo(icon, new File(featureDir, "icons").getAbsolutePath()));
            }
            String iconURL = "/ibm/api/adminCenter/v1/icons/" + (icon == null ? "default" : symbolicName);
            String content = featureHeaders.get("Subsystem-Endpoint-Content");
            if (content != null) {
                this.addToolsToCatalogForEndpoints(set, symbolicName, featureName, featureVersion, featureHeaders, featureDir, iconURL, description);
                continue;
            }
            content = featureHeaders.get("Subsystem-Content");
            String url = this.findToolURL(symbolicName, content, bundleRepoType);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Adding FeatureTool " + featureName + ":"), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("   Description:" + description), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("   icon:       " + iconURL), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("   url:        " + url), (Object[])new Object[0]);
            }
            if ((existingTool = this.getTool(set, featureName, featureVersion)) != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Processing feature " + featureName + ":"), (Object[])new Object[0]);
                }
                set.remove(existingTool);
            }
            set.add(new FeatureTool(featureName, featureVersion, shortName, name, url, iconURL, description));
        }
    }

    private void addToolsToCatalogForEndpoints(Set<FeatureTool> set, String symbolicName, String featureName, String featureVersion, Map<String, String> featureHeaders, File featureDir, String defaultIconURL, String description) {
        String endpointNames = featureHeaders.get("Subsystem-Endpoint-Names");
        String endpointUrls = featureHeaders.get("Subsystem-Endpoint-Urls");
        String endpointShortNames = featureHeaders.get("Subsystem-Endpoint-ShortNames");
        String endpointIcons = featureHeaders.get("Subsystem-Endpoint-Icons");
        if (endpointNames != null && endpointUrls != null && endpointShortNames != null) {
            Map<String, String> endpointNameMap = this.convertStringToMap(endpointNames);
            Map<String, String> endpointShortNameMap = this.convertStringToMap(endpointShortNames);
            Map<String, String> endpointUrlMap = this.convertStringToMap(endpointUrls);
            Map<String, String> endpointIconMap = null;
            if (endpointIcons != null) {
                endpointIconMap = this.convertIconStringToMap(endpointIcons);
            }
            if (endpointNameMap.size() > 0 && endpointShortNameMap.size() > 0) {
                List<Map<String, String>> endpointProviderList;
                if (endpointUrlMap.get("className") != null && endpointUrlMap.get("methodName") != null && (endpointProviderList = this.getEndpointProviders(endpointUrlMap)) != null) {
                    endpointUrlMap = this.getEndpointUrlMap(endpointProviderList);
                }
                if (endpointUrlMap.size() > 0) {
                    for (Map.Entry<String, String> urlEntry : endpointUrlMap.entrySet()) {
                        FeatureTool existingTool;
                        String icon;
                        String endpointUrl = urlEntry.getValue();
                        int lastSlashIndex = endpointUrl.lastIndexOf("/");
                        if (lastSlashIndex == -1) continue;
                        String endpointNameInUrl = endpointUrl.substring(lastSlashIndex + 1);
                        int secondLastSlashIndex = endpointUrl.lastIndexOf("/", lastSlashIndex - 1);
                        String providerNameInUrl = endpointUrl.substring(secondLastSlashIndex + 1, lastSlashIndex);
                        String[] endpointFeatureNameAndVersion = this.getEndpointNameAndVersion(featureName);
                        String endpointFeatureName = endpointFeatureNameAndVersion != null && endpointFeatureNameAndVersion.length == 2 ? endpointFeatureNameAndVersion[0] + "." + endpointNameInUrl + "." + providerNameInUrl + endpointFeatureNameAndVersion[1] : endpointNameInUrl + "." + providerNameInUrl + "-1.0";
                        String endpointName = endpointNameMap.get(endpointNameInUrl) + " - " + providerNameInUrl;
                        String endpointShortName = this.buildEndpointShortName(endpointShortNameMap.get(endpointNameInUrl), providerNameInUrl);
                        String iconURL = defaultIconURL;
                        if (endpointIconMap != null && (icon = endpointIconMap.get(endpointNameInUrl)) != null) {
                            this.iconMap.put(symbolicName + "/" + endpointNameInUrl, new IconInfo(icon, new File(featureDir, "icons").getAbsolutePath()));
                            iconURL = "/ibm/api/adminCenter/v1/icons/" + symbolicName + "/" + endpointNameInUrl;
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Adding FeatureTool " + endpointFeatureName + ":"), (Object[])new Object[0]);
                            Tr.debug((TraceComponent)tc, (String)("   Description:       " + description), (Object[])new Object[0]);
                            Tr.debug((TraceComponent)tc, (String)("   endpointName:      " + endpointName), (Object[])new Object[0]);
                            Tr.debug((TraceComponent)tc, (String)("   endpointShortName: " + endpointShortName), (Object[])new Object[0]);
                            Tr.debug((TraceComponent)tc, (String)("   icon:              " + iconURL), (Object[])new Object[0]);
                            Tr.debug((TraceComponent)tc, (String)("   url:               " + endpointUrl), (Object[])new Object[0]);
                        }
                        if ((existingTool = this.getTool(set, endpointFeatureName, featureVersion)) != null) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Processing endpoint name " + endpointFeatureName + ":"), (Object[])new Object[0]);
                            }
                            set.remove(existingTool);
                        }
                        set.add(new FeatureTool(endpointFeatureName, featureVersion, endpointShortName, endpointName, endpointUrl, iconURL, description));
                    }
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"no endpoint url", (Object[])new Object[0]);
                }
            }
        }
    }

    private String findToolURL(String featureSymbolicName, String subsystemContent, String bundleRepoType) {
        String toolURL = null;
        if (subsystemContent != null) {
            ArrayList<SortedBundle> featureBundles = new ArrayList<SortedBundle>();
            for (ManifestHeaderProcessor.NameValuePair nvp : ManifestHeaderProcessor.parseExportString((String)subsystemContent)) {
                SortedBundle sortedBundle;
                Map attrs = nvp.getAttributes();
                String type = (String)attrs.get("type");
                if ("osgi.subsystem.feature".equals(type)) continue;
                String version = (String)attrs.get("version");
                String location = (String)attrs.get("location:");
                VersionRange versionRange = null;
                if (version != null) {
                    versionRange = new VersionRange(version);
                }
                BundleRepositoryRegistry.BundleRepositoryHolder bundleRepoHolder = BundleRepositoryRegistry.getRepositoryHolder((String)bundleRepoType);
                File bundle = null;
                if (bundleRepoHolder != null) {
                    ContentBasedLocalBundleRepository bundleRepo = bundleRepoHolder.getBundleRepository();
                    bundle = bundleRepo.selectBundle(location, nvp.getName(), versionRange);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Bundle matching location:" + location + "  Symbolicname:" + nvp.getName() + " and versionRange: " + versionRange + " = " + bundle), (Object[])new Object[0]);
                    }
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Not matching BundleRepositoryHolder found for repository type " + bundleRepoType), (Object[])new Object[0]);
                }
                if (bundle == null || (sortedBundle = ManifestUtils.processBundleManifest(bundle)) == null) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Adding Sorted Bundle: " + sortedBundle), (Object[])new Object[0]);
                }
                featureBundles.add(sortedBundle);
            }
            for (SortedBundle sortedBundle : featureBundles) {
                if (toolURL != null || !sortedBundle.isUIEndpoint() || featureSymbolicName == null || !featureSymbolicName.equals(sortedBundle.getPrimaryEndpointFeatureName())) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Selected SortedBundle: " + sortedBundle), (Object[])new Object[0]);
                }
                toolURL = sortedBundle.getWebContextPath();
            }
            if (toolURL == null) {
                Collections.sort(featureBundles);
                for (SortedBundle sortedBundle : featureBundles) {
                    if (toolURL != null || sortedBundle.getWebContextPath() == null) continue;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Selected SortedBundle: " + sortedBundle), (Object[])new Object[0]);
                    }
                    toolURL = sortedBundle.getWebContextPath();
                }
            }
        }
        return toolURL;
    }

    @Override
    public Map<String, String> getIconMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        this.processToolFeatures(Locale.getDefault());
        for (Map.Entry<String, IconInfo> iconEntry : this.iconMap.entrySet()) {
            String header = iconEntry.getValue().getIconHeader();
            result.put(iconEntry.getKey(), header);
        }
        return result;
    }

    @Override
    public String getFeatureIconInstallDir(String featureSymbolicName) {
        String result = null;
        IconInfo iconInfo = this.iconMap.get(featureSymbolicName);
        if (iconInfo != null) {
            result = iconInfo.getIconInstallLocation();
        }
        return result;
    }

    @Override
    public List<FeatureTool> getToolsForRequestLocale() {
        ArrayList<FeatureTool> t = new ArrayList<FeatureTool>();
        t.addAll(this.processToolFeatures(RequestNLS.getLocale()));
        return t;
    }

    @Override
    public FeatureTool getToolForRequestLocale(String id) {
        for (FeatureTool f : this.processToolFeatures(RequestNLS.getLocale())) {
            if (!f.getId().equals(id)) continue;
            return f;
        }
        return null;
    }

    public void handleEvent(Event event) {
        String eventTopic = event.getTopic();
        if (eventTopic.endsWith("/FEATURE_CHANGING")) {
            this.featureProvisioningState.set(FEATURE_PROVISIONING_STARTED);
        } else if (eventTopic.endsWith("/FEATURE_CHANGE")) {
            this.featureProvisioningState.compareAndSet(FEATURE_PROVISIONING_STARTED, FEATURE_PROVISIONING_COMPLETE);
        }
    }

    private boolean waitForFeatureProvision() {
        boolean result = false;
        int iteration = 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Current Feature Provisioning state: " + this.featureProvisioningState.get()), (Object[])new Object[0]);
        }
        while (!(result = FEATURE_PROVISIONING_COMPLETE.equals(this.featureProvisioningState.get())) && iteration++ < 10) {
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Provisioning either active or pending (iteration: " + iteration + "): " + result), (Object[])new Object[0]);
                }
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Final provisioning state: " + this.featureProvisioningState.get()), (Object[])new Object[0]);
        }
        return result;
    }

    private Map<String, String> convertStringToMap(String stringValue) {
        String[] keyValuePairs = stringValue.split(",");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String pair : keyValuePairs) {
            String[] keyValuePair = pair.split("=");
            if (keyValuePair.length != 2) continue;
            map.put(keyValuePair[0].trim(), keyValuePair[1].trim());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("return map: " + map), (Object[])new Object[0]);
        }
        return map;
    }

    private Map<String, String> convertIconStringToMap(String stringValue) {
        HashMap<String, String> map = new HashMap<String, String>();
        Matcher match = Pattern.compile("(\\w+)=(.*?)(?=,\\w+=|$)").matcher(stringValue);
        while (match.find()) {
            map.put(match.group(1), match.group(2));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("return map: " + map), (Object[])new Object[0]);
        }
        return map;
    }

    private List<Map<String, String>> getEndpointProviders(Map<String, String> endpointUrlMap) {
        List endpointProviderList;
        block4: {
            endpointProviderList = null;
            String className = endpointUrlMap.get("className");
            String methodName = endpointUrlMap.get("methodName");
            try {
                Method method = Class.forName(className).getMethod(methodName, null);
                Object returnObj = method.invoke(null, (Object[])null);
                if (returnObj instanceof List) {
                    endpointProviderList = (List)returnObj;
                }
            }
            catch (Exception ex) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Exception: " + ex.getMessage()), (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("endpoint providers: " + endpointProviderList), (Object[])new Object[0]);
        }
        return endpointProviderList;
    }

    private Map<String, String> getEndpointUrlMap(List<Map<String, String>> endpointProviderList) {
        HashMap<String, String> endpointUrlInMap = new HashMap<String, String>();
        for (Map<String, String> endpointUrlMapInList : endpointProviderList) {
            String provider = endpointUrlMapInList.get("name");
            if (provider == null) {
                provider = "default";
            }
            for (Map.Entry<String, String> urlEntry : endpointUrlMapInList.entrySet()) {
                if ("name".equals(urlEntry.getKey())) continue;
                endpointUrlInMap.put(urlEntry.getKey() + "." + provider, urlEntry.getValue());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("endpointUrls: " + endpointUrlInMap), (Object[])new Object[0]);
        }
        return endpointUrlInMap;
    }

    private String[] getEndpointNameAndVersion(String featureName) {
        String[] nameAndVersion = null;
        Pattern pattern = Pattern.compile("(.*)(-\\d+\\.\\d+)");
        Matcher matcher = pattern.matcher(featureName);
        if (matcher.matches() && matcher.groupCount() == 2) {
            nameAndVersion = new String[]{matcher.group(1), matcher.group(2)};
        }
        return nameAndVersion;
    }

    private String buildEndpointShortName(String initEndpointShortName, String providerName) {
        String returnEndpointShortName = initEndpointShortName + "." + providerName;
        String[] shortNameAndVersion = this.getEndpointNameAndVersion(initEndpointShortName);
        if (shortNameAndVersion != null) {
            returnEndpointShortName = shortNameAndVersion[0] + "." + providerName + shortNameAndVersion[1];
        }
        return returnEndpointShortName;
    }

    @Override
    public synchronized boolean isFeatureProvisioned(String featureToFind) {
        if (this.provisionerService != null) {
            return this.provisionerService.getInstalledFeatures().contains(featureToFind);
        }
        return false;
    }

    private static class IconInfo {
        private String iconHeader = null;
        private String iconInstallLocation = null;

        public IconInfo(String iconHeader, String iconInstallLocation) {
            this.iconHeader = iconHeader;
            this.iconInstallLocation = iconInstallLocation;
        }

        public String getIconHeader() {
            return this.iconHeader;
        }

        public String getIconInstallLocation() {
            return this.iconInstallLocation;
        }
    }
}

