/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.filter.AuthenticationFilter;
import com.ibm.ws.security.common.config.CommonConfigUtils;
import com.ibm.ws.security.common.structures.Cache;
import com.ibm.ws.security.social.SocialLoginConfig;
import com.ibm.ws.security.social.SocialLoginService;
import com.ibm.ws.security.social.UserApiConfig;
import com.ibm.ws.security.social.error.SocialLoginException;
import com.ibm.ws.security.social.internal.UserApiConfigImpl;
import com.ibm.ws.security.social.internal.utils.SocialConfigUtils;
import com.ibm.ws.security.social.tai.SocialLoginTAI;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(name="com.ibm.ws.security.social.okdServiceLogin", configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, service={SocialLoginConfig.class}, property={"service.vendor=IBM", "type=okdServiceLogin"})
public class OkdServiceLoginImpl
implements SocialLoginConfig {
    public static final TraceComponent tc = Tr.register(OkdServiceLoginImpl.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    public static final String KEY_UNIQUE_ID = "id";
    private String uniqueId;
    public static final String KEY_userValidationApi = "userValidationApi";
    private String userValidationApi;
    public static final String KEY_apiResponseCacheTime = "apiResponseCacheTime";
    private long apiResponseCacheTime = 600000L;
    public static final String KEY_authFilterRef = "authFilterRef";
    private String authFilterRef;
    public static final String KEY_realmName = "realmName";
    private String realmName;
    public static final String KEY_sslRef = "sslRef";
    private String sslRef;
    private UserApiConfig[] userApiConfigs = null;
    private AuthenticationFilter authFilter = null;
    private SSLContext sslContext = null;
    private SSLSocketFactory sslSocketFactory = null;
    final AtomicServiceReference<SocialLoginService> socialLoginServiceRef = new AtomicServiceReference("socialLoginService");
    private CommonConfigUtils configUtils = new CommonConfigUtils();
    private SocialConfigUtils socialConfigUtils = new SocialConfigUtils();
    static final long serialVersionUID = -7555256260418541640L;

    @Reference(service=SocialLoginService.class, name="socialLoginService", cardinality=ReferenceCardinality.MANDATORY)
    protected void setSocialLoginService(ServiceReference<SocialLoginService> ref) {
        this.socialLoginServiceRef.setReference(ref);
    }

    protected void unsetSocialLoginService(ServiceReference<SocialLoginService> ref) {
        this.socialLoginServiceRef.unsetReference(ref);
    }

    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> props) {
        this.socialLoginServiceRef.activate(cc);
        this.initProps(cc, props);
        Tr.info((TraceComponent)tc, (String)"SOCIAL_LOGIN_CONFIG_PROCESSED", (Object[])new Object[]{this.uniqueId});
    }

    @Modified
    protected void modified(ComponentContext cc, Map<String, Object> props) {
        this.initProps(cc, props);
        Tr.info((TraceComponent)tc, (String)"SOCIAL_LOGIN_CONFIG_MODIFIED", (Object[])new Object[]{this.uniqueId});
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.socialLoginServiceRef.deactivate(cc);
        Tr.info((TraceComponent)tc, (String)"SOCIAL_LOGIN_CONFIG_DEACTIVATED", (Object[])new Object[]{this.uniqueId});
    }

    private void initProps(ComponentContext cc, Map<String, Object> props) {
        this.uniqueId = this.configUtils.getConfigAttribute(props, KEY_UNIQUE_ID);
        this.userValidationApi = this.configUtils.getConfigAttribute(props, KEY_userValidationApi);
        this.apiResponseCacheTime = this.configUtils.getLongConfigAttribute(props, KEY_apiResponseCacheTime, this.apiResponseCacheTime);
        this.authFilterRef = this.configUtils.getConfigAttribute(props, KEY_authFilterRef);
        this.realmName = this.configUtils.getConfigAttribute(props, KEY_realmName);
        this.sslRef = this.configUtils.getConfigAttribute(props, KEY_sslRef);
        this.initializeMembersAfterConfigAttributesPopulated(props);
    }

    private void initializeMembersAfterConfigAttributesPopulated(Map<String, Object> props) {
        this.initializeUserApiConfigs();
        this.resetLazyInitializedMembers();
    }

    private void initializeUserApiConfigs() {
        UserApiConfig[] results = new UserApiConfig[]{new UserApiConfigImpl(this.userValidationApi)};
        this.userApiConfigs = results;
    }

    protected void resetLazyInitializedMembers() {
        this.authFilter = null;
        this.sslContext = null;
        this.sslSocketFactory = null;
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public String getClientId() {
        return null;
    }

    @Override
    public String getClientSecret() {
        return null;
    }

    @Override
    public String getAuthorizationEndpoint() {
        return null;
    }

    @Override
    public String getTokenEndpoint() {
        return null;
    }

    @Override
    public UserApiConfig[] getUserApis() {
        if (this.userApiConfigs == null) {
            return null;
        }
        return (UserApiConfig[])this.userApiConfigs.clone();
    }

    @Override
    public String getUserApi() {
        return this.userValidationApi;
    }

    @Override
    public String getUserApiResponseIdentifier() {
        return null;
    }

    @Override
    public Cache getSocialLoginCookieCache() {
        return null;
    }

    @Override
    public String getDisplayName() {
        return null;
    }

    @Override
    public String getWebsite() {
        return null;
    }

    @Override
    public String getSslRef() {
        return this.sslRef;
    }

    @Override
    public AuthenticationFilter getAuthFilter() {
        if (this.authFilter == null) {
            this.authFilter = SocialLoginTAI.getAuthFilter(this.authFilterRef);
        }
        return this.authFilter;
    }

    @Override
    public SSLSocketFactory getSSLSocketFactory() throws SocialLoginException {
        this.sslSocketFactory = this.socialConfigUtils.getSSLSocketFactory(this.uniqueId, this.sslContext, this.socialLoginServiceRef, this.sslRef);
        return this.sslSocketFactory;
    }

    @Override
    public HashMap<String, PublicKey> getPublicKeys() throws SocialLoginException {
        return null;
    }

    @Override
    public String getScope() {
        return null;
    }

    @Override
    public String getResponseType() {
        return null;
    }

    @Override
    public String getGrantType() {
        return null;
    }

    @Override
    public boolean createNonce() {
        return false;
    }

    @Override
    public String getResource() {
        return null;
    }

    @Override
    public boolean isClientSideRedirectSupported() {
        return false;
    }

    @Override
    public String getTokenEndpointAuthMethod() {
        return null;
    }

    @Override
    public String getRedirectToRPHostAndPort() {
        return null;
    }

    @Override
    public String getJwksUri() {
        return null;
    }

    @Override
    public String getRealmName() {
        return this.realmName;
    }

    @Override
    public String getRealmNameAttribute() {
        return null;
    }

    @Override
    public String getUserNameAttribute() {
        return "name";
    }

    @Override
    public String getGroupNameAttribute() {
        return "groups";
    }

    @Override
    public String getUserUniqueIdAttribute() {
        return null;
    }

    @Override
    public boolean getMapToUserRegistry() {
        return false;
    }

    @Override
    public String getJwtRef() {
        return null;
    }

    @Override
    public String[] getJwtClaims() {
        return null;
    }

    @Override
    public String getRequestTokenUrl() {
        return null;
    }

    @Override
    public PublicKey getPublicKey() throws SocialLoginException {
        return null;
    }

    @Override
    public PrivateKey getPrivateKey() throws SocialLoginException {
        return null;
    }

    @Override
    public String getAlgorithm() {
        return null;
    }

    @Override
    public boolean getUserApiNeedsSpecialHeader() {
        return false;
    }

    @Override
    public String getResponseMode() {
        return null;
    }

    @Override
    public boolean getUseSystemPropertiesForHttpClientConnections() {
        return false;
    }

    @Override
    public String getUserApiType() {
        return null;
    }

    @Override
    public String getUserApiToken() {
        return null;
    }

    @Override
    public long getApiResponseCacheTime() {
        return this.apiResponseCacheTime;
    }

    @Override
    public boolean isAccessTokenRequired() {
        return true;
    }

    @Override
    public boolean isAccessTokenSupported() {
        return false;
    }

    @Override
    public String getAccessTokenHeaderName() {
        return null;
    }

    @Override
    public String getIntrospectionTokenTypeHint() {
        return null;
    }
}

