/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.clients.common;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.crypto.HashUtils;
import com.ibm.ws.security.openidconnect.clients.common.ConvergedClientConfig;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientConfig;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientUtil;
import com.ibm.ws.security.openidconnect.clients.common.OidcCommonClientRequest;
import com.ibm.ws.security.openidconnect.clients.common.OidcUtil;
import com.ibm.ws.security.openidconnect.token.IDTokenValidationFailedException;
import com.ibm.ws.security.openidconnect.token.JWTTokenValidationFailedException;
import com.ibm.ws.webcontainer.security.ReferrerURLCookieHandler;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tcClient", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OidcClientRequest
extends OidcCommonClientRequest {
    public static final String PROPAGATION_TOKEN_AUTHENTICATED = "com.ibm.ws.webcontainer.security.openidconnect.propagation.token.authenticated";
    public static final String INBOUND_PROPAGATION_VALUE = "com.ibm.ws.webcontainer.security.openidconnect.inbound.propagation.value";
    public static final String AUTHN_SESSION_DISABLED = "com.ibm.ws.webcontainer.security.openidconnect.authn.session.disabled";
    public static final String ACCESS_TOKEN_IN_LTPA_TOKEN = "com.ibm.ws.webcontainer.security.oidc.accesstoken.in.ltpa";
    public static final String OIDC_ACCESS_TOKEN = "oidc_access_token";
    public static final String inboundNone = "none";
    public static final String inboundRequired = "required";
    public static final String inboundSupported = "supported";
    private static final TraceComponent tcClient = Tr.register(OidcClientRequest.class, (String)"OPENIDCONNECT", (String)"com.ibm.ws.security.openidconnect.clients.common.resources.OidcClientMessages");
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected ConvergedClientConfig oidcClientConfig;
    protected String clientConfigId;
    protected String preCookieValue = null;
    protected boolean authnSessionDisabled = true;
    protected String inboundValue = "none";
    protected String tokenType = "ID Token";
    protected String tokenTypeNoSpace = "IDToken";
    boolean bSecuredHttp = false;
    String httpHostStr = null;
    int serverPort = -1;
    static final long serialVersionUID = 7081479320291191641L;

    OidcClientRequest() {
    }

    public OidcClientRequest(HttpServletRequest request, HttpServletResponse response, ConvergedClientConfig convergedClientConfig, ReferrerURLCookieHandler referrerURLCookieHandler) {
        this.oidcClientConfig = convergedClientConfig;
        this.request = request;
        this.response = response;
        OidcClientUtil.setReferrerURLCookieHandler(referrerURLCookieHandler);
        this.clientConfigId = convergedClientConfig.getId();
        this.authnSessionDisabled = convergedClientConfig.isAuthnSessionDisabled_propagation();
        this.inboundValue = convergedClientConfig.getInboundPropagation();
        request.setAttribute(AUTHN_SESSION_DISABLED, (Object)this.authnSessionDisabled);
        request.setAttribute(INBOUND_PROPAGATION_VALUE, (Object)this.inboundValue);
        request.setAttribute(ACCESS_TOKEN_IN_LTPA_TOKEN, (Object)convergedClientConfig.getAccessTokenInLtpaCookie());
    }

    public void createOidcClientCookieIfAnyAndDisableLtpa() {
        if (this.oidcClientConfig.isDisableLtpaCookie()) {
            boolean bAuthenticatedByPropagationToken;
            Boolean booleanAuthenticatedByPropagationToken = (Boolean)this.request.getAttribute(PROPAGATION_TOKEN_AUTHENTICATED);
            boolean bl = bAuthenticatedByPropagationToken = booleanAuthenticatedByPropagationToken == null ? false : booleanAuthenticatedByPropagationToken;
            if (!bAuthenticatedByPropagationToken) {
                String oidcClientCookieName = this.getOidcClientCookieName();
                String oidcClientPreCookieValue = this.preCookieValue;
                if (oidcClientCookieName != null && oidcClientPreCookieValue != null) {
                    OidcClientRequest.createOidcClientCookie(this.request, this.response, oidcClientCookieName, oidcClientPreCookieValue);
                }
            }
        }
    }

    public String getOidcClientCookieName() {
        return this.oidcClientConfig.getOidcClientCookieName();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OidcClientRequest [clientId:").append(this.clientConfigId).append(" request:").append(this.request).append("]");
        return sb.toString();
    }

    public static void createOidcClientCookie(HttpServletRequest req, HttpServletResponse resp, String cookieName, String cookieValue) {
        Cookie c = OidcClientUtil.getReferrerURLCookieHandler().createCookie(cookieName, cookieValue, req);
        resp.addCookie(c);
    }

    @Trivial
    public String generatePreCookieValue() {
        if (this.preCookieValue != null) {
            if (tcClient.isDebugEnabled()) {
                Tr.debug((TraceComponent)tcClient, (String)("preCookieValue exists:" + this.preCookieValue), (Object[])new Object[0]);
            }
            return null;
        }
        this.preCookieValue = OidcUtil.generateRandom();
        return this.preCookieValue;
    }

    @Trivial
    public String getAndSetCustomCacheKeyValue() {
        return this.getCustomCookieValue(this.generatePreCookieValue());
    }

    @Sensitive
    @Trivial
    public String getCustomCookieValue(String preCookieValue) {
        if (preCookieValue == null || preCookieValue.isEmpty()) {
            return null;
        }
        String preDigest = this.clientConfigId + "_" + preCookieValue + "_ibm";
        return HashUtils.digest((String)preDigest);
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public OidcClientConfig getOidcClientConfig() {
        return this.oidcClientConfig.getOidcClientConfig();
    }

    @Override
    public String getTokenType() {
        return this.tokenType;
    }

    public String getTokenTypeNoSpace() {
        return this.tokenTypeNoSpace;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
        if (tokenType.equalsIgnoreCase("ID Token")) {
            this.bInboundSupported = false;
            this.bInboundRequired = false;
            this.tokenTypeNoSpace = "IDToken";
        } else if (tokenType.equalsIgnoreCase("Json Web Token")) {
            this.bInboundRequired = inboundRequired.equalsIgnoreCase(this.inboundValue);
            this.bInboundSupported = inboundSupported.equalsIgnoreCase(this.inboundValue);
            this.tokenTypeNoSpace = "JsonWebToken";
        } else {
            this.bInboundRequired = inboundRequired.equalsIgnoreCase(this.inboundValue);
            this.bInboundSupported = inboundSupported.equalsIgnoreCase(this.inboundValue);
            this.tokenTypeNoSpace = "AccessToken";
        }
    }

    @Override
    public String getInboundPropagation() {
        return this.oidcClientConfig.getInboundPropagation();
    }

    public boolean isInboundRequired() {
        return this.bInboundRequired;
    }

    public JWTTokenValidationFailedException error(boolean bTrError, TraceComponent tc, String[] msgCodes, Object[] objects) throws JWTTokenValidationFailedException {
        int msgIndex = 0;
        if (!"ID Token".equals(this.getTokenType())) {
            msgIndex = 1;
        }
        return this.error(bTrError, tc, msgCodes[msgIndex], objects);
    }

    public JWTTokenValidationFailedException error(boolean bTrError, TraceComponent tc, String msgCode, Object[] objects) throws JWTTokenValidationFailedException {
        if (bTrError && !this.bInboundSupported) {
            Tr.error((TraceComponent)tcClient, (String)msgCode, (Object[])objects);
        }
        if ("ID Token".equals(this.getTokenType())) {
            return IDTokenValidationFailedException.format(tc, msgCode, objects);
        }
        return JWTTokenValidationFailedException.format(tc, msgCode, objects);
    }

    public void error(String[] msgCodes, Object[] objects) {
        if (!this.bInboundSupported) {
            int msgIndex = 0;
            if (!"ID Token".equals(this.getTokenType())) {
                msgIndex = 1;
            }
            Tr.error((TraceComponent)tcClient, (String)msgCodes[msgIndex], (Object[])objects);
        }
    }

    String getErrorMessage() {
        String message = this.getRealmMessage();
        message = message + ", error=\"invalid_token\",";
        message = message + " error_description=\"";
        message = this.tokenType.equals("Json Web Token") ? message + "Check JWT token" : message + "Check access token";
        message = message + "\"";
        return message;
    }

    String getRealmMessage() {
        String realm = null;
        realm = this.tokenType.equals("Json Web Token") ? "jwt" : "oauth";
        return "Bearer realm=\"" + realm + "\"";
    }

    public void setWWWAuthenticate() {
        String errorMsg = null;
        errorMsg = "No Token".equals(this.getHeaderFailMsg()) ? this.getRealmMessage() : this.getErrorMessage();
        this.response.setHeader("WWW-Authenticate", errorMsg);
    }

    @Override
    public List<String> getAudiences() {
        return this.oidcClientConfig.getAudiences();
    }

    @Override
    public boolean isPreServiceUrl(String audience) {
        String portStr;
        if (this.httpHostStr == null) {
            String httpStr = "http://";
            this.bSecuredHttp = this.request.isSecure();
            if (this.bSecuredHttp) {
                httpStr = "https://";
            }
            this.httpHostStr = httpStr + this.request.getServerName();
            this.serverPort = this.request.getServerPort();
        }
        if (!audience.startsWith(this.httpHostStr)) {
            return false;
        }
        String portAudience = audience.substring(this.httpHostStr.length());
        if (portAudience.isEmpty() || portAudience.startsWith("/")) {
            if (this.serverPort == -1) {
                return true;
            }
            if (this.bSecuredHttp ? this.serverPort == 443 : this.serverPort == 80) {
                return true;
            }
        } else if (portAudience.startsWith(":") && portAudience.startsWith(portStr = ":" + this.serverPort)) {
            if (portAudience.length() > portStr.length()) {
                char slash = portAudience.charAt(portStr.length());
                return slash == '/';
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean allowedAllAudiences() {
        return this.oidcClientConfig.allowedAllAudiences();
    }

    @Override
    public boolean disableIssChecking() {
        return this.oidcClientConfig.disableIssChecking();
    }
}

