/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.processor.modeler.wsdl;

import com.sun.tools.ws.processor.model.AbstractType;
import com.sun.tools.ws.processor.model.Block;
import com.sun.tools.ws.processor.model.Parameter;
import com.sun.tools.ws.processor.model.java.JavaSimpleType;
import com.sun.tools.ws.processor.model.java.JavaStructureMember;
import com.sun.tools.ws.processor.model.java.JavaStructureType;
import com.sun.tools.ws.processor.model.jaxb.JAXBElementMember;
import com.sun.tools.ws.processor.model.jaxb.JAXBProperty;
import com.sun.tools.ws.processor.model.jaxb.JAXBStructuredType;
import com.sun.tools.ws.processor.model.jaxb.JAXBType;
import com.sun.tools.ws.processor.model.jaxb.JAXBTypeAndAnnotation;
import com.sun.tools.ws.processor.model.jaxb.RpcLitMember;
import com.sun.tools.ws.processor.model.jaxb.RpcLitStructure;
import com.sun.tools.ws.resources.ModelerMessages;
import com.sun.tools.ws.util.ClassNameInfo;
import com.sun.tools.ws.wscompile.AbortException;
import com.sun.tools.ws.wscompile.ErrorReceiverFilter;
import com.sun.tools.ws.wsdl.document.Message;
import com.sun.tools.ws.wsdl.document.MessagePart;
import com.sun.tools.xjc.api.S2JJAXBModel;
import com.sun.tools.xjc.api.TypeAndAnnotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;

class ModelerUtils {
    ModelerUtils() {
    }

    public static JAXBStructuredType createJAXBStructureType(JAXBType jaxbType) {
        JAXBStructuredType type = new JAXBStructuredType(jaxbType);
        type.setName(jaxbType.getName());
        type.setJavaType(jaxbType.getJavaType());
        return type;
    }

    public static List<Parameter> createUnwrappedParameters(JAXBType jaxbType, Block block) {
        ArrayList<Parameter> paramList = new ArrayList<Parameter>();
        JAXBStructuredType type = null;
        type = !(jaxbType instanceof JAXBStructuredType) ? ModelerUtils.createJAXBStructureType(jaxbType) : (JAXBStructuredType)jaxbType;
        JavaStructureType jst = new JavaStructureType(jaxbType.getJavaType().getRealName(), true, type);
        type.setJavaType(jst);
        block.setType(type);
        List<JAXBProperty> memberList = jaxbType.getWrapperChildren();
        for (JAXBProperty prop : memberList) {
            paramList.add(ModelerUtils.createUnwrappedParameter(prop, jaxbType, block, type, jst));
        }
        return paramList;
    }

    private static Parameter createUnwrappedParameter(JAXBProperty prop, JAXBType jaxbType, Block block, JAXBStructuredType type, JavaStructureType jst) {
        QName elementName = prop.getElementName();
        JavaSimpleType javaType = new JavaSimpleType(prop.getType());
        JAXBElementMember eType = new JAXBElementMember(elementName, jaxbType);
        JavaStructureMember jsm = new JavaStructureMember(elementName.getLocalPart(), javaType, eType);
        eType.setJavaStructureMember(jsm);
        jst.add(jsm);
        eType.setProperty(prop);
        type.add(eType);
        JAXBType t = new JAXBType(elementName, javaType, jaxbType.getJaxbMapping(), jaxbType.getJaxbModel());
        t.setUnwrapped(true);
        Parameter parameter = ModelerUtils.createParameter(elementName.getLocalPart(), t, block);
        parameter.setEmbedded(true);
        return parameter;
    }

    public static List<Parameter> createRpcLitParameters(Message message, Block block, S2JJAXBModel jaxbModel, ErrorReceiverFilter errReceiver) {
        RpcLitStructure rpcStruct = (RpcLitStructure)block.getType();
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (MessagePart part : message.getParts()) {
            if (!ModelerUtils.isBoundToSOAPBody(part)) continue;
            QName name = part.getDescriptor();
            TypeAndAnnotation typeAndAnn = jaxbModel.getJavaType(name);
            if (typeAndAnn == null) {
                String msgQName = "{" + message.getDefining().getTargetNamespaceURI() + "}" + message.getName();
                errReceiver.error(part.getLocator(), ModelerMessages.WSDLMODELER_RPCLIT_UNKOWNSCHEMATYPE(name.toString(), part.getName(), msgQName));
                throw new AbortException();
            }
            String type = typeAndAnn.getTypeClass().fullName();
            type = ClassNameInfo.getGenericClass(type);
            RpcLitMember param = new RpcLitMember(new QName("", part.getName()), type);
            JavaSimpleType javaType = new JavaSimpleType(new JAXBTypeAndAnnotation(typeAndAnn));
            param.setJavaType(javaType);
            rpcStruct.addRpcLitMember(param);
            Parameter parameter = ModelerUtils.createParameter(part.getName(), param, block);
            parameter.setEmbedded(true);
            parameters.add(parameter);
        }
        return parameters;
    }

    public static Parameter createParameter(String partName, AbstractType jaxbType, Block block) {
        Parameter parameter = new Parameter(partName, block.getEntity());
        parameter.setProperty("com.sun.xml.ws.processor.model.ParamMessagePartName", partName);
        parameter.setEmbedded(false);
        parameter.setType(jaxbType);
        parameter.setTypeName(jaxbType.getJavaType().getType().getName());
        parameter.setBlock(block);
        return parameter;
    }

    public static Parameter getParameter(String paramName, List<Parameter> parameters) {
        if (parameters == null) {
            return null;
        }
        for (Parameter param : parameters) {
            if (!param.getName().equals(paramName)) continue;
            return param;
        }
        return null;
    }

    public static boolean isEquivalentLiteralStructures(JAXBStructuredType struct1, JAXBStructuredType struct2) {
        if (struct1.getElementMembersCount() != struct2.getElementMembersCount()) {
            return false;
        }
        Iterator members = struct1.getElementMembers();
        int i = 0;
        while (members.hasNext()) {
            JAXBElementMember member1 = (JAXBElementMember)members.next();
            JavaStructureMember javaMember1 = member1.getJavaStructureMember();
            JavaStructureMember javaMember2 = ((JavaStructureType)struct2.getJavaType()).getMemberByName(member1.getJavaStructureMember().getName());
            if (javaMember2.getConstructorPos() != i || !javaMember1.getType().equals(javaMember2.getType())) {
                return false;
            }
            ++i;
        }
        return false;
    }

    public static QName getRawTypeName(Parameter parameter) {
        JAXBType jt;
        String name = parameter.getName();
        if (parameter.getType() instanceof JAXBType && (jt = (JAXBType)parameter.getType()).isUnwrappable()) {
            List<JAXBProperty> props = jt.getWrapperChildren();
            for (JAXBProperty prop : props) {
                if (!prop.getName().equals(name)) continue;
                return prop.getRawTypeName();
            }
        }
        return null;
    }

    public static boolean isBoundToMimeContent(MessagePart part) {
        return part != null && part.getBindingExtensibilityElementKind() == 5;
    }

    public static boolean isBoundToSOAPBody(MessagePart part) {
        return part != null && part.getBindingExtensibilityElementKind() == 1;
    }

    public static boolean isBoundToSOAPHeader(MessagePart part) {
        return part != null && part.getBindingExtensibilityElementKind() == 2;
    }

    public static boolean isUnbound(MessagePart part) {
        return part != null && part.getBindingExtensibilityElementKind() == -1;
    }
}

