/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.Collection;
import com.ibm.ws.objectManager.Iterator;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.Token;
import com.ibm.ws.objectManager.Transaction;
import com.ibm.ws.objectManager.utils.Printable;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import java.io.PrintWriter;
import java.util.NoSuchElementException;

abstract class AbstractCollectionView
implements Collection,
Printable {
    private static final Class cclass = AbstractCollectionView.class;
    private static Trace trace = ObjectManager.traceFactory.getTrace(AbstractCollectionView.class, "ObjectManagerObjects");

    protected AbstractCollectionView() {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "<init>");
            trace.exit(this, cclass, "<init>");
        }
    }

    @Override
    public abstract Iterator iterator() throws ObjectManagerException;

    @Override
    public long size(Transaction transaction) throws ObjectManagerException {
        long size = 0L;
        Iterator iterator = this.iterator();
        while (iterator.hasNext(transaction) && ++size != Long.MAX_VALUE) {
            iterator.next(transaction);
        }
        return size;
    }

    @Override
    public long size() throws ObjectManagerException {
        long size = 0L;
        Iterator iterator = this.iterator();
        while (iterator.hasNext() && ++size != Long.MAX_VALUE) {
            iterator.next();
        }
        return size;
    }

    @Override
    public boolean isEmpty(Transaction transaction) throws ObjectManagerException {
        return !this.iterator().hasNext(transaction);
    }

    @Override
    public boolean contains(Token token, Transaction transaction) throws ObjectManagerException {
        try {
            Iterator iterator = this.iterator();
            while (iterator.next(transaction) != token) {
            }
            return true;
        }
        catch (NoSuchElementException exception) {
            return false;
        }
    }

    @Override
    public synchronized Token[] toArray(Transaction transaction) throws ObjectManagerException {
        Token[] tokens = new Token[(int)this.size(transaction)];
        int i = 0;
        try {
            Iterator iterator = this.iterator();
            while (true) {
                tokens[i++] = (Token)iterator.next(transaction);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return tokens;
        }
    }

    @Override
    public boolean add(Token token, Transaction transaction) throws ObjectManagerException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Token token, Transaction transaction) throws ObjectManagerException {
        try {
            Iterator iterator = this.iterator();
            while (iterator.next(transaction) != token) {
            }
            iterator.remove(transaction);
            return true;
        }
        catch (NoSuchElementException exception) {
            return false;
        }
    }

    @Override
    public boolean containsAll(Collection otherCollection, Transaction transaction) throws ObjectManagerException {
        try {
            Iterator iterator = otherCollection.iterator();
            while (this.contains((Token)iterator.next(transaction), transaction)) {
            }
            return false;
        }
        catch (NoSuchElementException exception) {
            return true;
        }
    }

    @Override
    public boolean addAll(Collection otherCollection, Transaction transaction) throws ObjectManagerException {
        boolean modified = false;
        try {
            Iterator iterator = otherCollection.iterator();
            while (true) {
                modified = this.add((Token)iterator.next(transaction), transaction);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return modified;
        }
    }

    @Override
    public boolean removeAll(Collection otherCollection, Transaction transaction) throws ObjectManagerException {
        boolean modified = false;
        try {
            Iterator iterator = this.iterator();
            while (true) {
                if (!otherCollection.contains((Token)iterator.next(transaction), transaction)) {
                    continue;
                }
                iterator.remove(transaction);
                modified = true;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return modified;
        }
    }

    @Override
    public boolean retainAll(Collection otherCollection, Transaction transaction) throws ObjectManagerException {
        boolean modified = false;
        try {
            Iterator iterator = this.iterator();
            while (true) {
                if (otherCollection.contains((Token)iterator.next(transaction), transaction)) {
                    continue;
                }
                iterator.remove(transaction);
                modified = true;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return modified;
        }
    }

    @Override
    public void clear(Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "clear", new Object[]{transaction});
        }
        try {
            Iterator iterator = this.iterator();
            while (true) {
                iterator.next(transaction);
                iterator.remove(transaction);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "clear");
            }
            return;
        }
    }

    @Override
    public synchronized void print(PrintWriter printWriter) {
        try {
            printWriter.println("State Dump for:" + cclass.getName() + "\n size()=" + this.size() + "(long) size(null)=" + this.size(null) + "(long)");
            printWriter.println();
            printWriter.println("Tokens in order...");
            try {
                Iterator iterator = this.iterator();
                while (true) {
                    printWriter.println(((Token)iterator.next(null)).toString());
                }
            }
            catch (NoSuchElementException iterator) {
            }
        }
        catch (ObjectManagerException objectManagerException) {
            printWriter.println("Caught objectManagerException=" + objectManagerException);
            objectManagerException.printStackTrace(printWriter);
        }
        printWriter.println();
    }
}

