/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.servlet;

import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.jboss.resteasy.plugins.server.servlet.ListenerBootstrap;
import org.jboss.resteasy.spi.ResteasyDeployment;

public class FilterBootstrap
extends ListenerBootstrap {
    private FilterConfig config;

    public FilterBootstrap(FilterConfig config) {
        super(config.getServletContext());
        this.config = config;
    }

    @Override
    public ResteasyDeployment createDeployment() {
        ResteasyDeployment deployment = super.createDeployment();
        deployment.getDefaultContextObjects().put(FilterConfig.class, this.config);
        deployment.getDefaultContextObjects().put(ServletContext.class, this.config.getServletContext());
        return deployment;
    }

    @Override
    public String getInitParameter(String name) {
        String value = this.config.getInitParameter(name);
        if (value == null) {
            value = super.getInitParameter(name);
        }
        return value;
    }

    @Override
    public Set<String> getParameterNames() {
        Set<String> set = super.getInitParameterNames();
        Enumeration en = this.config.getInitParameterNames();
        while (en.hasMoreElements()) {
            set.add((String)en.nextElement());
        }
        return set;
    }

    @Override
    public Set<String> getInitParameterNames() {
        HashSet<String> set = new HashSet<String>();
        Enumeration en = this.config.getInitParameterNames();
        while (en.hasMoreElements()) {
            set.add((String)en.nextElement());
        }
        return set;
    }
}

