/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token.ltpa.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.auth.InvalidTokenException;
import com.ibm.websphere.security.auth.TokenExpiredException;
import com.ibm.ws.common.crypto.CryptoUtils;
import com.ibm.ws.common.encoder.Base64Coder;
import com.ibm.ws.crypto.ltpakeyutil.LTPAKeyUtil;
import com.ibm.ws.crypto.ltpakeyutil.LTPAPrivateKey;
import com.ibm.ws.crypto.ltpakeyutil.LTPAPublicKey;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.token.ltpa.internal.LTPATokenizer;
import com.ibm.ws.security.token.ltpa.internal.UserData;
import com.ibm.wsspi.security.ltpa.Token;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import javax.crypto.BadPaddingException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LTPAToken2
implements Token,
Serializable {
    private static final boolean fipsEnabled = CryptoUtils.isFips140_3Enabled();
    private static final TraceComponent tc = Tr.register(LTPAToken2.class, (String)"Token", (String)"com.ibm.ws.security.token.ltpa.internal.resources.LTPAMessages");
    private static final long serialVersionUID = 1L;
    private static final String DELIM = "%";
    private static final MessageDigest md1JCE;
    private static final MessageDigest md2JCE;
    private static final Object lockObj1;
    private static final Object lockObj2;
    private final short version = 1;
    private byte[] signature;
    private byte[] encryptedBytes = null;
    private UserData userData;
    private long expirationInMilliseconds;
    private final byte[] sharedKey;
    private final LTPAPrivateKey privateKey;
    private final LTPAPublicKey publicKey;
    private String cipher = null;
    private long expirationDifferenceAllowed;

    public LTPAToken2(byte[] tokenBytes, @Sensitive byte[] sharedKey, LTPAPrivateKey privateKey, LTPAPublicKey publicKey, long expDiffAllowed) throws InvalidTokenException {
        LTPAToken2.checkTokenBytes(tokenBytes);
        this.signature = null;
        this.encryptedBytes = (byte[])tokenBytes.clone();
        this.sharedKey = (byte[])sharedKey.clone();
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.expirationInMilliseconds = 0L;
        this.cipher = "AES/CBC/PKCS5Padding";
        this.expirationDifferenceAllowed = expDiffAllowed;
        this.decrypt();
    }

    public LTPAToken2(byte[] tokenBytes, @Sensitive byte[] sharedKey, LTPAPrivateKey privateKey, LTPAPublicKey publicKey, long expDiffAllowed, String ... attributes) throws InvalidTokenException, TokenExpiredException {
        LTPAToken2.checkTokenBytes(tokenBytes);
        this.signature = null;
        this.encryptedBytes = (byte[])tokenBytes.clone();
        this.sharedKey = (byte[])sharedKey.clone();
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.expirationInMilliseconds = 0L;
        this.cipher = "AES/CBC/PKCS5Padding";
        this.expirationDifferenceAllowed = expDiffAllowed;
        this.decrypt();
        this.isValid();
        if (attributes != null) {
            this.signature = null;
            this.encryptedBytes = null;
            this.userData.removeAttributes(attributes);
        }
    }

    protected LTPAToken2(String accessID, long expirationInMinutes, @Sensitive byte[] sharedKey, LTPAPrivateKey privateKey, LTPAPublicKey publicKey) {
        this.signature = null;
        this.encryptedBytes = null;
        this.sharedKey = (byte[])sharedKey.clone();
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.userData = new UserData(accessID);
        this.setExpiration(expirationInMinutes);
        this.cipher = "AES/CBC/PKCS5Padding";
    }

    protected LTPAToken2(long expirationInMinutes, @Sensitive byte[] sharedKey, LTPAPrivateKey privateKey, LTPAPublicKey publicKey, UserData userdata) {
        this.signature = null;
        this.encryptedBytes = null;
        this.sharedKey = (byte[])sharedKey.clone();
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.userData = userdata;
        this.setExpiration(expirationInMinutes);
        this.cipher = "AES/CBC/PKCS5Padding";
    }

    /*
     * WARNING - void declaration
     */
    private final void encrypt() throws Exception {
        int i;
        String signStr = Base64Coder.toString((byte[])Base64Coder.base64Encode((byte[])this.signature));
        String ud = this.userData.toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("encrypt: userData" + ud), (Object[])new Object[0]);
        }
        byte[] accessID = Base64Coder.getBytes((String)ud);
        StringBuilder sb = new StringBuilder(DELIM);
        sb.append(this.getExpiration()).append(DELIM).append(signStr);
        byte[] timeAndSign = LTPAToken2.getSimpleBytes(sb.toString());
        byte[] toBeEnc = new byte[accessID.length + timeAndSign.length];
        for (i = 0; i < accessID.length; ++i) {
            toBeEnc[i] = accessID[i];
        }
        for (i = accessID.length; i < toBeEnc.length; ++i) {
            toBeEnc[i] = timeAndSign[i - accessID.length];
        }
        try {
            this.encryptedBytes = LTPAKeyUtil.encrypt((byte[])toBeEnc, (byte[])this.sharedKey, (String)this.cipher);
        }
        catch (Exception i2) {
            void e;
            FFDCFilter.processException((Throwable)i2, (String)"com.ibm.ws.security.token.ltpa.internal.LTPAToken2", (String)"196", (Object)this, (Object[])new Object[0]);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Error encrypting; " + e), (Object[])new Object[0]);
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Encrypted bytes are: " + (this.encryptedBytes == null ? "" : Base64Coder.toString((byte[])Base64Coder.base64Encode((byte[])this.encryptedBytes)))), (Object[])new Object[0]);
        }
    }

    @FFDCIgnore(value={BadPaddingException.class, Exception.class})
    private final void decrypt() throws InvalidTokenException {
        try {
            byte[] tokenData = LTPAKeyUtil.decrypt((byte[])((byte[])this.encryptedBytes.clone()), (byte[])this.sharedKey, (String)this.cipher);
            LTPAToken2.checkTokenBytes(tokenData);
            String UTF8TokenString = LTPAToken2.toUTF8String(tokenData);
            String[] userFields = LTPATokenizer.parseToken(UTF8TokenString);
            Map<String, ArrayList<String>> attribs = LTPATokenizer.parseUserData(userFields[0]);
            this.userData = new UserData(attribs);
            String tokenString = LTPAToken2.toSimpleString(tokenData);
            String[] fields = LTPATokenizer.parseToken(tokenString);
            String[] expirationArray = this.userData.getAttributes("expire");
            if (expirationArray != null && expirationArray[expirationArray.length - 1] != null) {
                this.expirationInMilliseconds = Long.parseLong(expirationArray[expirationArray.length - 1]);
                if (fields.length == 3 && this.expirationDifferenceAllowed >= 0L && Math.abs(this.expirationInMilliseconds - Long.parseLong(fields[1])) > this.expirationDifferenceAllowed) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("Token validation failed due to the expiration fields having a difference greater than: " + this.expirationDifferenceAllowed + " milliseconds\nfirst field expiration: " + this.expirationInMilliseconds + " milliseconds\nsecond field expiration: " + fields[1] + " milliseconds"), (Object[])new Object[0]);
                    }
                    throw new InvalidTokenException("Token Validation Failed");
                }
            } else {
                this.expirationInMilliseconds = Long.parseLong(fields[1]);
            }
            byte[] signature = Base64Coder.base64Decode((byte[])Base64Coder.getBytes((String)fields[fields.length - 1]));
            this.setSignature(signature);
        }
        catch (BadPaddingException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"Caught BadPaddingException while decrypting token, this is only a critical problem if decryption should have worked.", (Object[])new Object[]{e});
            }
            throw new InvalidTokenException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Error decrypting; " + e), (Object[])new Object[0]);
            }
            throw new InvalidTokenException(e.getMessage(), (Throwable)e);
        }
    }

    private final void sign() throws Exception {
        String dataStr = this.getUserData().toString();
        byte[] data = Base64Coder.getBytes((String)dataStr);
        byte[] signature = this.sign(data, this.privateKey);
        this.setSignature(signature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] sign(byte[] msg, LTPAPrivateKey privKey) throws Exception {
        byte[] data;
        Object object = lockObj1;
        synchronized (object) {
            data = md1JCE.digest(msg);
        }
        byte[][] rsaPrivKey = LTPAKeyUtil.getRawKey((LTPAPrivateKey)privKey);
        LTPAKeyUtil.setRSAKey((byte[][])rsaPrivKey);
        byte[] signature = LTPAKeyUtil.signISO9796((byte[][])rsaPrivKey, (byte[])data, (int)0, (int)data.length);
        return signature;
    }

    private final boolean verify() throws Exception {
        String dataStr = this.getUserData().toString();
        byte[] data = Base64Coder.getBytes((String)dataStr);
        return this.verify(data, this.signature, this.publicKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean verify(byte[] msg, byte[] signature, LTPAPublicKey pubKey) throws Exception {
        byte[] data;
        if (msg == null) {
            throw new IllegalArgumentException("null message");
        }
        if (signature == null) {
            throw new IllegalArgumentException("null signature");
        }
        Object object = lockObj2;
        synchronized (object) {
            data = md2JCE.digest(msg);
        }
        byte[][] rsaPubKey = LTPAKeyUtil.getRawKey((LTPAPublicKey)pubKey);
        return LTPAKeyUtil.verifyISO9796((byte[][])rsaPubKey, (byte[])data, (int)0, (int)data.length, (byte[])signature, (int)0, (int)signature.length);
    }

    @FFDCIgnore(value={Exception.class})
    public final boolean isValid() throws InvalidTokenException, TokenExpiredException {
        boolean verified = false;
        this.validateExpiration();
        try {
            verified = this.verify();
        }
        catch (Exception e) {
            verified = false;
            throw new InvalidTokenException(e.getMessage(), (Throwable)e);
        }
        if (!verified) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Invalid signature of the token " + this), (Object[])new Object[0]);
            }
            throw new InvalidTokenException("Token Validation Failed");
        }
        return verified;
    }

    public final void validateExpiration() throws TokenExpiredException {
        Date d = new Date();
        Date expD = new Date(this.getExpiration());
        boolean expired = d.after(expD);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Current time = " + d + ", expiration time = " + expD), (Object[])new Object[0]);
        }
        if (expired) {
            String msg = "The token has expired: current time = \"" + d + "\", expire time = \"" + expD + "\"";
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)msg, (Object[])new Object[0]);
            }
            throw new TokenExpiredException(this.expirationInMilliseconds, msg);
        }
    }

    @FFDCIgnore(value={Exception.class})
    public final byte[] getBytes() throws InvalidTokenException, TokenExpiredException {
        if (this.encryptedBytes == null) {
            try {
                this.sign();
                this.encrypt();
            }
            catch (Exception e) {
                throw new InvalidTokenException(e.getMessage(), (Throwable)e);
            }
        }
        return (byte[])this.encryptedBytes.clone();
    }

    public final long getExpiration() {
        return this.expirationInMilliseconds;
    }

    public final short getVersion() {
        return 1;
    }

    public final String[] addAttribute(String name, String value) {
        this.signature = null;
        this.encryptedBytes = null;
        return this.userData.addAttribute(name, value);
    }

    public final String[] getAttributes(String name) {
        return this.userData.getAttributes(name);
    }

    public final Enumeration<String> getAttributeNames() {
        return this.userData.getAttributeNames();
    }

    public final String toString() {
        return this.encryptedBytes == null ? "NULL" : Base64Coder.base64EncodeToString((byte[])this.encryptedBytes);
    }

    public final Object clone() {
        UserData userdata = (UserData)this.userData.clone();
        return new LTPAToken2(this.getExpiration(), this.sharedKey, this.privateKey, this.publicKey, userdata);
    }

    private static final void checkTokenBytes(byte[] tokenBytes) {
        if (tokenBytes == null || tokenBytes.length == 0) {
            throw new IllegalArgumentException("No token bytes specified");
        }
    }

    private final void setSignature(byte[] newValue) {
        this.signature = newValue;
    }

    private final UserData getUserData() {
        return this.userData;
    }

    private final void setExpiration(long expirationInMinutes) {
        this.expirationInMilliseconds = System.currentTimeMillis() + expirationInMinutes * 60L * 1000L;
        this.signature = null;
        if (this.userData != null) {
            this.encryptedBytes = null;
            this.userData.addAttribute("expire", Long.toString(this.expirationInMilliseconds));
        } else {
            this.encryptedBytes = null;
        }
    }

    private static final String toUTF8String(byte[] b) {
        return new String(b, StandardCharsets.UTF_8);
    }

    private static final String toSimpleString(byte[] b) {
        StringBuilder sb = new StringBuilder();
        int len = b.length;
        for (int i = 0; i < len; ++i) {
            sb.append((char)(b[i] & 0xFF));
        }
        String str = sb.toString();
        return str;
    }

    private static final byte[] getSimpleBytes(String str) {
        StringBuilder sb = new StringBuilder(str);
        byte[] b = new byte[sb.length()];
        int len = sb.length();
        for (int i = 0; i < len; ++i) {
            b[i] = (byte)sb.charAt(i);
        }
        return b;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        MessageDigest m1 = null;
        MessageDigest m2 = null;
        m1 = CryptoUtils.getMessageDigestForLTPA();
        m2 = CryptoUtils.getMessageDigestForLTPA();
        md1JCE = m1;
        md2JCE = m2;
        lockObj1 = new Object();
        lockObj2 = new Object();
    }
}

