/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import java.util.Set;
import javax.annotation.Priority;
import org.jboss.weld.bootstrap.api.BootstrapService;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.util.reflection.Reflections;

public final class Services {
    private static final int DEFAULT_PLATFORM_PRIORITY = 4500;

    private Services() {
    }

    public static Set<Class<? extends Service>> identifyServiceInterfaces(Class<?> clazz, Set<Class<? extends Service>> serviceInterfaces) {
        if (clazz == null || Object.class.equals(clazz) || BootstrapService.class.equals(clazz)) {
            return serviceInterfaces;
        }
        for (Class<?> interfac3 : clazz.getInterfaces()) {
            if (!Service.class.equals(interfac3) && !BootstrapService.class.equals(interfac3)) continue;
            serviceInterfaces.add((Class)Reflections.cast(clazz));
        }
        for (Class<?> interfac3 : clazz.getInterfaces()) {
            Services.identifyServiceInterfaces(interfac3, serviceInterfaces);
        }
        Services.identifyServiceInterfaces(clazz.getSuperclass(), serviceInterfaces);
        return serviceInterfaces;
    }

    public static <T extends Service> void put(ServiceRegistry registry, Class<T> key, Service value) {
        T previous = registry.get(key);
        if (previous == null) {
            BootstrapLogger.LOG.debugv("Installing additional service {0} ({1})", key.getName(), value.getClass());
            registry.add(key, (Service)Reflections.cast(value));
        } else if (Services.shouldOverride(key, previous, value)) {
            BootstrapLogger.LOG.debugv("Overriding service implementation for {0}. Previous implementation {1} is replaced with {2}", key.getName(), previous.getClass().getName(), value.getClass().getName());
            registry.add(key, (Service)Reflections.cast(value));
        }
    }

    private static boolean shouldOverride(Class<? extends Service> key, Service previous, Service next) {
        return Services.getPriority(next) > Services.getPriority(previous);
    }

    private static int getPriority(Service service) {
        Priority priority = service.getClass().getAnnotation(Priority.class);
        if (priority != null) {
            return priority.value();
        }
        return 4500;
    }
}

